/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPickManager;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.impl.VcsLogUtil;
import icons.DvcsImplIcons;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCherryPickAction
extends DumbAwareAction {
    private static final String NAME = "Cherry-Pick";

    public VcsCherryPickAction() {
        super(NAME, null, DvcsImplIcons.CherryPick);
    }

    public void actionPerformed(AnActionEvent e) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        VcsCherryPickManager.getInstance(project2).cherryPick(log);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "update"));
        }
        super.update(e);
        e.getPresentation().setVisible(true);
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        Project project2 = e.getProject();
        if (project2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsCherryPickManager cherryPickManager = VcsCherryPickManager.getInstance(project2);
        List<VcsCherryPicker> cherryPickers = VcsCherryPickAction.getActiveCherryPickersForProject(project2);
        if (log == null || cherryPickers.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List<CommitId> commits = VcsLogUtil.collectFirstPack(log.getSelectedCommits(), 1000);
        if (commits.isEmpty() || cherryPickManager.isCherryPickAlreadyStartedFor(commits)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        VcsCherryPicker enabledCherryPicker = VcsCherryPickAction.getEnabledCherryPicker(log, cherryPickers, commits);
        e.getPresentation().setEnabled(enabledCherryPicker != null);
        e.getPresentation().setText(enabledCherryPicker == null ? VcsCherryPickAction.concatActionNamesForAllAvailable(cherryPickers) : enabledCherryPicker.getActionTitle());
    }

    @Nullable
    private static VcsCherryPicker getEnabledCherryPicker(final @NotNull VcsLog log, @NotNull List<VcsCherryPicker> cherryPickers, @NotNull List<CommitId> commits) {
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getEnabledCherryPicker"));
        }
        if (cherryPickers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cherryPickers", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getEnabledCherryPicker"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getEnabledCherryPicker"));
        }
        final Map<VirtualFile, List<Hash>> groupedByRoot = VcsCherryPickAction.groupByRoot(commits);
        return (VcsCherryPicker)ContainerUtil.find(cherryPickers, (Condition)new Condition<VcsCherryPicker>(){

            public boolean value(VcsCherryPicker picker) {
                return picker.isEnabled(log, groupedByRoot);
            }
        });
    }

    @NotNull
    private static Map<VirtualFile, List<Hash>> groupByRoot(@NotNull List<CommitId> details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "groupByRoot"));
        }
        HashMap result2 = ContainerUtil.newHashMap();
        for (CommitId commit : details) {
            List hashes = (List)result2.get(commit.getRoot());
            if (hashes == null) {
                hashes = ContainerUtil.newArrayList();
                result2.put(commit.getRoot(), hashes);
            }
            hashes.add(commit.getHash());
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "groupByRoot"));
        }
        return hashMap;
    }

    @NotNull
    private static String concatActionNamesForAllAvailable(@NotNull List<VcsCherryPicker> pickers) {
        if (pickers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pickers", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "concatActionNamesForAllAvailable"));
        }
        String string = StringUtil.join(pickers, (Function)new Function<VcsCherryPicker, String>(){

            public String fun(VcsCherryPicker picker) {
                return picker.getActionTitle();
            }
        }, (String)"/");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "concatActionNamesForAllAvailable"));
        }
        return string;
    }

    @NotNull
    private static List<VcsCherryPicker> getActiveCherryPickersForProject(final @Nullable Project project2) {
        if (project2 != null) {
            ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
            Object[] vcss = projectLevelVcsManager.getAllActiveVcss();
            List list = ContainerUtil.mapNotNull((Object[])vcss, (Function)new Function<AbstractVcs, VcsCherryPicker>(){

                public VcsCherryPicker fun(AbstractVcs vcs) {
                    return vcs != null ? VcsCherryPickManager.getInstance(project2).getCherryPickerFor(vcs.getKeyInstanceMethod()) : null;
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getActiveCherryPickersForProject"));
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getActiveCherryPickersForProject"));
        }
        return list;
    }
}

