/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.SearchTextArea;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindPopupPanel
extends JBPanel {
    private static final Logger LOG = Logger.getInstance(FindPopupPanel.class);
    private static final KeyStroke OK_KEYSTROKE = KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128);
    private static final KeyStroke MOVE_CARET_DOWN = KeyStroke.getKeyStroke(40, 0);
    private static final KeyStroke MOVE_CARET_UP = KeyStroke.getKeyStroke(38, 0);
    private static final KeyStroke NEW_LINE = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke MOVE_CARET_DOWN_ALTERNATIVE = KeyStroke.getKeyStroke(40, 512);
    private static final KeyStroke MOVE_CARET_UP_ALTERNATIVE = KeyStroke.getKeyStroke(38, 512);
    private static final KeyStroke NEW_LINE_ALTERNATIVE = KeyStroke.getKeyStroke(10, 512);
    protected static final String SIZE_KEY = "find.popup";
    private JComponent myCodePreviewComponent;
    private SearchTextArea mySearchTextArea;
    private SearchTextArea myReplaceTextArea;
    private ActionListener myOkActionListener;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FindModel myModel;
    @NotNull
    private final DataContext myDataContext;
    @NotNull
    private final Disposable myDisposable;
    private Alarm mySearchRescheduleOnCancellationsAlarm;
    private Alarm myUpdateResultsPopupBoundsAlarm;
    private volatile ProgressIndicatorBase myResultsPreviewSearchProgress;
    private JLabel myTitleLabel;
    private StateRestoringCheckBox myCbCaseSensitive;
    private StateRestoringCheckBox myCbPreserveCase;
    private StateRestoringCheckBox myCbWholeWordsOnly;
    private StateRestoringCheckBox myCbRegularExpressions;
    private StateRestoringCheckBox myCbFileFilter;
    private ActionToolbarImpl myScopeSelectionToolbar;
    private TextFieldWithAutoCompletion<String> myFileMaskField;
    private ArrayList<String> myFileMasks;
    private ActionButton myFilterContextButton;
    private ActionButton myTabResultsButton;
    private JButton myOKButton;
    private JTextArea mySearchComponent;
    private JTextArea myReplaceComponent;
    private String mySelectedContextName;
    private Scope mySelectedScope;
    private JPanel myScopeDetailsPanel;
    private ComboBox myModuleComboBox;
    private ComboBox myDirectoryComboBox;
    private FixedSizeButton mySelectDirectoryButton;
    private JToggleButton myRecursiveDirectoryButton;
    private ScopeChooserCombo myScopeCombo;
    private JBTable myResultsPreviewTable;
    private UsagePreviewPanel myUsagePreviewPanel;
    private JBPopup myFindBalloon;
    private AbstractPopup myResultsPopup;

    static void showBalloon(@NotNull Project project2, @NotNull FindModel model, @NotNull DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindPopupPanel", "showBalloon"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindPopupPanel", "showBalloon"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/find/impl/FindPopupPanel", "showBalloon"));
        }
        FindPopupPanel panel = new FindPopupPanel(project2, model, dataContext);
        panel.doShowBalloon();
    }

    private void doShowBalloon() {
        if (this.myFindBalloon != null && this.myFindBalloon.isVisible()) {
            return;
        }
        if (this.myFindBalloon != null && !this.myFindBalloon.isDisposed()) {
            this.myFindBalloon.cancel();
        }
        if (this.myFindBalloon == null || this.myFindBalloon.isDisposed()) {
            RelativePoint showPoint;
            ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this), this.getPreferredFocusedComponent());
            this.myFindBalloon = builder.setProject(this.myProject).setMayBeParent(true).setModalContext(false).setRequestFocus(true).createPopup();
            Disposer.register((Disposable)this.myFindBalloon, (Disposable)this.myDisposable);
            this.registerCloseAction(this.myFindBalloon);
            this.myFindBalloon.getContent().setBorder((Border)JBUI.Borders.empty());
            Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
            Component parent = UIUtil.findUltimateParent((Component)window);
            if (parent != null) {
                int height;
                int n = height = UISettings.getInstance().SHOW_MAIN_TOOLBAR ? 135 : 115;
                if (parent instanceof IdeFrameImpl && ((IdeFrameImpl)parent).isInFullScreen()) {
                    height -= 20;
                }
                showPoint = new RelativePoint(parent, new Point((parent.getSize().width - this.getPreferredSize().width) / 2, height));
            } else {
                showPoint = JBPopupFactory.getInstance().guessBestPopupLocation(this.myDataContext);
            }
            this.mySearchComponent.selectAll();
            this.myFindBalloon.show(showPoint);
            this.myFindBalloon.pack(true, true);
        }
    }

    private FindPopupPanel(@NotNull Project project2, @NotNull FindModel model, @NotNull DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindPopupPanel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindPopupPanel", "<init>"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/find/impl/FindPopupPanel", "<init>"));
        }
        this.myFileMasks = new ArrayList();
        this.mySelectedContextName = FindBundle.message("find.context.anywhere.scope.label", new Object[0]);
        this.mySelectedScope = Scope.PROJECT;
        this.myProject = project2;
        this.myModel = model;
        this.myDataContext = dataContext;
        this.myDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FindPopupPanel.this.finishPreviousPreviewSearch();
                if (FindPopupPanel.this.mySearchRescheduleOnCancellationsAlarm != null) {
                    Disposer.dispose((Disposable)FindPopupPanel.this.mySearchRescheduleOnCancellationsAlarm);
                }
                if (FindPopupPanel.this.myUpdateResultsPopupBoundsAlarm != null) {
                    Disposer.dispose((Disposable)FindPopupPanel.this.myUpdateResultsPopupBoundsAlarm);
                }
                if (FindPopupPanel.this.myUsagePreviewPanel != null) {
                    Disposer.dispose((Disposable)FindPopupPanel.this.myUsagePreviewPanel);
                }
            }
        });
        this.initComponents();
        this.initByModel();
        this.updateReplaceVisibility();
        ApplicationManager.getApplication().invokeLater(() -> this.scheduleResultsUpdate(), ModalityState.any());
    }

    private void initComponents() {
        this.myTitleLabel = new JBLabel(FindBundle.message("find.in.path.dialog.title", new Object[0]), UIUtil.ComponentStyle.REGULAR);
        this.myTitleLabel.setFont(this.myTitleLabel.getFont().deriveFont(1));
        this.myCbCaseSensitive = FindDialog.createCheckbox(FindBundle.message("find.popup.case.sensitive", new Object[0]));
        ItemListener liveResultsPreviewUpdateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        };
        this.myCbCaseSensitive.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbPreserveCase = FindDialog.createCheckbox(FindBundle.message("find.options.replace.preserve.case", new Object[0]));
        this.myCbPreserveCase.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbPreserveCase.setVisible(this.myModel.isReplaceState());
        this.myCbWholeWordsOnly = FindDialog.createCheckbox(FindBundle.message("find.popup.whole.words", new Object[0]));
        this.myCbWholeWordsOnly.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbRegularExpressions = FindDialog.createCheckbox(FindBundle.message("find.popup.regex", new Object[0]));
        this.myCbRegularExpressions.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbFileFilter = FindDialog.createCheckbox("");
        this.myCbFileFilter.setMargin(new Insets(0, 0, 0, 0));
        this.myCbFileFilter.setBorder(null);
        this.myCbFileFilter.addItemListener(liveResultsPreviewUpdateListener);
        this.myFileMaskField = new TextFieldWithAutoCompletion<String>(this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(this.myFileMasks, null), false, null){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.setBackground(enabled ? JBColor.background() : UIUtil.getComboBoxDisabledBackground());
            }
        };
        this.myFileMaskField.setPreferredWidth(JBUI.scale((int)100));
        this.myFileMaskField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent e) {
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        });
        this.myCbFileFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FindPopupPanel.this.myFileMaskField.setEnabled(FindPopupPanel.this.myCbFileFilter.isSelected());
            }
        });
        DefaultActionGroup switchContextGroup = new DefaultActionGroup();
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.ANY));
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_COMMENTS));
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_STRING_LITERALS));
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS));
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_STRING_LITERALS));
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS));
        switchContextGroup.setPopup(true);
        Presentation filterPresentation = new Presentation();
        filterPresentation.setIcon(AllIcons.General.Filter);
        this.myFilterContextButton = new ActionButton((AnAction)switchContextGroup, filterPresentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            @Override
            public int getPopState() {
                int state = super.getPopState();
                if (state != 0) {
                    return state;
                }
                return FindPopupPanel.this.mySelectedContextName.equals(FindDialog.getPresentableName(FindModel.SearchContext.ANY)) ? 0 : -1;
            }
        };
        DefaultActionGroup tabResultsContextGroup = new DefaultActionGroup();
        tabResultsContextGroup.add((AnAction)new ToggleAction(FindBundle.message("find.options.skip.results.tab.with.one.usage.checkbox", new Object[0])){

            public boolean isSelected(AnActionEvent e) {
                return FindSettings.getInstance().isSkipResultsWithOneUsage();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                FindSettings.getInstance().setSkipResultsWithOneUsage(state);
            }
        });
        tabResultsContextGroup.add((AnAction)new ToggleAction(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0])){

            public boolean isSelected(AnActionEvent e) {
                return FindSettings.getInstance().isShowResultsInSeparateView();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                FindSettings.getInstance().setShowResultsInSeparateView(state);
            }
        });
        tabResultsContextGroup.setPopup(true);
        Presentation tabSettingsPresentation = new Presentation();
        tabSettingsPresentation.setIcon(AllIcons.General.SecondaryGroup);
        this.myTabResultsButton = new ActionButton((AnAction)tabResultsContextGroup, tabSettingsPresentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.myOKButton = new JButton(FindBundle.message("find.popup.find.button", new Object[0]));
        this.myOkActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindPopupPanel.this.findSettingsChanged();
                FindInProjectManager.getInstance(FindPopupPanel.this.myProject).startFindInProject(FindPopupPanel.this.myModel);
                Disposer.dispose((Disposable)FindPopupPanel.this.myFindBalloon);
            }
        };
        this.myOKButton.addActionListener(this.myOkActionListener);
        this.registerKeyboardAction(this.myOkActionListener, OK_KEYSTROKE, 2);
        this.mySearchComponent = new JTextArea();
        this.mySearchComponent.setColumns(25);
        this.mySearchComponent.setRows(1);
        this.myReplaceComponent = new JTextArea();
        this.myReplaceComponent.setColumns(25);
        this.myReplaceComponent.setRows(1);
        this.mySearchTextArea = new SearchTextArea(this.mySearchComponent, true);
        this.myReplaceTextArea = new SearchTextArea(this.myReplaceComponent, false);
        com.intellij.ui.DocumentAdapter documentAdapter = new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                int searchRows1 = FindPopupPanel.this.mySearchComponent.getRows();
                int searchRows2 = Math.max(1, Math.min(3, StringUtil.countChars((CharSequence)FindPopupPanel.this.mySearchComponent.getText(), (char)'\n') + 1));
                FindPopupPanel.this.mySearchComponent.setRows(searchRows2);
                int replaceRows1 = FindPopupPanel.this.myReplaceComponent.getRows();
                int replaceRows2 = Math.max(1, Math.min(3, StringUtil.countChars((CharSequence)FindPopupPanel.this.myReplaceComponent.getText(), (char)'\n') + 1));
                FindPopupPanel.this.myReplaceComponent.setRows(replaceRows2);
                if (FindPopupPanel.this.myFindBalloon == null) {
                    return;
                }
                if (searchRows1 != searchRows2 || replaceRows1 != replaceRows2) {
                    Point resultsLocation = FindPopupPanel.this.myResultsPopup != null && FindPopupPanel.this.myResultsPopup.isVisible() ? FindPopupPanel.this.myResultsPopup.getLocationOnScreen() : null;
                    Dimension findSize = FindPopupPanel.this.myFindBalloon.getSize();
                    FindPopupPanel.this.myFindBalloon.pack(false, true);
                    if (resultsLocation != null) {
                        int hDiff = ((FindPopupPanel)FindPopupPanel.this).myFindBalloon.getSize().height - findSize.height;
                        FindPopupPanel.this.myResultsPopup.setLocation(new Point(resultsLocation.x, resultsLocation.y + hDiff));
                    }
                }
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        };
        this.mySearchComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
        this.myReplaceComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
        DefaultActionGroup scopeActionGroup = new DefaultActionGroup();
        scopeActionGroup.add((AnAction)new MySelectScopeToggleAction(Scope.PROJECT));
        scopeActionGroup.add((AnAction)new MySelectScopeToggleAction(Scope.MODULE));
        scopeActionGroup.add((AnAction)new MySelectScopeToggleAction(Scope.DIRECTORY));
        scopeActionGroup.add((AnAction)new MySelectScopeToggleAction(Scope.SCOPE));
        this.myScopeSelectionToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)scopeActionGroup, true);
        this.myScopeSelectionToolbar.setForceMinimumSize(true);
        this.myScopeSelectionToolbar.setLayoutPolicy(0);
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        Object[] names = new String[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            names[i] = modules[i].getName();
        }
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        this.myModuleComboBox = new ComboBox(names);
        this.myModuleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        });
        this.myDirectoryComboBox = new ComboBox(200);
        Component editorComponent = this.myDirectoryComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField field = (JTextField)editorComponent;
            field.setColumns(40);
        }
        FindPopupPanel.initCombobox(this.myDirectoryComboBox);
        this.myDirectoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        });
        this.mySelectDirectoryButton = new FixedSizeButton((JComponent)this.myDirectoryComboBox);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)this.mySelectDirectoryButton, (JComponent)this.myDirectoryComboBox);
        this.mySelectDirectoryButton.setMargin(new Insets(0, 0, 0, 0));
        this.mySelectDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)FindPopupPanel.this.myProject, (Component)((Object)FindPopupPanel.this), null, files -> FindPopupPanel.this.myDirectoryComboBox.setSelectedItem((Object)((VirtualFile)files.get(0)).getPresentableUrl()));
            }
        });
        this.myRecursiveDirectoryButton = new JToggleButton(AllIcons.General.Recursive, this.myModel.isWithSubdirectories());
        this.myRecursiveDirectoryButton.setIcon(AllIcons.General.Recursive);
        this.myRecursiveDirectoryButton.setMargin(new Insets(0, 0, 0, 0));
        this.myRecursiveDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        });
        JPanel directoryPanel = new JPanel(new BorderLayout());
        directoryPanel.add((Component)this.myDirectoryComboBox, "Center");
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
        buttonsPanel.add((Component)this.mySelectDirectoryButton);
        buttonsPanel.add(this.myRecursiveDirectoryButton);
        directoryPanel.add((Component)buttonsPanel, "East");
        this.myScopeCombo = new ScopeChooserCombo();
        this.myScopeCombo.init(this.myProject, true, true, FindSettings.getInstance().getDefaultScopeName(), new Condition<ScopeDescriptor>(){
            final String projectFilesScopeName = PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]);
            final String moduleFilesScopeName;
            {
                String moduleScopeName = PsiBundle.message((String)"search.scope.module", (Object[])new Object[]{""});
                int ind = moduleScopeName.indexOf(32);
                this.moduleFilesScopeName = moduleScopeName.substring(0, ind + 1);
            }

            public boolean value(ScopeDescriptor descriptor) {
                String display = descriptor.getDisplay();
                return !this.projectFilesScopeName.equals(display) && !display.startsWith(this.moduleFilesScopeName);
            }
        });
        this.myScopeCombo.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        });
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeCombo);
        this.myScopeDetailsPanel = new JPanel(new CardLayout());
        this.myScopeDetailsPanel.add(Scope.PROJECT.name(), new JLabel());
        this.myScopeDetailsPanel.add(Scope.MODULE.name(), (Component)this.myModuleComboBox);
        this.myScopeDetailsPanel.add(Scope.DIRECTORY.name(), directoryPanel);
        this.myScopeDetailsPanel.add(Scope.SCOPE.name(), (Component)((Object)this.myScopeCombo));
        this.setLayout((LayoutManager)new MigLayout("flowx, ins 4, fillx, hidemode 3, gap 0"));
        this.add(this.myTitleLabel, "pushx, gapleft 4");
        this.add(Box.createHorizontalStrut(JBUI.scale((int)50)));
        this.add(this.myCbCaseSensitive);
        this.add(this.myCbPreserveCase);
        this.add(this.myCbWholeWordsOnly);
        this.add(this.myCbRegularExpressions);
        LinkLabel helpLink = RegExHelpPopup.createRegExLink("<html><body><b>?</b></body></html>", this.myCbRegularExpressions, LOG);
        this.add((Component)helpLink, "gapright 8");
        this.add(this.myCbFileFilter);
        this.add((Component)((Object)this.myFileMaskField));
        this.add(this.myFilterContextButton, "wrap");
        this.add((Component)((Object)this.mySearchTextArea), "pushx, growx, sx 9, wrap");
        this.add((Component)((Object)this.myReplaceTextArea), "pushx, growx, sx 9, wrap");
        this.add(this.myScopeSelectionToolbar.getComponent(), "gaptop 4");
        this.add(this.myScopeDetailsPanel, "sx 8, pushx, growx");
        MnemonicHelper.init((Component)((Object)this));
        this.myResultsPreviewTable = new JBTable(){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(this.getWidth(), 1 + this.getRowHeight() * Math.min(9, Math.max(4, this.getRowCount())));
            }
        };
        this.myResultsPreviewTable.getEmptyText().setShowAboveCenter(false);
        this.myResultsPreviewTable.setShowColumns(false);
        this.myResultsPreviewTable.getSelectionModel().setSelectionMode(0);
        this.myResultsPreviewTable.setShowGrid(false);
        this.myResultsPreviewTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        new NavigateToSourceListener().installOn((Component)this.myResultsPreviewTable);
        FindPopupPanel.applyFont(JBUI.Fonts.label(), new Component[]{this.myCbCaseSensitive, this.myCbPreserveCase, this.myCbWholeWordsOnly, this.myCbRegularExpressions, this.myResultsPreviewTable});
        KeymapUtil.reassignAction((JComponent)this.mySearchComponent, (KeyStroke)MOVE_CARET_DOWN, (KeyStroke)MOVE_CARET_DOWN_ALTERNATIVE, (int)2);
        KeymapUtil.reassignAction((JComponent)this.mySearchComponent, (KeyStroke)MOVE_CARET_UP, (KeyStroke)MOVE_CARET_UP_ALTERNATIVE, (int)2);
        KeymapUtil.reassignAction((JComponent)this.mySearchComponent, (KeyStroke)NEW_LINE, (KeyStroke)NEW_LINE_ALTERNATIVE, (int)2);
        UIUtil.redirectKeystrokes((Disposable)this.myDisposable, (JComponent)this.mySearchComponent, (JComponent)this.myResultsPreviewTable, (KeyStroke[])new KeyStroke[]{MOVE_CARET_UP, MOVE_CARET_DOWN, NEW_LINE});
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation()){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.height = Math.min(size.height, this.getLineHeight() * 20);
                return size;
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myUsagePreviewPanel);
        this.myResultsPreviewTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = FindPopupPanel.this.myResultsPreviewTable.getSelectedRow();
                if (index != -1) {
                    UsageInfo usageInfo = ((UsageInfo2UsageAdapter)FindPopupPanel.this.myResultsPreviewTable.getModel().getValueAt(index, 0)).getUsageInfo();
                    FindPopupPanel.this.myUsagePreviewPanel.updateLayout(Collections.singletonList(usageInfo));
                } else {
                    FindPopupPanel.this.myUsagePreviewPanel.updateLayout(null);
                }
            }
        });
        this.mySearchRescheduleOnCancellationsAlarm = new Alarm();
        this.myUpdateResultsPopupBoundsAlarm = new Alarm();
    }

    private void registerCloseAction(JBPopup popup) {
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction closeAction = new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                if (FindPopupPanel.this.myFindBalloon != null && FindPopupPanel.this.myFindBalloon.isVisible()) {
                    FindPopupPanel.this.myFindBalloon.cancel();
                }
                if (FindPopupPanel.this.myResultsPopup != null && FindPopupPanel.this.myResultsPopup.isVisible()) {
                    FindPopupPanel.this.myResultsPopup.cancel();
                }
            }
        };
        closeAction.registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), popup.getContent(), (Disposable)popup);
    }

    public void addNotify() {
        super.addNotify();
        this.showResultsPopupIfNeed();
        this.myScopeSelectionToolbar.updateActionsImmediately();
    }

    private void scheduleUpdateResultsPopupBounds() {
        if (this.myUpdateResultsPopupBoundsAlarm == null || this.myUpdateResultsPopupBoundsAlarm.isDisposed()) {
            return;
        }
        boolean later = this.myUpdateResultsPopupBoundsAlarm.getActiveRequestCount() > 0;
        this.myUpdateResultsPopupBoundsAlarm.cancelAllRequests();
        this.myUpdateResultsPopupBoundsAlarm.addRequest(() -> this.updateResultsPopupBounds(), later ? 50 : 0);
    }

    private void updateResultsPopupBounds() {
        if (this.myResultsPopup == null || !this.myResultsPopup.isVisible()) {
            return;
        }
        this.myResultsPopup.setSize(this.myResultsPopup.getComponent().getPreferredSize());
    }

    private void adjustPopup() {
        if (!this.isShowing()) {
            return;
        }
        Dimension d = PopupPositionManager.PositionAdjuster.getPopupSize(this.myResultsPopup);
        Point myRelativeOnScreen = this.getLocationOnScreen();
        Rectangle screen = ScreenUtil.getScreenRectangle((Point)myRelativeOnScreen);
        Rectangle popupRect = null;
        Rectangle r = new Rectangle(myRelativeOnScreen.x, myRelativeOnScreen.y + this.getHeight(), d.width, d.height);
        if (screen.contains(r)) {
            popupRect = r;
        }
        if (popupRect != null) {
            Point location = new Point(r.x, r.y);
            if (!location.equals(this.myResultsPopup.getLocationOnScreen())) {
                this.myResultsPopup.setLocation(location);
            }
        } else {
            if (r.y + d.height > screen.y + screen.height) {
                r.height = screen.y + screen.height - r.y - 2;
            }
            if (r.width > screen.width) {
                r.width = screen.width - 50;
            }
            if (r.x + r.width > screen.x + screen.width) {
                r.x = screen.x + screen.width - r.width - 2;
            }
            this.myResultsPopup.setSize(r.getSize());
            this.myResultsPopup.setLocation(r.getLocation());
        }
    }

    private void initByModel() {
        Module module2;
        VirtualFile dir;
        this.myTitleLabel.setText(FindBundle.message(this.myModel.isReplaceState() ? "find.replace.in.project.dialog.title" : "find.in.path.dialog.title", new Object[0]));
        this.myCbCaseSensitive.setSelected(this.myModel.isCaseSensitive());
        this.myCbWholeWordsOnly.setSelected(this.myModel.isWholeWordsOnly());
        this.myCbRegularExpressions.setSelected(this.myModel.isRegularExpressions());
        this.mySelectedContextName = FindDialog.getSearchContextName(this.myModel);
        if (this.myModel.isReplaceState()) {
            this.myCbPreserveCase.setSelected(this.myModel.isPreserveCase());
        }
        this.mySelectedScope = FindPopupPanel.getScope(this.myModel);
        String dirName = this.myModel.getDirectoryName();
        this.setDirectories(FindSettings.getInstance().getRecentDirectories(), dirName);
        if (!StringUtil.isEmptyOrSpaces((String)dirName) && (dir = LocalFileSystem.getInstance().findFileByPath(dirName)) != null && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)dir, (Project)this.myProject)) != null) {
            this.myModuleComboBox.setSelectedItem((Object)module2.getName());
        }
        if (this.mySelectedScope == Scope.MODULE) {
            this.myModuleComboBox.setSelectedItem((Object)this.myModel.getModuleName());
        }
        boolean isThereFileFilter = this.myModel.getFileFilter() != null && !this.myModel.getFileFilter().isEmpty();
        this.myCbFileFilter.setSelected(isThereFileFilter);
        List<Object> variants = Arrays.asList(ArrayUtil.reverseArray((Object[])FindSettings.getInstance().getRecentFileMasks()));
        this.myFileMaskField.setVariants(variants);
        if (!variants.isEmpty()) {
            this.myFileMaskField.setText((String)variants.get(0));
        }
        this.myFileMaskField.setEnabled(isThereFileFilter);
        this.updateScopeDetailsPanel();
        String toSearch = this.myModel.getStringToFind();
        if (StringUtil.isEmpty((String)toSearch)) {
            String[] history = FindSettings.getInstance().getRecentFindStrings();
            toSearch = history.length > 0 ? history[history.length - 1] : "";
        }
        this.mySearchComponent.setText(toSearch);
        String toReplace = this.myModel.getStringToReplace();
        if (StringUtil.isEmpty((String)toReplace)) {
            String[] history = FindSettings.getInstance().getRecentReplaceStrings();
            toReplace = history.length > 0 ? history[history.length - 1] : "";
        }
        this.myReplaceComponent.setText(toReplace);
        this.updateControls();
        this.updateScopeDetailsPanel();
        this.updateReplaceVisibility();
    }

    private void setDirectories(@NotNull List<String> strings, String directoryName) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/find/impl/FindPopupPanel", "setDirectories"));
        }
        if (this.myDirectoryComboBox.getItemCount() > 0) {
            this.myDirectoryComboBox.removeAllItems();
        }
        if (directoryName != null && !directoryName.isEmpty()) {
            if (strings.contains(directoryName)) {
                strings.remove(directoryName);
            }
            this.myDirectoryComboBox.addItem((Object)directoryName);
        }
        for (int i = strings.size() - 1; i >= 0; --i) {
            this.myDirectoryComboBox.addItem((Object)strings.get(i));
        }
        if (this.myDirectoryComboBox.getItemCount() == 0) {
            this.myDirectoryComboBox.addItem((Object)"");
        }
    }

    private static Scope getScope(FindModel model) {
        if (model.isCustomScope()) {
            return Scope.SCOPE;
        }
        if (model.isProjectScope()) {
            return Scope.PROJECT;
        }
        if (model.getDirectoryName() != null) {
            return Scope.DIRECTORY;
        }
        if (model.getModuleName() != null) {
            return Scope.MODULE;
        }
        return Scope.PROJECT;
    }

    private void updateControls() {
        if (this.myCbRegularExpressions.isSelected()) {
            this.myCbWholeWordsOnly.makeUnselectable(false);
        } else {
            this.myCbWholeWordsOnly.makeSelectable();
        }
        if (this.myModel.isReplaceState()) {
            if (this.myCbRegularExpressions.isSelected() || this.myCbCaseSensitive.isSelected()) {
                this.myCbPreserveCase.makeUnselectable(false);
            } else {
                this.myCbPreserveCase.makeSelectable();
            }
            if (this.myCbPreserveCase.isSelected()) {
                this.myCbRegularExpressions.makeUnselectable(false);
                this.myCbCaseSensitive.makeUnselectable(false);
            } else {
                this.myCbRegularExpressions.makeSelectable();
                this.myCbCaseSensitive.makeSelectable();
            }
        }
        this.myRecursiveDirectoryButton.setSelected(this.myModel.isWithSubdirectories());
    }

    private void updateReplaceVisibility() {
        this.myReplaceTextArea.setVisible(this.myModel.isReplaceState());
        this.myCbPreserveCase.setVisible(this.myModel.isReplaceState());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchComponent;
    }

    private static void applyFont(JBFont font, Component ... components) {
        for (Component component : components) {
            component.setFont((Font)font);
        }
    }

    private void updateScopeDetailsPanel() {
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, this.mySelectedScope.name());
        this.myScopeDetailsPanel.revalidate();
        this.myScopeDetailsPanel.repaint();
    }

    private void scheduleResultsUpdate() {
        if (this.myFindBalloon == null || !this.myFindBalloon.isVisible()) {
            return;
        }
        if (this.mySearchRescheduleOnCancellationsAlarm == null || this.mySearchRescheduleOnCancellationsAlarm.isDisposed()) {
            return;
        }
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.mySearchRescheduleOnCancellationsAlarm.addRequest(() -> this.findSettingsChanged(), 100);
    }

    private void finishPreviousPreviewSearch() {
        if (this.myResultsPreviewSearchProgress != null && !this.myResultsPreviewSearchProgress.isCanceled()) {
            this.myResultsPreviewSearchProgress.cancel();
        }
    }

    private void findSettingsChanged() {
        ProgressIndicatorBase progressIndicatorWhenSearchStarted;
        if (this.isShowing()) {
            this.showResultsPopupIfNeed();
        }
        final ModalityState state = ModalityState.current();
        this.finishPreviousPreviewSearch();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.applyTo(this.myModel, false);
        FindManager.getInstance((Project)this.myProject).getFindInProjectModel().copyFrom(this.myModel);
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).changeGlobalSettings(this.myModel);
        final FindSettings findSettings = FindSettings.getInstance();
        findSettings.setDefaultScopeName(this.myScopeCombo.getSelectedScopeName());
        findSettings.setFileMask(this.myModel.getFileFilter());
        ValidationInfo result2 = this.getValidationInfo(this.myModel);
        this.myResultsPreviewSearchProgress = progressIndicatorWhenSearchStarted = new ProgressIndicatorBase();
        final DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.addColumn("Usages");
        this.myCodePreviewComponent.setVisible(false);
        this.myResultsPreviewTable.setModel((TableModel)model);
        if (result2 != null) {
            this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
            return;
        }
        this.myResultsPreviewTable.getColumnModel().getColumn(0).setCellRenderer(new FindDialog.UsageTableCellRenderer(this.myCbFileFilter.isSelected(), false));
        this.myResultsPreviewTable.getEmptyText().setText("Searching...");
        final AtomicInteger resultsCount = new AtomicInteger();
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myResultsPreviewSearchProgress, new ReadTask(){

            @Override
            public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                boolean succeeded;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/impl/FindPopupPanel$22", "computeInReadAction"));
                }
                UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(findSettings.isShowResultsInSeparateView(), FindPopupPanel.this.myModel.clone());
                boolean showPanelIfOnlyOneUsage = !findSettings.isSkipResultsWithOneUsage();
                FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(FindPopupPanel.this.myProject, showPanelIfOnlyOneUsage, presentation);
                FindInProjectUtil.findUsages(FindPopupPanel.this.myModel.clone(), FindPopupPanel.this.myProject, (Processor<UsageInfo>)((Processor)info -> {
                    Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info);
                    usage.getPresentation().getIcon();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        model.addRow(new Object[]{usage});
                        FindPopupPanel.this.myCodePreviewComponent.setVisible(true);
                        if (model.getRowCount() == 1 && FindPopupPanel.this.myResultsPreviewTable.getModel() == model) {
                            FindPopupPanel.this.myResultsPreviewTable.setRowSelectionInterval(0, 0);
                        }
                        FindPopupPanel.this.scheduleUpdateResultsPopupBounds();
                    }, state);
                    return resultsCount.incrementAndGet() < 100;
                }), processPresentation);
                boolean bl = succeeded = !progressIndicatorWhenSearchStarted.isCanceled();
                if (succeeded) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (progressIndicatorWhenSearchStarted == FindPopupPanel.this.myResultsPreviewSearchProgress && !FindPopupPanel.this.myResultsPreviewSearchProgress.isCanceled()) {
                            int occurrences = resultsCount.get();
                            if (occurrences == 0) {
                                FindPopupPanel.this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                            }
                            FindPopupPanel.this.myCodePreviewComponent.setVisible(occurrences > 0);
                            StringBuilder info = new StringBuilder();
                            if (occurrences > 0) {
                                info.append(Math.min(100, occurrences));
                                if (occurrences >= 100) {
                                    info.append("+");
                                }
                                info.append(UIBundle.message((String)"message.matches", (Object[])new Object[]{occurrences}));
                            }
                            FindPopupPanel.this.mySearchTextArea.setInfoText(info.toString());
                            FindPopupPanel.this.scheduleUpdateResultsPopupBounds();
                        }
                    }, state);
                }
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/impl/FindPopupPanel$22", "onCanceled"));
                }
                if (FindPopupPanel.this.isShowing() && progressIndicatorWhenSearchStarted == FindPopupPanel.this.myResultsPreviewSearchProgress) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
            }
        });
    }

    private void showResultsPopupIfNeed() {
        if ((this.myResultsPopup == null || !this.myResultsPopup.isVisible()) && this.isShowing()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    JPanel popupContent = new JPanel(new BorderLayout());
                    popupContent.setName("PopupContent!!!");
                    JBSplitter splitter = new JBSplitter(true, 0.33f);
                    splitter.setDividerWidth(1);
                    splitter.getDivider().setBackground(OnePixelDivider.BACKGROUND);
                    JBScrollPane scrollPane = new JBScrollPane((Component)FindPopupPanel.this.myResultsPreviewTable){

                        public Dimension getMinimumSize() {
                            Dimension size = super.getMinimumSize();
                            size.height = Math.max(size.height, ((FindPopupPanel)FindPopupPanel.this).myResultsPreviewTable.getPreferredScrollableViewportSize().height);
                            return size;
                        }
                    };
                    scrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
                    splitter.setFirstComponent((JComponent)scrollPane);
                    popupContent.add((Component)splitter, "Center");
                    JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("flowx, ins 4, fillx, hidemode 3, gap 0"));
                    bottomPanel.add(FindPopupPanel.this.myTabResultsButton);
                    bottomPanel.add(Box.createHorizontalGlue(), "growx, pushx");
                    JBLabel label = new JBLabel(KeymapUtil.getShortcutsText((Shortcut[])new Shortcut[]{new KeyboardShortcut(OK_KEYSTROKE, null)}));
                    label.setEnabled(false);
                    bottomPanel.add((Component)label, "gapright 10");
                    bottomPanel.add(FindPopupPanel.this.myOKButton);
                    popupContent.add((Component)bottomPanel, "South");
                    popupContent.registerKeyboardAction(FindPopupPanel.this.myOkActionListener, OK_KEYSTROKE, 2);
                    FindPopupPanel.this.myCodePreviewComponent = FindPopupPanel.this.myUsagePreviewPanel.createComponent();
                    FindPopupPanel.this.myCodePreviewComponent.setBorder(IdeBorderFactory.createBorder((int)8));
                    splitter.setSecondComponent(FindPopupPanel.this.myCodePreviewComponent);
                    AtomicBoolean canClose = new AtomicBoolean();
                    ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)popupContent, null);
                    FindPopupPanel.this.myResultsPopup = (AbstractPopup)builder.setShowShadow(false).setShowBorder(false).setResizable(true).setCancelCallback(() -> {
                        Window balloonWindow;
                        DimensionService.getInstance().setSize(FindPopupPanel.SIZE_KEY, FindPopupPanel.this.myResultsPopup.getSize());
                        if (canClose.get()) {
                            return Boolean.TRUE;
                        }
                        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                        if (activeWindow == (balloonWindow = SwingUtilities.windowForComponent(FindPopupPanel.this.myFindBalloon.getContent())) || activeWindow != null && activeWindow.getParent() == balloonWindow) {
                            return Boolean.FALSE;
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (FindPopupPanel.this.myFindBalloon != null) {
                                Disposer.dispose((Disposable)FindPopupPanel.this.myFindBalloon);
                                FindPopupPanel.this.myFindBalloon = null;
                            }
                        });
                        return Boolean.TRUE;
                    }).setKeyEventHandler(event -> {
                        if (AbstractPopup.isCloseRequest(event)) {
                            canClose.set(true);
                            FindPopupPanel.this.myResultsPopup.cancel((InputEvent)event);
                            if (FindPopupPanel.this.myFindBalloon != null && FindPopupPanel.this.myFindBalloon.isVisible()) {
                                FindPopupPanel.this.myFindBalloon.cancel();
                            }
                            return true;
                        }
                        return false;
                    }).createPopup();
                    RelativePoint point = new RelativePoint((Component)((Object)FindPopupPanel.this), new Point(0, FindPopupPanel.this.getHeight()));
                    FindPopupPanel.this.myResultsPopup.pack(true, true);
                    FindPopupPanel.this.myResultsPopup.show(point);
                    Dimension panelSize = FindPopupPanel.this.getPreferredSize();
                    Rectangle rectangle = ScreenUtil.getScreenRectangle((Component)((Object)FindPopupPanel.this));
                    Dimension prev = DimensionService.getInstance().getSize(FindPopupPanel.SIZE_KEY);
                    int width = prev != null && prev.width > panelSize.width ? prev.width : panelSize.width;
                    FindPopupPanel.this.myResultsPopup.getComponent().setPreferredSize(new Dimension(width, (int)(rectangle.getHeight() * 0.6)));
                    Disposer.register((Disposable)FindPopupPanel.this.myDisposable, (Disposable)FindPopupPanel.this.myResultsPopup);
                    FindPopupPanel.this.registerCloseAction(FindPopupPanel.this.myResultsPopup);
                    FindPopupPanel.this.updateResultsPopupBounds();
                    ScrollingUtil.ensureSelectionExists((JTable)FindPopupPanel.this.myResultsPreviewTable);
                }
            });
        }
    }

    @Nullable
    private String getFileTypeMask() {
        String mask = null;
        if (this.myCbFileFilter != null && this.myCbFileFilter.isSelected()) {
            mask = this.myFileMaskField.getText();
        }
        return mask;
    }

    @Nullable(value="null means OK")
    private ValidationInfo getValidationInfo(@NotNull FindModel model) {
        String mask;
        VirtualFile directory;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindPopupPanel", "getValidationInfo"));
        }
        if (this.mySelectedScope == Scope.DIRECTORY && (directory = FindInProjectUtil.getDirectory(model)) == null) {
            return new ValidationInfo(FindBundle.message("find.directory.not.found.error", this.getDirectory()), (JComponent)this.myDirectoryComboBox);
        }
        if (!this.canSearchThisString()) {
            return new ValidationInfo("String to find is empty", (JComponent)this.mySearchComponent);
        }
        if (this.myCbRegularExpressions != null && this.myCbRegularExpressions.isSelected() && this.myCbRegularExpressions.isEnabled()) {
            String toFind = this.getStringToFind();
            try {
                boolean isCaseSensitive = this.myCbCaseSensitive != null && this.myCbCaseSensitive.isSelected() && this.myCbCaseSensitive.isEnabled();
                Pattern pattern = Pattern.compile(toFind, isCaseSensitive ? 8 : 10);
                if (pattern.matcher("").matches() && !toFind.endsWith("$") && !toFind.startsWith("^")) {
                    return new ValidationInfo(FindBundle.message("find.empty.match.regular.expression.error", new Object[0]), (JComponent)this.mySearchComponent);
                }
            }
            catch (PatternSyntaxException e) {
                return new ValidationInfo(FindBundle.message("find.invalid.regular.expression.error", toFind, e.getDescription()), (JComponent)this.mySearchComponent);
            }
        }
        if ((mask = this.getFileTypeMask()) != null) {
            if (mask.isEmpty()) {
                return new ValidationInfo(FindBundle.message("find.filter.empty.file.mask.error", new Object[0]), this.myFileMaskField);
            }
            if (mask.contains(";")) {
                return new ValidationInfo("File masks should be comma-separated", this.myFileMaskField);
            }
            try {
                FindInProjectUtil.createFileMaskRegExp(mask);
            }
            catch (PatternSyntaxException ex) {
                return new ValidationInfo(FindBundle.message("find.filter.invalid.file.mask.error", mask), this.myFileMaskField);
            }
        }
        return null;
    }

    private boolean canSearchThisString() {
        return !StringUtil.isEmpty((String)this.getStringToFind()) || !this.myModel.isReplaceState() && !this.myModel.isFindAllEnabled() && this.getFileTypeMask() != null;
    }

    @NotNull
    private String getStringToFind() {
        String string = this.mySearchComponent.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getStringToFind"));
        }
        return string;
    }

    @NotNull
    private String getStringToReplace() {
        String string = this.myReplaceComponent.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getStringToReplace"));
        }
        return string;
    }

    private String getDirectory() {
        return (String)this.myDirectoryComboBox.getSelectedItem();
    }

    private void applyTo(@NotNull FindModel model, boolean findAll) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindPopupPanel", "applyTo"));
        }
        model.setCaseSensitive(this.myCbCaseSensitive.isSelected());
        if (model.isReplaceState()) {
            model.setPreserveCase(this.myCbPreserveCase.isSelected());
        }
        model.setWholeWordsOnly(this.myCbWholeWordsOnly.isSelected());
        String selectedSearchContextInUi = this.mySelectedContextName;
        FindModel.SearchContext searchContext = FindDialog.parseSearchContext(selectedSearchContextInUi);
        model.setSearchContext(searchContext);
        model.setRegularExpressions(this.myCbRegularExpressions.isSelected());
        String stringToFind = this.getStringToFind();
        model.setStringToFind(stringToFind);
        if (model.isReplaceState()) {
            model.setPromptOnReplace(true);
            model.setReplaceAll(false);
            String stringToReplace = this.getStringToReplace();
            model.setStringToReplace(StringUtil.convertLineSeparators((String)stringToReplace));
        }
        model.setProjectScope(this.mySelectedScope == Scope.PROJECT);
        model.setDirectoryName(null);
        model.setModuleName(null);
        model.setCustomScopeName(null);
        model.setCustomScope(null);
        model.setCustomScope(false);
        if (this.mySelectedScope == Scope.DIRECTORY) {
            String directory = this.getDirectory();
            model.setDirectoryName(directory == null ? "" : directory);
            model.setWithSubdirectories(this.myRecursiveDirectoryButton.isSelected());
        } else if (this.mySelectedScope == Scope.MODULE) {
            model.setModuleName((String)this.myModuleComboBox.getSelectedItem());
        } else if (this.mySelectedScope == Scope.SCOPE) {
            SearchScope selectedScope = this.myScopeCombo.getSelectedScope();
            String customScopeName = selectedScope == null ? null : selectedScope.getDisplayName();
            model.setCustomScopeName(customScopeName);
            model.setCustomScope(selectedScope == null ? null : selectedScope);
            model.setCustomScope(true);
        }
        model.setFindAll(findAll);
        String mask = this.getFileTypeMask();
        model.setFileFilter(mask);
    }

    private static void initCombobox(@NotNull ComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/find/impl/FindPopupPanel", "initCombobox"));
        }
        comboBox.setEditable(true);
        comboBox.setMaximumRowCount(8);
    }

    private void navigateToSelectedUsage(JBTable source) {
        int[] rows = source.getSelectedRows();
        List navigations = null;
        for (int row : rows) {
            Object valueAt = source.getModel().getValueAt(row, 0);
            if (!(valueAt instanceof Usage)) continue;
            if (navigations == null) {
                navigations = new SmartList();
            }
            Usage at = (Usage)valueAt;
            navigations.add(at);
        }
        if (navigations != null) {
            this.applyTo(FindManager.getInstance((Project)this.myProject).getFindInProjectModel(), false);
            this.myFindBalloon.cancel();
            ((Usage)navigations.get(0)).navigate(true);
            for (int i = 1; i < navigations.size(); ++i) {
                ((Usage)navigations.get(i)).highlightInEditor();
            }
        }
    }

    private class NavigateToSourceListener
    extends DoubleClickListener {
        private NavigateToSourceListener() {
        }

        protected boolean onDoubleClick(MouseEvent event) {
            Object source = event.getSource();
            if (!(source instanceof JBTable)) {
                return false;
            }
            FindPopupPanel.this.navigateToSelectedUsage((JBTable)source);
            return true;
        }

        public void installOn(final @NotNull Component c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/find/impl/FindPopupPanel$NavigateToSourceListener", "installOn"));
            }
            super.installOn(c);
            if (c instanceof JBTable) {
                AnAction anAction = new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        FindPopupPanel.this.navigateToSelectedUsage((JBTable)c);
                    }
                };
                String key2 = "navigate.to.usage";
                JComponent component = (JComponent)c;
                component.getInputMap(1).put(NEW_LINE, key2);
                component.getActionMap().put(key2, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FindPopupPanel.this.navigateToSelectedUsage((JBTable)c);
                    }
                });
                anAction.registerCustomShortcutSet(CommonShortcuts.ALT_ENTER, component);
                anAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), component);
            }
        }
    }

    private class MySelectScopeToggleAction
    extends ToggleAction
    implements CustomComponentAction {
        private final Scope myScope;

        public MySelectScopeToggleAction(Scope scope) {
            super(FindBundle.message("find.popup.scope." + scope.name().toLowerCase(), new Object[0]), null, EmptyIcon.ICON_0);
            this.getTemplatePresentation().setHoveredIcon(EmptyIcon.ICON_0);
            this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
            this.myScope = scope;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            return new ActionButtonWithText((AnAction)this, presentation, "EditorToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public boolean isSelected(AnActionEvent e) {
            return FindPopupPanel.this.mySelectedScope == this.myScope;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                FindPopupPanel.this.mySelectedScope = this.myScope;
                FindPopupPanel.this.myScopeSelectionToolbar.updateActionsImmediately();
                FindPopupPanel.this.updateScopeDetailsPanel();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }
    }

    private class MySwitchContextToggleAction
    extends ToggleAction {
        public MySwitchContextToggleAction(FindModel.SearchContext context) {
            super(FindDialog.getPresentableName(context));
        }

        public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$MySwitchContextToggleAction", "beforeActionPerformedUpdate"));
            }
            super.beforeActionPerformedUpdate(e);
        }

        public boolean isSelected(AnActionEvent e) {
            return Comparing.equal((String)FindPopupPanel.this.mySelectedContextName, (String)this.getTemplatePresentation().getText());
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                FindPopupPanel.this.mySelectedContextName = this.getTemplatePresentation().getText();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }
    }

    static enum Scope {
        PROJECT,
        MODULE,
        DIRECTORY,
        SCOPE;

    }
}

