/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.TypeIconEP;
import com.intellij.ide.TypeNameEP;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class TypePresentationServiceImpl
extends TypePresentationService {
    private final Map<String, NullableLazyValue<Icon>> myIcons = new HashMap<String, NullableLazyValue<Icon>>();
    private final Map<String, NullableLazyValue<String>> myNames = new HashMap<String, NullableLazyValue<String>>();
    private final FactoryMap<Class, Set<PresentationTemplate>> mySuperClasses = new ConcurrentFactoryMap<Class, Set<PresentationTemplate>>(){

        protected Set<PresentationTemplate> create(Class key2) {
            LinkedHashSet<PresentationTemplate> templates = new LinkedHashSet<PresentationTemplate>();
            this.walkSupers(key2, new LinkedHashSet<Class>(), templates);
            return templates;
        }

        private void walkSupers(Class aClass, Set<Class> classes, Set<PresentationTemplate> templates) {
            if (!classes.add(aClass)) {
                return;
            }
            ContainerUtil.addIfNotNull((Object)TypePresentationServiceImpl.this.createPresentationTemplate(aClass), templates);
            Class superClass = aClass.getSuperclass();
            if (superClass != null) {
                this.walkSupers(superClass, classes, templates);
            }
            for (Class<?> intf : aClass.getInterfaces()) {
                this.walkSupers(intf, classes, templates);
            }
        }
    };

    public Icon getIcon(Object o) {
        return this.getIcon(o.getClass(), o);
    }

    @Nullable
    public Icon getTypeIcon(Class type) {
        return this.getIcon(type, null);
    }

    private Icon getIcon(Class type, Object o) {
        Set templates = (Set)this.mySuperClasses.get((Object)type);
        for (PresentationTemplate template : templates) {
            Icon icon = template.getIcon(o, 0);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @Nullable
    public String getTypePresentableName(Class type) {
        Set templates = (Set)this.mySuperClasses.get((Object)type);
        for (PresentationTemplate template : templates) {
            String typeName = template.getTypeName();
            if (typeName == null) continue;
            return typeName;
        }
        return TypePresentationServiceImpl.getDefaultTypeName((Class)type);
    }

    public String getTypeName(Object o) {
        Set templates = (Set)this.mySuperClasses.get(o.getClass());
        for (PresentationTemplate template : templates) {
            String typeName = template.getTypeName(o);
            if (typeName == null) continue;
            return typeName;
        }
        return null;
    }

    public TypePresentationServiceImpl() {
        for (TypeIconEP typeIconEP : (TypeIconEP[])Extensions.getExtensions((ExtensionPointName)TypeIconEP.EP_NAME)) {
            this.myIcons.put(typeIconEP.className, (NullableLazyValue<Icon>)typeIconEP.getIcon());
        }
        for (TypeIconEP typeIconEP : (TypeNameEP[])Extensions.getExtensions((ExtensionPointName)TypeNameEP.EP_NAME)) {
            this.myNames.put(typeIconEP.className, (NullableLazyValue<String>)typeIconEP.getTypeName());
        }
    }

    @Nullable
    private PresentationTemplate createPresentationTemplate(Class<?> type) {
        Presentation presentation = type.getAnnotation(Presentation.class);
        if (presentation != null) {
            return new PresentationTemplateImpl(presentation, type);
        }
        final NullableLazyValue<Icon> icon = this.myIcons.get(type.getName());
        final NullableLazyValue<String> typeName = this.myNames.get(type.getName());
        if (icon != null || typeName != null) {
            return new PresentationTemplate(){

                @Override
                public Icon getIcon(Object o, int flags) {
                    return icon == null ? null : (Icon)icon.getValue();
                }

                @Override
                public String getName(Object o) {
                    return null;
                }

                @Override
                public String getTypeName() {
                    return typeName == null ? null : (String)typeName.getValue();
                }

                @Override
                public String getTypeName(Object o) {
                    return this.getTypeName();
                }
            };
        }
        return null;
    }

    static interface PresentationTemplate {
        @Nullable
        public Icon getIcon(Object var1, int var2);

        @Nullable
        public String getName(Object var1);

        @Nullable
        public String getTypeName();

        public String getTypeName(Object var1);
    }

    public static class PresentationTemplateImpl
    implements PresentationTemplate {
        private final Presentation myPresentation;
        private final Class<?> myClass;
        private final NullableLazyValue<Icon> myIcon = new NullableLazyValue<Icon>(){

            protected Icon compute() {
                if (StringUtil.isEmpty((String)myPresentation.icon())) {
                    return null;
                }
                return IconLoader.getIcon((String)myPresentation.icon(), (Class)myClass);
            }
        };
        private final NullableLazyValue<PresentationProvider> myPresentationProvider = new NullableLazyValue<PresentationProvider>(){

            protected PresentationProvider compute() {
                Class aClass = myPresentation.provider();
                try {
                    return aClass == PresentationProvider.class ? null : (PresentationProvider)aClass.newInstance();
                }
                catch (Exception e) {
                    return null;
                }
            }
        };

        @Override
        @Nullable
        public Icon getIcon(Object o, int flags) {
            if (o == null) {
                return (Icon)this.myIcon.getValue();
            }
            PresentationProvider provider = (PresentationProvider)this.myPresentationProvider.getValue();
            if (provider == null) {
                return (Icon)this.myIcon.getValue();
            }
            Icon icon = provider.getIcon(o);
            return icon == null ? (Icon)this.myIcon.getValue() : icon;
        }

        @Override
        @Nullable
        public String getTypeName() {
            return StringUtil.isEmpty((String)this.myPresentation.typeName()) ? null : this.myPresentation.typeName();
        }

        @Override
        public String getTypeName(Object o) {
            String typeName;
            PresentationProvider provider = (PresentationProvider)this.myPresentationProvider.getValue();
            if (provider != null && (typeName = provider.getTypeName(o)) != null) {
                return typeName;
            }
            return this.getTypeName();
        }

        @Override
        @Nullable
        public String getName(Object o) {
            PresentationProvider namer = (PresentationProvider)this.myPresentationProvider.getValue();
            return namer == null ? null : namer.getName(o);
        }

        public PresentationTemplateImpl(Presentation presentation, Class<?> aClass) {
            this.myPresentation = presentation;
            this.myClass = aClass;
        }
    }
}

