/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.memory;

import com.intellij.ide.passwordSafe.impl.PasswordSafeTimed;
import com.intellij.ide.passwordSafe.impl.providers.BasePasswordSafeProvider;
import com.intellij.ide.passwordSafe.impl.providers.ByteArrayWrapper;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class MemoryPasswordSafe
extends BasePasswordSafeProvider {
    private final transient AtomicReference<byte[]> key = new AtomicReference();
    private final transient PasswordSafeTimed<Map<ByteArrayWrapper, byte[]>> database = new PasswordSafeTimed<Map<ByteArrayWrapper, byte[]>>(){

        @Override
        protected Map<ByteArrayWrapper, byte[]> compute() {
            return Collections.synchronizedMap(ContainerUtil.newHashMap());
        }

        @Override
        protected int getMinutesToLive() {
            return MemoryPasswordSafe.this.getMinutesToLive();
        }
    };

    protected int getMinutesToLive() {
        return Registry.intValue((String)"passwordSafe.memorySafe.ttl");
    }

    @Override
    @NotNull
    protected byte[] key(Project project2, @NotNull Class requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/passwordSafe/impl/providers/memory/MemoryPasswordSafe", "key"));
        }
        if (this.key.get() == null) {
            byte[] rnd = new byte[256];
            new SecureRandom().nextBytes(rnd);
            this.key.compareAndSet(null, EncryptionUtil.genKey(EncryptionUtil.hash(new byte[][]{rnd})));
        }
        byte[] byArray = this.key.get();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/passwordSafe/impl/providers/memory/MemoryPasswordSafe", "key"));
        }
        return byArray;
    }

    @Override
    protected byte[] getEncryptedPassword(byte[] key2) {
        return this.database.get().get(new ByteArrayWrapper(key2));
    }

    @Override
    protected void removeEncryptedPassword(byte[] key2) {
        this.database.get().remove(new ByteArrayWrapper(key2));
    }

    @Override
    protected void storeEncryptedPassword(byte[] key2, byte[] encryptedPassword) {
        this.database.get().put(new ByteArrayWrapper(key2), encryptedPassword);
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Memory-based password safe provider. The passwords are stored only for the duration of IDEA process.";
    }

    @Override
    public String getName() {
        return "Memory PasswordSafe";
    }

    public void clear() {
        this.database.get().clear();
    }
}

