/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewProjectNode
extends AbstractProjectNode {
    public ProjectViewProjectNode(Project project2, ViewSettings viewSettings) {
        super(project2, project2, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        VirtualFile[] files;
        List<VirtualFile> topLevelContentRoots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelRoots();
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>(topLevelContentRoots.size());
        for (VirtualFile root : topLevelContentRoots) {
            Module module2 = ModuleUtil.findModuleForFile((VirtualFile)root, (Project)this.myProject);
            if (module2 == null) continue;
            modules.add(module2);
        }
        ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        nodes.addAll(this.modulesAndGroups(modules.toArray(new Module[modules.size()])));
        VirtualFile baseDir = this.getProject().getBaseDir();
        if (baseDir == null) {
            ArrayList<AbstractTreeNode> arrayList = nodes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode", "getChildren"));
            }
            return arrayList;
        }
        for (VirtualFile file2 : files = baseDir.getChildren()) {
            if (ModuleUtil.findModuleForFile((VirtualFile)file2, (Project)this.getProject()) != null || file2.isDirectory()) continue;
            nodes.add((AbstractTreeNode)new PsiFileNode(this.getProject(), psiManager.findFile(file2), this.getSettings()));
        }
        if (this.getSettings().isShowLibraryContents()) {
            nodes.add((AbstractTreeNode)new ExternalLibrariesNode(this.getProject(), this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode", "getChildren"));
        }
        return arrayList;
    }

    private static List<VirtualFile> reduceRoots(List<VirtualFile> roots) {
        String userHome;
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            userHome = FileUtil.toSystemIndependentName((String)new File(SystemProperties.getUserHome()).getCanonicalPath());
        }
        catch (IOException e) {
            userHome = null;
        }
        Collections.sort(roots, (o1, o2) -> o1.getPath().compareTo(o2.getPath()));
        Iterator<VirtualFile> it = roots.iterator();
        VirtualFile current = it.next();
        ArrayList<VirtualFile> reducedRoots = new ArrayList<VirtualFile>();
        while (it.hasNext()) {
            VirtualFile next = it.next();
            VirtualFile common = VfsUtilCore.getCommonAncestor((VirtualFile)current, (VirtualFile)next);
            if (common == null || common.getParent() == null || Comparing.equal((String)common.getPath(), (String)userHome)) {
                reducedRoots.add(current);
                current = next;
                continue;
            }
            current = common;
        }
        reducedRoots.add(current);
        return reducedRoots;
    }

    @Override
    protected AbstractTreeNode createModuleGroup(Module module2) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        PsiDirectory psi;
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (roots.length == 1 && (psi = PsiManager.getInstance((Project)this.myProject).findDirectory(roots[0])) != null) {
            return new PsiDirectoryNode(this.myProject, psi, this.getSettings());
        }
        return new ProjectViewModuleNode(this.getProject(), module2, this.getSettings());
    }

    @Override
    protected AbstractTreeNode createModuleGroupNode(ModuleGroup moduleGroup) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return new ProjectViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
    }
}

