/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import sun.swing.SwingUtilities2;

public class DarculaButtonUI
extends BasicButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaButtonUI();
    }

    public static boolean isSquare(Component c) {
        return c instanceof JButton && "square".equals(((JButton)c).getClientProperty("JButton.buttonType"));
    }

    public static boolean isDefaultButton(JComponent c) {
        return c instanceof JButton && ((JButton)c).isDefaultButton();
    }

    protected boolean paintDecorations(Graphics2D g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (DarculaButtonUI.isHelpButton(c)) {
            g.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColor1(), (float)0.0f, (float)h, (Color)this.getButtonColor2()));
            int off = JBUI.scale((int)22);
            int x = (w - off) / 2;
            int y = (h - off) / 2;
            g.fillOval(x, y, off, off);
            AllIcons.Actions.Help.paintIcon(c, g, x + JBUI.scale((int)3), y + JBUI.scale((int)3));
            return false;
        }
        Border border = c.getBorder();
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        boolean square = DarculaButtonUI.isSquare(c);
        if (c.isEnabled() && border != null) {
            Insets ins = border.getBorderInsets(c);
            int yOff = (ins.top + ins.bottom) / 4;
            if (!square) {
                if (DarculaButtonUI.isDefaultButton(c)) {
                    g.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getSelectedButtonColor1(), (float)0.0f, (float)h, (Color)this.getSelectedButtonColor2()));
                } else {
                    g.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColor1(), (float)0.0f, (float)h, (Color)this.getButtonColor2()));
                }
            }
            int rad = JBUI.scale((int)(square ? 3 : 5));
            g.fillRoundRect(JBUI.scale((int)(square ? 2 : 4)), yOff, w - 2 * JBUI.scale((int)4), h - 2 * yOff, rad, rad);
        }
        config.restore();
        return true;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.paintDecorations((Graphics2D)g, c)) {
            super.paint(g, c);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        int mnemonicIndex;
        Color selectedFg;
        if (DarculaButtonUI.isHelpButton(c)) {
            return;
        }
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Color fg = button.getForeground();
        if (fg instanceof UIResource && DarculaButtonUI.isDefaultButton(button) && (selectedFg = UIManager.getColor("Button.darcula.selectedButtonForeground")) != null) {
            fg = selectedFg;
        }
        g.setColor(fg);
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g);
        int n = mnemonicIndex = DarculaLaf.isAltPressed() ? button.getDisplayedMnemonicIndex() : -1;
        if (model.isEnabled()) {
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        } else {
            this.paintDisabledText(g, text, c, textRect, metrics);
        }
    }

    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        g.setColor(UIManager.getColor("Button.darcula.disabledText.shadow"));
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, -1, textRect.x + this.getTextShiftOffset() + 1, textRect.y + metrics.getAscent() + this.getTextShiftOffset() + 1);
        g.setColor(UIManager.getColor("Button.disabledText"));
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        Border border = c.getBorder();
        if (border != null && DarculaButtonUI.isSquare(c)) {
            int xOff = 1;
            Insets ins = border.getBorderInsets(c);
            int yOff = (ins.top + ins.bottom) / 4;
            Rectangle iconRect2 = new Rectangle(iconRect);
            iconRect2.x += xOff;
            iconRect2.y += yOff;
            super.paintIcon(g, c, iconRect2);
        } else {
            super.paintIcon(g, c, iconRect);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        if (DarculaButtonUI.isDefaultButton(c)) {
            this.setupDefaultButton((JButton)c);
        }
    }

    protected void setupDefaultButton(JButton button) {
        if (!SystemInfo.isMac && !button.getFont().isBold()) {
            button.setFont(new FontUIResource(button.getFont().deriveFont(1)));
        }
    }

    public static boolean isHelpButton(JComponent button) {
        return (SystemInfo.isMac || SystemInfo.isWindows && Registry.is((String)"ide.intellij.laf.win10.ui")) && button instanceof JButton && "help".equals(button.getClientProperty("JButton.buttonType"));
    }

    protected Color getButtonColor1() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.color1"), (Object)new ColorUIResource(0x555A5C));
    }

    protected Color getButtonColor2() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.color2"), (Object)new ColorUIResource(4277832));
    }

    protected Color getSelectedButtonColor1() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.selection.color1"), (Object)new ColorUIResource(3690347));
    }

    protected Color getSelectedButtonColor2() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.selection.color2"), (Object)new ColorUIResource(2306371));
    }
}

