/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.projectWizard.ModuleNameLocationComponent;
import com.intellij.ide.util.newProjectWizard.LoadingProjectTemplate;
import com.intellij.ide.util.newProjectWizard.ProjectTypesList;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.TemplatesGroup;
import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.EmptyModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.TemplateModuleBuilder;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectTemplateStep
extends ModuleWizardStep
implements SettingsStep {
    private JBList myTemplatesList;
    private JPanel mySettingsPanel;
    private JTextPane myDescriptionPane;
    private JPanel myDescriptionPanel;
    private JPanel myExpertPlaceholder;
    private JPanel myExpertPanel;
    private final HideableDecorator myExpertDecorator;
    private final NamePathComponent myNamePathComponent;
    private final ProjectFormatPanel myFormatPanel;
    private JPanel myPanel;
    private ModuleNameLocationComponent myModuleNameLocationComponent;
    private final WizardContext myWizardContext;
    private final StepSequence mySequence;
    @Nullable
    private ModuleWizardStep mySettingsStep;
    private final ProjectTypesList myList;
    @Nullable
    private AbstractModuleBuilder myModuleBuilder;

    public SelectTemplateStep(WizardContext context, StepSequence sequence, MultiMap<TemplatesGroup, ProjectTemplate> map) {
        this.myWizardContext = context;
        this.mySequence = sequence;
        this.$$$setupUI$$$();
        Messages.installHyperlinkSupport((JTextPane)this.myDescriptionPane);
        this.myFormatPanel = new ProjectFormatPanel();
        this.myNamePathComponent = NamePathComponent.initNamePathComponent(context);
        if (context.isCreatingNewProject()) {
            this.mySettingsPanel.add((Component)this.myNamePathComponent, "North");
            this.addExpertPanel(this.getModulePanel());
        } else {
            this.mySettingsPanel.add((Component)this.getModulePanel(), "North");
        }
        this.myModuleNameLocationComponent.bindModuleSettings(this.myNamePathComponent);
        this.myExpertDecorator = new HideableDecorator(this.myExpertPlaceholder, "Mor&e Settings", false);
        this.myExpertPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)20, (int)5, (int)0));
        this.myExpertDecorator.setContentComponent(this.myExpertPanel);
        this.myList = new ProjectTypesList(this.myTemplatesList, map, context);
        this.myList.installKeyAction(this.getNameComponent());
        this.myTemplatesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectTemplate template = SelectTemplateStep.this.getSelectedTemplate();
                boolean loading = template instanceof LoadingProjectTemplate;
                SelectTemplateStep.this.myModuleBuilder = template == null || loading ? null : template.createModuleBuilder();
                SelectTemplateStep.this.setupPanels(template);
                SelectTemplateStep.this.mySequence.setType(SelectTemplateStep.this.myModuleBuilder == null ? null : SelectTemplateStep.this.myModuleBuilder.getBuilderId());
                SelectTemplateStep.this.myWizardContext.requestWizardButtonsUpdate();
            }
        });
        if (this.myWizardContext.isCreatingNewProject()) {
            this.addProjectFormat(this.getModulePanel());
        }
    }

    private JPanel getModulePanel() {
        return this.myModuleNameLocationComponent.getModulePanel();
    }

    private JTextField getNameComponent() {
        return this.myWizardContext.isCreatingNewProject() ? this.myNamePathComponent.getNameComponent() : this.myModuleNameLocationComponent.getModuleNameField();
    }

    private void addProjectFormat(JPanel panel) {
        SelectTemplateStep.addField("Project \u001bformat:", this.myFormatPanel.getStorageFormatComboBox(), panel);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myList);
    }

    public String getHelpId() {
        WebProjectTemplate webProjectTemplate;
        String subHelpId;
        String helpId = this.myWizardContext.isCreatingNewProject() ? "New_Project_Main_Settings" : "Add_Module_Main_Settings";
        ProjectTemplate projectTemplate = this.getSelectedTemplate();
        if (projectTemplate instanceof WebProjectTemplate && (subHelpId = (webProjectTemplate = (WebProjectTemplate)projectTemplate).getHelpId()) != null) {
            helpId = helpId + ":" + subHelpId;
        }
        return helpId;
    }

    private void setupPanels(@Nullable ProjectTemplate template) {
        SelectTemplateStep.restorePanel(this.myNamePathComponent, 4);
        SelectTemplateStep.restorePanel(this.getModulePanel(), this.myWizardContext.isCreatingNewProject() ? 8 : 6);
        SelectTemplateStep.restorePanel(this.myExpertPanel, this.myWizardContext.isCreatingNewProject() ? 1 : 0);
        if (this.mySettingsStep != null) {
            this.mySettingsStep.disposeUIResources();
        }
        this.mySettingsStep = this.myModuleBuilder == null ? null : this.myModuleBuilder.modifySettingsStep((SettingsStep)this);
        String description = null;
        if (template != null && StringUtil.isNotEmpty((String)(description = template.getDescription()))) {
            StringBuilder sb = new StringBuilder("<html><body><font ");
            sb.append(SystemInfo.isMac ? "" : "face=\"Verdana\" size=\"-1\"").append('>');
            sb.append(description).append("</font></body></html>");
            description = sb.toString();
            this.myDescriptionPane.setText(description);
        }
        this.myExpertPlaceholder.setVisible(!(this.myModuleBuilder instanceof TemplateModuleBuilder) && this.myExpertPanel.getComponentCount() > 0);
        for (int i = 0; i < 6; ++i) {
            this.getModulePanel().getComponent(i).setVisible(!(this.myModuleBuilder instanceof EmptyModuleBuilder));
        }
        this.myDescriptionPanel.setVisible(StringUtil.isNotEmpty((String)description));
        this.mySettingsPanel.revalidate();
        this.mySettingsPanel.repaint();
    }

    private static int restorePanel(JPanel component, int i) {
        int removed = 0;
        while (component.getComponentCount() > i) {
            component.remove(component.getComponentCount() - 1);
            ++removed;
        }
        return removed;
    }

    public void updateStep() {
        this.myList.resetSelection();
        this.myExpertDecorator.setOn(SelectTemplateSettings.getInstance().EXPERT_MODE);
    }

    public void onStepLeaving() {
        SelectTemplateSettings settings = SelectTemplateSettings.getInstance();
        settings.EXPERT_MODE = this.myExpertDecorator.isExpanded();
        this.myList.saveSelection();
    }

    public boolean validate() throws ConfigurationException {
        ValidationInfo info;
        ProjectTemplate template = this.getSelectedTemplate();
        if (template == null) {
            throw new ConfigurationException(StringUtil.capitalize((String)ProjectBundle.message((String)"project.new.wizard.from.template.error", (Object[])new Object[]{this.myWizardContext.getPresentationName()})), "Error");
        }
        if (this.myWizardContext.isCreatingNewProject() && !this.myNamePathComponent.validateNameAndPath(this.myWizardContext, this.myFormatPanel.isDefault())) {
            return false;
        }
        if (!this.myModuleNameLocationComponent.validateModulePaths()) {
            return false;
        }
        if (!this.myWizardContext.isCreatingNewProject()) {
            this.myModuleNameLocationComponent.validateExistingModuleName(this.myWizardContext.getProject());
        }
        if ((info = template.validateSettings()) != null) {
            throw new ConfigurationException(info.message, "Error");
        }
        if (this.mySettingsStep != null) {
            return this.mySettingsStep.validate();
        }
        return true;
    }

    @Nullable
    public ProjectTemplate getSelectedTemplate() {
        return this.myList.getSelectedTemplate();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getNameComponent();
    }

    public void updateDataModel() {
        this.myWizardContext.setProjectBuilder((ProjectBuilder)this.myModuleBuilder);
        this.myWizardContext.setProjectName(this.myNamePathComponent.getNameValue());
        this.myWizardContext.setProjectFileDirectory(this.myNamePathComponent.getPath());
        this.myFormatPanel.updateData(this.myWizardContext);
        if (this.myModuleBuilder != null) {
            this.myModuleNameLocationComponent.updateDataModel(this.myModuleBuilder);
            if (this.myModuleBuilder instanceof TemplateModuleBuilder) {
                this.myWizardContext.setProjectStorageFormat(StorageScheme.DIRECTORY_BASED);
            }
        }
        if (this.mySettingsStep != null) {
            this.mySettingsStep.updateDataModel();
        }
    }

    public String getName() {
        return "Template Type";
    }

    public WizardContext getContext() {
        return this.myWizardContext;
    }

    public void addSettingsField(@NotNull String label, @NotNull JComponent field) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addSettingsField"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addSettingsField"));
        }
        JPanel panel = this.myWizardContext.isCreatingNewProject() ? this.myNamePathComponent : this.getModulePanel();
        SelectTemplateStep.addField(label, field, panel);
    }

    private static void addField(String label, JComponent field, JPanel panel) {
        JBLabel jLabel = new JBLabel(label);
        jLabel.setLabelFor(field);
        panel.add((Component)jLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsBottom((int)5), 0, 0));
        panel.add((Component)field, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsBottom((int)5), 0, 0));
    }

    public void addSettingsComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addSettingsComponent"));
        }
        JPanel panel = this.myWizardContext.isCreatingNewProject() ? this.myNamePathComponent : this.getModulePanel();
        panel.add((Component)component, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    public void addExpertPanel(@NotNull JComponent panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addExpertPanel"));
        }
        this.myExpertPanel.add((Component)panel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    public void addExpertField(@NotNull String label, @NotNull JComponent field) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addExpertField"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addExpertField"));
        }
        JPanel panel = this.myWizardContext.isCreatingNewProject() ? this.getModulePanel() : this.myExpertPanel;
        SelectTemplateStep.addField(label, field, panel);
    }

    @NotNull
    public JTextField getModuleNameField() {
        JTextField jTextField = this.myModuleNameLocationComponent.getModuleNameField();
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "getModuleNameField"));
        }
        return jTextField;
    }

    public boolean setSelectedTemplate(String group, String name) {
        return this.myList.setSelectedTemplate(group, name);
    }

    @Nullable
    public ModuleWizardStep getSettingsStep() {
        return this.mySettingsStep;
    }

    public Icon getIcon() {
        return this.myWizardContext.getStepIcon();
    }

    private void createUIComponents() {
        this.myModuleNameLocationComponent = new ModuleNameLocationComponent(this.myWizardContext);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JTextPane jTextPane;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(5, 5, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myDescriptionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Description", (int)0, (int)0, null, null));
        this.myDescriptionPane = jTextPane = new JTextPane();
        jTextPane.setText("<html>\r\n  <head>\r\n    \r\n  </head>\r\n  <body>\r\n  </body>\r\n</html>\r\n");
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        jPanel4.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, new Dimension(150, 50), null));
        this.myExpertPlaceholder = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel3, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExpertPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel2, "Center");
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ModuleNameLocationComponent moduleNameLocationComponent = this.myModuleNameLocationComponent;
        JComponent jComponent = moduleNameLocationComponent.$$$getRootComponent$$$();
        jPanel6.add((Component)jComponent, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(200, -1), new Dimension(178, 161), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel7.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myTemplatesList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

