/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExpressionStatisticsAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        final Project project2 = e.getProject();
        assert (project2 != null);
        final Data topLevelData = new Data();
        final Data subData = new Data();
        VirtualFile dir = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        assert (dir != null);
        final List<VirtualFile> javaFiles = ExpressionStatisticsAction.collectJavaFiles(dir, project2);
        if (!ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronouslyInReadAction(project2, "Traversing PSI", true, "Cancel", null, new Runnable(){

            @Override
            public void run() {
                PsiManager psiManager = PsiManager.getInstance((Project)project2);
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setIndeterminate(false);
                for (int i = 0; i < javaFiles.size(); ++i) {
                    VirtualFile file2 = (VirtualFile)javaFiles.get(i);
                    indicator.setText2(file2.getPath());
                    indicator.setFraction((double)i / (double)javaFiles.size());
                    PsiFile psiFile = psiManager.findFile(file2);
                    if (!(psiFile instanceof PsiJavaFile)) continue;
                    psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement element) {
                            if (element instanceof PsiIdentifier) {
                                int offset = element.getTextRange().getStartOffset();
                                PsiExpression minExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
                                if (minExpression != null && minExpression.getTextRange().getStartOffset() == offset) {
                                    PsiExpression nextExpression;
                                    PsiExpression maxExpression = minExpression;
                                    while ((nextExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)maxExpression, PsiExpression.class, (boolean)true)) != null && nextExpression.getTextRange().getStartOffset() == offset) {
                                        maxExpression = nextExpression;
                                    }
                                    ExpressionStatisticsAction.collectExpressionData(minExpression, maxExpression, topLevelData, subData);
                                }
                            }
                            super.visitElement(element);
                        }
                    });
                }
            }
        })) {
            return;
        }
        Messages.showMessageDialog((String)("Top-level: " + topLevelData.toString() + "\n\nSub-expressions: " + subData.toString()), (String)"Expression Statistics", null);
    }

    @NotNull
    private static List<VirtualFile> collectJavaFiles(VirtualFile dir, Project project2) {
        final ArrayList javaFiles = ContainerUtil.newArrayList();
        ProjectFileIndex.SERVICE.getInstance((Project)project2).iterateContentUnderDirectory(dir, new ContentIterator(){

            public boolean processFile(VirtualFile file2) {
                if (file2.getName().endsWith(".java")) {
                    javaFiles.add(file2);
                }
                return true;
            }
        });
        ArrayList arrayList = javaFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/ExpressionStatisticsAction", "collectJavaFiles"));
        }
        return arrayList;
    }

    private static void collectExpressionData(PsiExpression minExpression, PsiExpression maxExpression, Data topLevelData, Data subExpressionData) {
        Data data = minExpression == maxExpression || maxExpression instanceof PsiMethodCallExpression && minExpression == ((PsiMethodCallExpression)maxExpression).getMethodExpression() ? topLevelData : subExpressionData;
        if (minExpression instanceof PsiClassObjectAccessExpression || minExpression instanceof PsiThisExpression || minExpression instanceof PsiSuperExpression) {
            ++data.classes;
            return;
        }
        if (!(minExpression instanceof PsiJavaCodeReferenceElement)) {
            ++data.other;
            return;
        }
        ExpressionStatisticsAction.classifyTarget(data, ((PsiJavaCodeReferenceElement)minExpression).resolve());
    }

    private static void classifyTarget(Data data, PsiElement target) {
        if (target instanceof PsiLocalVariable) {
            ++data.localVars;
        } else if (target instanceof PsiParameter) {
            ++data.parameters;
        } else if (target instanceof PsiMethod) {
            ++data.methods;
        } else if (target instanceof PsiClass) {
            ++data.classes;
        } else if (target instanceof PsiPackage) {
            ++data.packages;
        } else if (target instanceof PsiField) {
            ++data.fields;
        } else {
            ++data.other;
        }
    }

    private static class Data {
        int localVars;
        int parameters;
        int methods;
        int classes;
        int fields;
        int packages;
        int other;

        private Data() {
        }

        public String toString() {
            return "localVars=" + this.localVars + "\nparameters=" + this.parameters + "\nmethods=" + this.methods + "\nfields=" + this.fields + "\nclasses=" + this.classes + "\npackages=" + this.packages + "\nother=" + this.other + "\ntotal=" + (this.localVars + this.parameters + this.methods + this.fields + this.classes + this.packages + this.other);
        }
    }
}

