/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.module.impl.scopes.LibraryRuntimeClasspathScope;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SdkResolveScopeProvider;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryScopeCache {
    private final LibrariesOnlyScope myLibrariesOnlyScope;
    private final Project myProject;
    private final ConcurrentMap<Module[], GlobalSearchScope> myLibraryScopes = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)new TObjectHashingStrategy<Module[]>(){

        public int computeHashCode(Module[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(Module[] o1, Module[] o2) {
            return Arrays.equals(o1, o2);
        }
    });
    private final ConcurrentMap<String, GlobalSearchScope> mySdkScopes = ContainerUtil.newConcurrentMap();
    private final Map<List<OrderEntry>, GlobalSearchScope> myLibraryResolveScopeCache = new ConcurrentFactoryMap<List<OrderEntry>, GlobalSearchScope>(){

        @Nullable
        protected GlobalSearchScope create(@NotNull List<OrderEntry> key2) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/roots/impl/LibraryScopeCache$2", "create"));
            }
            return LibraryScopeCache.this.calcLibraryScope(key2);
        }
    };
    private final Map<List<OrderEntry>, GlobalSearchScope> myLibraryUseScopeCache = new ConcurrentFactoryMap<List<OrderEntry>, GlobalSearchScope>(){

        @Nullable
        protected GlobalSearchScope create(@NotNull List<OrderEntry> key2) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/roots/impl/LibraryScopeCache$3", "create"));
            }
            return LibraryScopeCache.this.calcLibraryUseScope(key2);
        }
    };

    public static LibraryScopeCache getInstance(Project project2) {
        return (LibraryScopeCache)ServiceManager.getService((Project)project2, LibraryScopeCache.class);
    }

    public LibraryScopeCache(Project project2) {
        this.myProject = project2;
        this.myLibrariesOnlyScope = new LibrariesOnlyScope(GlobalSearchScope.allScope((Project)this.myProject), this.myProject);
    }

    void clear() {
        this.myLibraryScopes.clear();
        this.mySdkScopes.clear();
        this.myLibraryResolveScopeCache.clear();
        this.myLibraryUseScopeCache.clear();
    }

    @NotNull
    public GlobalSearchScope getLibrariesOnlyScope() {
        GlobalSearchScope globalSearchScope = this.getScopeForLibraryUsedIn(Module.EMPTY_ARRAY);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getLibrariesOnlyScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope getScopeForLibraryUsedIn(@NotNull Module[] modulesLibraryIsUsedIn) {
        if (modulesLibraryIsUsedIn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesLibraryIsUsedIn", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getScopeForLibraryUsedIn"));
        }
        GlobalSearchScope scope = (GlobalSearchScope)this.myLibraryScopes.get(modulesLibraryIsUsedIn);
        if (scope != null) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getScopeForLibraryUsedIn"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope newScope = modulesLibraryIsUsedIn.length == 0 ? this.myLibrariesOnlyScope : new LibraryRuntimeClasspathScope(this.myProject, modulesLibraryIsUsedIn);
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.myLibraryScopes, (Object)modulesLibraryIsUsedIn, (Object)newScope);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getScopeForLibraryUsedIn"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getLibraryScope(@NotNull List<OrderEntry> orderEntries) {
        if (orderEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntries", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getLibraryScope"));
        }
        GlobalSearchScope globalSearchScope = this.myLibraryResolveScopeCache.get(orderEntries);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getLibraryScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getLibraryUseScope(@NotNull List<OrderEntry> orderEntries) {
        if (orderEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntries", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getLibraryUseScope"));
        }
        GlobalSearchScope globalSearchScope = this.myLibraryUseScopeCache.get(orderEntries);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getLibraryUseScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope calcLibraryScope(@NotNull List<OrderEntry> orderEntries) {
        if (orderEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntries", "com/intellij/openapi/roots/impl/LibraryScopeCache", "calcLibraryScope"));
        }
        ArrayList<Module> modulesLibraryUsedIn = new ArrayList<Module>();
        LibraryOrderEntry lib = null;
        for (OrderEntry entry : orderEntries) {
            if (entry instanceof JdkOrderEntry) {
                GlobalSearchScope globalSearchScope = this.getScopeForSdk((JdkOrderEntry)entry);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "calcLibraryScope"));
                }
                return globalSearchScope;
            }
            if (entry instanceof LibraryOrderEntry) {
                lib = (LibraryOrderEntry)entry;
                modulesLibraryUsedIn.add(entry.getOwnerModule());
                continue;
            }
            if (!(entry instanceof ModuleOrderEntry)) continue;
            modulesLibraryUsedIn.add(entry.getOwnerModule());
        }
        Comparator comparator2 = (o1, o2) -> o1.getName().compareTo(o2.getName());
        Collections.sort(modulesLibraryUsedIn, comparator2);
        List uniquesList = ContainerUtil.removeDuplicatesFromSorted(modulesLibraryUsedIn, (Comparator)comparator2);
        Module[] uniques = uniquesList.toArray(new Module[uniquesList.size()]);
        GlobalSearchScope allCandidates = this.getScopeForLibraryUsedIn(uniques);
        if (lib != null) {
            final LibraryRuntimeClasspathScope preferred = new LibraryRuntimeClasspathScope(this.myProject, lib);
            DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(allCandidates, new Object[]{preferred}){

                public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                    if (file1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/openapi/roots/impl/LibraryScopeCache$4", "compare"));
                    }
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/openapi/roots/impl/LibraryScopeCache$4", "compare"));
                    }
                    boolean c1 = preferred.contains(file1);
                    boolean c2 = preferred.contains(file2);
                    if (c1 && !c2) {
                        return 1;
                    }
                    if (c2 && !c1) {
                        return -1;
                    }
                    return super.compare(file1, file2);
                }
            };
            if (delegatingGlobalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "calcLibraryScope"));
            }
            return delegatingGlobalSearchScope;
        }
        GlobalSearchScope globalSearchScope = allCandidates;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "calcLibraryScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getScopeForSdk(@NotNull JdkOrderEntry jdkOrderEntry) {
        if (jdkOrderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkOrderEntry", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getScopeForSdk"));
        }
        String jdkName = jdkOrderEntry.getJdkName();
        if (jdkName == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getScopeForSdk"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope scope = (GlobalSearchScope)this.mySdkScopes.get(jdkName);
        if (scope == null) {
            SdkResolveScopeProvider provider;
            SdkResolveScopeProvider[] sdkResolveScopeProviderArray = (SdkResolveScopeProvider[])SdkResolveScopeProvider.EP_NAME.getExtensions();
            int n = sdkResolveScopeProviderArray.length;
            for (int i = 0; i < n && (scope = (provider = sdkResolveScopeProviderArray[i]).getScope(this.myProject, jdkOrderEntry)) == null; ++i) {
            }
            if (scope == null) {
                scope = new JdkScope(this.myProject, jdkOrderEntry);
            }
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.mySdkScopes, (Object)jdkName, (Object)scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getScopeForSdk"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "getScopeForSdk"));
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope calcLibraryUseScope(@NotNull List<OrderEntry> entries) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/openapi/roots/impl/LibraryScopeCache", "calcLibraryUseScope"));
        }
        THashSet modulesWithLibrary = new THashSet(entries.size());
        THashSet modulesWithSdk = new THashSet(entries.size());
        for (OrderEntry entry : entries) {
            (entry instanceof JdkOrderEntry ? modulesWithSdk : modulesWithLibrary).add(entry.getOwnerModule());
        }
        modulesWithSdk.removeAll((Collection<?>)modulesWithLibrary);
        if (modulesWithSdk.size() + modulesWithLibrary.size() == ModuleManager.getInstance((Project)this.myProject).getModules().length) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "calcLibraryUseScope"));
            }
            return globalSearchScope;
        }
        ArrayList united = ContainerUtil.newArrayList();
        united.add(this.getLibrariesOnlyScope());
        if (!modulesWithSdk.isEmpty()) {
            united.add(new ModulesScope((Set<Module>)modulesWithSdk, this.myProject));
        }
        for (Module module2 : modulesWithLibrary) {
            united.add(GlobalSearchScope.moduleWithDependentsScope((Module)module2));
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])united.toArray(new GlobalSearchScope[united.size()]));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryScopeCache", "calcLibraryUseScope"));
        }
        return globalSearchScope;
    }

    private static class LibrariesOnlyScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myOriginal;
        private final ProjectFileIndex myIndex;

        private LibrariesOnlyScope(@NotNull GlobalSearchScope original, @NotNull Project project2) {
            if (original == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope", "<init>"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope", "<init>"));
            }
            super(project2);
            this.myIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            this.myOriginal = original;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope", "contains"));
            }
            return this.myOriginal.contains(file2) && (this.myIndex.isInLibraryClasses(file2) || this.myIndex.isInLibrarySource(file2));
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope", "compare"));
            }
            return this.myOriginal.compare(file1, file2);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope", "isSearchInModuleContent"));
            }
            return false;
        }

        public boolean isSearchOutsideRootModel() {
            return this.myOriginal.isSearchOutsideRootModel();
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

