/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.roots.impl.libraries.JarDirectories;
import com.intellij.openapi.roots.impl.libraries.JarDirectoryWatcher;
import com.intellij.openapi.roots.impl.libraries.JarDirectoryWatcherFactory;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryImpl
extends TraceableDisposable
implements LibraryEx.ModifiableModelEx,
LibraryEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.impl.LibraryImpl");
    @NonNls
    public static final String LIBRARY_NAME_ATTR = "name";
    @NonNls
    public static final String LIBRARY_TYPE_ATTR = "type";
    @NonNls
    public static final String ROOT_PATH_ELEMENT = "root";
    @NonNls
    public static final String ELEMENT = "library";
    @NonNls
    public static final String PROPERTIES_ELEMENT = "properties";
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private static final String EXCLUDED_ROOTS_TAG = "excluded";
    private String myName;
    private final LibraryTable myLibraryTable;
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots;
    @Nullable
    private VirtualFilePointerContainer myExcludedRoots;
    private final JarDirectories myJarDirectories;
    private final LibraryImpl mySource;
    private PersistentLibraryKind<?> myKind;
    private LibraryProperties myProperties;
    private final MyRootProviderImpl myRootProvider;
    private final ModifiableRootModel myRootModel;
    private boolean myDisposed;
    private final Disposable myPointersDisposable;
    private final JarDirectoryWatcher myRootsWatcher;

    LibraryImpl(LibraryTable table, @NotNull Element element, ModifiableRootModel rootModel) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "<init>"));
        }
        this(table, rootModel, null, element.getAttributeValue(LIBRARY_NAME_ATTR), LibraryImpl.findPersistentLibraryKind(element));
        this.readProperties(element);
        this.myJarDirectories.readExternal(element);
        this.readRoots(element);
        this.myRootsWatcher.updateWatchedRoots();
    }

    @Nullable
    private static PersistentLibraryKind<?> findPersistentLibraryKind(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "findPersistentLibraryKind"));
        }
        String typeString = element.getAttributeValue(LIBRARY_TYPE_ATTR);
        LibraryKind kind = LibraryKind.findById((String)typeString);
        if (kind != null && !(kind instanceof PersistentLibraryKind)) {
            LOG.error("Cannot load non-persistable library kind: " + typeString);
            return null;
        }
        return (PersistentLibraryKind)kind;
    }

    LibraryImpl(String name, @Nullable PersistentLibraryKind<?> kind, LibraryTable table, ModifiableRootModel rootModel) {
        this(table, rootModel, null, name, kind);
        if (kind != null) {
            this.myProperties = kind.createDefaultProperties();
        }
    }

    private LibraryImpl(@NotNull LibraryImpl from, LibraryImpl newSource, ModifiableRootModel rootModel) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "<init>"));
        }
        this(from.myLibraryTable, rootModel, newSource, from.myName, from.myKind);
        from.checkDisposed();
        if (from.myKind != null && from.myProperties != null) {
            this.myProperties = this.myKind.createDefaultProperties();
            this.myProperties.loadState(from.myProperties.getState());
        }
        for (OrderRootType rootType : this.getAllRootTypes()) {
            VirtualFilePointerContainer thisContainer = this.myRoots.get(rootType);
            VirtualFilePointerContainer thatContainer = from.myRoots.get(rootType);
            thisContainer.addAll(thatContainer);
        }
        if (from.myExcludedRoots != null) {
            this.myExcludedRoots = from.myExcludedRoots.clone(this.myPointersDisposable);
        }
        this.myJarDirectories.copyFrom(from.myJarDirectories);
    }

    private LibraryImpl(LibraryTable table, ModifiableRootModel rootModel, LibraryImpl newSource, String name, @Nullable PersistentLibraryKind<?> kind) {
        super(true);
        this.myJarDirectories = new JarDirectories();
        this.myRootProvider = new MyRootProviderImpl();
        this.myPointersDisposable = Disposer.newDisposable();
        this.myRootsWatcher = JarDirectoryWatcherFactory.getInstance().createWatcher(this.myJarDirectories, this.myRootProvider);
        this.myLibraryTable = table;
        this.myRootModel = rootModel;
        this.mySource = newSource;
        this.myKind = kind;
        this.myName = name;
        this.myRoots = this.initRoots();
        Disposer.register((Disposable)this, (Disposable)this.myRootsWatcher);
    }

    private Set<OrderRootType> getAllRootTypes() {
        HashSet<OrderRootType> rootTypes = new HashSet<OrderRootType>();
        rootTypes.addAll(Arrays.asList(OrderRootType.getAllTypes()));
        if (this.myKind != null) {
            rootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        return rootTypes;
    }

    public void dispose() {
        this.checkDisposed();
        this.myDisposed = true;
        this.kill(null);
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            this.throwDisposalError("'" + this.myName + "' already disposed:");
        }
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getUrls"));
        }
        this.checkDisposed();
        VirtualFilePointerContainer result2 = this.myRoots.get(rootType);
        String[] stringArray = result2 == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : result2.getUrls();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getUrls"));
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getFiles"));
        }
        this.checkDisposed();
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        if (container == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getFiles"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        SmartList expanded = new SmartList();
        for (VirtualFile file2 : container.getFiles()) {
            if (file2.isDirectory() && this.myJarDirectories.contains(rootType, file2.getUrl())) {
                LibraryImpl.collectJarFiles(file2, (List<VirtualFile>)expanded, this.myJarDirectories.isRecursive(rootType, file2.getUrl()));
                continue;
            }
            expanded.add(file2);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)expanded);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getFiles"));
        }
        return virtualFileArray;
    }

    public static void collectJarFiles(VirtualFile dir, final List<VirtualFile> container, boolean recursively) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, recursively ? null : VirtualFileVisitor.ONE_LEVEL_DEEP}){

            public boolean visitFile(@NotNull VirtualFile file2) {
                VirtualFile jarRoot;
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$1", "visitFile"));
                }
                VirtualFile virtualFile = jarRoot = file2.isDirectory() ? null : StandardFileSystems.getJarRootForLocalFile((VirtualFile)file2);
                if (jarRoot != null) {
                    container.add(jarRoot);
                    return false;
                }
                return true;
            }
        });
    }

    public void setName(String name) {
        LOG.assertTrue(this.isWritable());
        this.myName = name;
    }

    @NotNull
    public LibraryEx.ModifiableModelEx getModifiableModel() {
        this.checkDisposed();
        LibraryImpl libraryImpl = new LibraryImpl(this, this, this.myRootModel);
        if (libraryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getModifiableModel"));
        }
        return libraryImpl;
    }

    public Library cloneLibrary(RootModelImpl rootModel) {
        LOG.assertTrue(this.myLibraryTable == null);
        LibraryImpl clone = new LibraryImpl(this, null, (ModifiableRootModel)rootModel);
        clone.myRootsWatcher.updateWatchedRoots();
        return clone;
    }

    public List<String> getInvalidRootUrls(OrderRootType type) {
        if (this.myDisposed) {
            return Collections.emptyList();
        }
        List pointers = this.myRoots.get(type).getList();
        SmartList invalidPaths = null;
        for (VirtualFilePointer pointer : pointers) {
            if (pointer.isValid()) continue;
            if (invalidPaths == null) {
                invalidPaths = new SmartList();
            }
            invalidPaths.add(pointer.getUrl());
        }
        return ContainerUtil.notNullize(invalidPaths);
    }

    public void setProperties(LibraryProperties properties) {
        LOG.assertTrue(this.isWritable());
        this.myProperties = properties;
    }

    @NotNull
    public RootProvider getRootProvider() {
        MyRootProviderImpl myRootProviderImpl = this.myRootProvider;
        if (myRootProviderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getRootProvider"));
        }
        return myRootProviderImpl;
    }

    private Map<OrderRootType, VirtualFilePointerContainer> initRoots() {
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
        com.intellij.util.containers.HashMap result2 = new com.intellij.util.containers.HashMap(4);
        for (OrderRootType rootType : this.getAllRootTypes()) {
            result2.put(rootType, VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable));
        }
        return result2;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.readName(element);
        this.readProperties(element);
        this.readRoots(element);
        this.myJarDirectories.readExternal(element);
        this.myRootsWatcher.updateWatchedRoots();
    }

    private void readProperties(Element element) {
        String typeId = element.getAttributeValue(LIBRARY_TYPE_ATTR);
        if (typeId == null) {
            return;
        }
        this.myKind = (PersistentLibraryKind)LibraryKind.findById((String)typeId);
        if (this.myKind == null) {
            return;
        }
        this.myProperties = this.myKind.createDefaultProperties();
        Element propertiesElement = element.getChild(PROPERTIES_ELEMENT);
        if (propertiesElement != null) {
            ComponentSerializationUtil.loadComponentState(this.myProperties, propertiesElement);
        }
    }

    private void readName(Element element) {
        this.myName = element.getAttributeValue(LIBRARY_NAME_ATTR);
    }

    private void readRoots(Element element) throws InvalidDataException {
        for (OrderRootType rootType : this.getAllRootTypes()) {
            Element rootChild = element.getChild(rootType.name());
            if (rootChild == null) continue;
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            roots.readExternal(rootChild, ROOT_PATH_ELEMENT);
        }
        Element excludedRoot = element.getChild(EXCLUDED_ROOTS_TAG);
        if (excludedRoot != null) {
            this.getOrCreateExcludedRoots().readExternal(excludedRoot, ROOT_PATH_ELEMENT);
        }
    }

    private VirtualFilePointerContainer getOrCreateExcludedRoots() {
        if (this.myExcludedRoots == null) {
            this.myExcludedRoots = VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable);
        }
        return this.myExcludedRoots;
    }

    public static List<OrderRootType> sortRootTypes(Collection<OrderRootType> rootTypes) {
        ArrayList<OrderRootType> allTypes = new ArrayList<OrderRootType>(rootTypes);
        Collections.sort(allTypes, (o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        return allTypes;
    }

    public void writeExternal(Element rootElement) {
        this.checkDisposed();
        Element element = new Element(ELEMENT);
        if (this.myName != null) {
            element.setAttribute(LIBRARY_NAME_ATTR, this.myName);
        }
        if (this.myKind != null) {
            Element propertiesElement;
            element.setAttribute(LIBRARY_TYPE_ATTR, this.myKind.getKindId());
            Object state = this.myProperties.getState();
            if (state != null && !JDOMUtil.isEmpty((Element)(propertiesElement = XmlSerializer.serializeIfNotDefault((Object)state, (SerializationFilter)SERIALIZATION_FILTERS)))) {
                element.addContent(propertiesElement.setName(PROPERTIES_ELEMENT));
            }
        }
        ArrayList<OrderRootType> storableRootTypes = new ArrayList<OrderRootType>();
        storableRootTypes.addAll(Arrays.asList(OrderRootType.getAllTypes()));
        if (this.myKind != null) {
            storableRootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        for (OrderRootType rootType : LibraryImpl.sortRootTypes(storableRootTypes)) {
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            if (roots.size() == 0 && rootType.skipWriteIfEmpty()) continue;
            Element rootTypeElement = new Element(rootType.name());
            roots.writeExternal(rootTypeElement, ROOT_PATH_ELEMENT);
            element.addContent(rootTypeElement);
        }
        if (this.myExcludedRoots != null && this.myExcludedRoots.size() > 0) {
            Element excluded = new Element(EXCLUDED_ROOTS_TAG);
            this.myExcludedRoots.writeExternal(excluded, ROOT_PATH_ELEMENT);
            element.addContent(excluded);
        }
        this.myJarDirectories.writeExternal(element);
        rootElement.addContent(element);
    }

    private boolean isWritable() {
        return this.mySource != null;
    }

    @Nullable
    public PersistentLibraryKind<?> getKind() {
        return this.myKind;
    }

    public void addExcludedRoot(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addExcludedRoot"));
        }
        VirtualFilePointerContainer roots = this.getOrCreateExcludedRoots();
        if (roots.findByUrl(url) == null) {
            roots.add(url);
        }
    }

    public boolean removeExcludedRoot(@NotNull String url) {
        VirtualFilePointer pointer;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "removeExcludedRoot"));
        }
        if (this.myExcludedRoots != null && (pointer = this.myExcludedRoots.findByUrl(url)) != null) {
            this.myExcludedRoots.remove(pointer);
            return true;
        }
        return false;
    }

    @NotNull
    public String[] getExcludedRootUrls() {
        String[] stringArray = this.myExcludedRoots != null ? this.myExcludedRoots.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getExcludedRootUrls"));
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getExcludedRoots() {
        VirtualFile[] virtualFileArray = this.myExcludedRoots != null ? this.myExcludedRoots.getFiles() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getExcludedRoots"));
        }
        return virtualFileArray;
    }

    public LibraryProperties getProperties() {
        return this.myProperties;
    }

    public void setKind(PersistentLibraryKind<?> kind) {
        LOG.assertTrue(this.isWritable());
        LOG.assertTrue(this.myKind == null || this.myKind == kind, (Object)("Library kind cannot be changed from " + this.myKind + " to " + kind));
        this.myKind = kind;
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addRoot"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(url);
    }

    public void addRoot(@NotNull VirtualFile file2, @NotNull OrderRootType rootType) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addRoot"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(file2);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        this.addJarDirectory(url, recursive, JarDirectories.DEFAULT_JAR_DIRECTORY_TYPE);
    }

    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        this.addJarDirectory(file2, recursive, JarDirectories.DEFAULT_JAR_DIRECTORY_TYPE);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(url);
        this.myJarDirectories.add(rootType, url, recursive);
    }

    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive, @NotNull OrderRootType rootType) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(file2);
        this.myJarDirectories.add(rootType, file2.getUrl(), recursive);
    }

    public boolean isJarDirectory(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isJarDirectory"));
        }
        return this.isJarDirectory(url, JarDirectories.DEFAULT_JAR_DIRECTORY_TYPE);
    }

    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isJarDirectory"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isJarDirectory"));
        }
        return this.myJarDirectories.contains(rootType, url);
    }

    public boolean isValid(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isValid"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isValid"));
        }
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFilePointer fp = container.findByUrl(url);
        return fp != null && fp.isValid();
    }

    public boolean removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "removeRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "removeRoot"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFilePointer byUrl = container.findByUrl(url);
        if (byUrl != null) {
            container.remove(byUrl);
            if (this.myExcludedRoots != null) {
                for (String excludedRoot : this.myExcludedRoots.getUrls()) {
                    VirtualFilePointer pointer;
                    if (this.isUnderRoots(excludedRoot) || (pointer = this.myExcludedRoots.findByUrl(excludedRoot)) == null) continue;
                    this.myExcludedRoots.remove(pointer);
                }
            }
            this.myJarDirectories.remove(rootType, url);
            return true;
        }
        return false;
    }

    private boolean isUnderRoots(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isUnderRoots"));
        }
        for (VirtualFilePointerContainer container : this.myRoots.values()) {
            if (!VfsUtilCore.isUnder((String)url, Arrays.asList(container.getUrls()))) continue;
            return true;
        }
        return false;
    }

    public void moveRootUp(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "moveRootUp"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "moveRootUp"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.moveUp(url);
    }

    public void moveRootDown(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "moveRootDown"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "moveRootDown"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.moveDown(url);
    }

    public boolean isChanged() {
        return !this.mySource.equals((Object)this);
    }

    private boolean areRootsChanged(LibraryImpl that) {
        return !that.equals((Object)this);
    }

    public Library getSource() {
        return this.mySource;
    }

    public void commit() {
        this.checkDisposed();
        if (this.isChanged()) {
            this.mySource.commit(this);
        }
        Disposer.dispose((Disposable)this);
    }

    private void commit(@NotNull LibraryImpl fromModel) {
        if (fromModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromModel", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "commit"));
        }
        if (this.myLibraryTable != null) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (!Comparing.equal((String)fromModel.myName, (String)this.myName)) {
            this.myName = fromModel.myName;
            if (this.myLibraryTable instanceof LibraryTableBase) {
                ((LibraryTableBase)this.myLibraryTable).fireLibraryRenamed(this);
            }
        }
        this.myKind = fromModel.getKind();
        this.myProperties = fromModel.myProperties;
        if (this.areRootsChanged(fromModel)) {
            this.disposeMyPointers();
            this.copyRootsFrom(fromModel);
            this.myJarDirectories.copyFrom(fromModel.myJarDirectories);
            this.myRootsWatcher.updateWatchedRoots();
            this.myRootProvider.fireRootSetChanged();
        }
    }

    private void copyRootsFrom(LibraryImpl fromModel) {
        HashMap clonedRoots = ContainerUtil.newHashMap();
        for (Map.Entry<OrderRootType, VirtualFilePointerContainer> entry : fromModel.myRoots.entrySet()) {
            OrderRootType rootType = entry.getKey();
            VirtualFilePointerContainer container = entry.getValue();
            VirtualFilePointerContainer clone = container.clone(this.myPointersDisposable);
            clonedRoots.put(rootType, clone);
        }
        this.myRoots.clear();
        this.myRoots.putAll(clonedRoots);
        VirtualFilePointerContainer excludedRoots = fromModel.myExcludedRoots;
        this.myExcludedRoots = excludedRoots != null ? excludedRoots.clone(this.myPointersDisposable) : null;
    }

    private void disposeMyPointers() {
        for (VirtualFilePointerContainer container : new THashSet(this.myRoots.values())) {
            container.killAll();
        }
        if (this.myExcludedRoots != null) {
            this.myExcludedRoots.killAll();
        }
        Disposer.dispose((Disposable)this.myPointersDisposable);
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
    }

    public LibraryTable getTable() {
        return this.myLibraryTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LibraryImpl library = (LibraryImpl)((Object)o);
        if (!this.myJarDirectories.equals(library.myJarDirectories)) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(library.myName) : library.myName != null) {
            return false;
        }
        if (this.myRoots != null ? !this.myRoots.equals(library.myRoots) : library.myRoots != null) {
            return false;
        }
        if (this.myKind != null ? !this.myKind.equals(library.myKind) : library.myKind != null) {
            return false;
        }
        if (this.myProperties != null ? !this.myProperties.equals((Object)library.myProperties) : library.myProperties != null) {
            return false;
        }
        return Comparing.equal((Object)this.myExcludedRoots, (Object)library.myExcludedRoots);
    }

    public int hashCode() {
        int result2 = this.myName != null ? this.myName.hashCode() : 0;
        result2 = 31 * result2 + (this.myRoots != null ? this.myRoots.hashCode() : 0);
        result2 = 31 * result2 + this.myJarDirectories.hashCode();
        return result2;
    }

    @NonNls
    public String toString() {
        return "Library: name:" + this.myName + "; jars:" + this.myJarDirectories + "; roots:" + this.myRoots.values();
    }

    @Nullable(value="will return non-null value only for module level libraries")
    public Module getModule() {
        return this.myRootModel == null ? null : this.myRootModel.getModule();
    }

    private class MyRootProviderImpl
    extends RootProviderBaseImpl {
        private MyRootProviderImpl() {
        }

        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl", "getUrls"));
            }
            LinkedHashSet<String> originalUrls = new LinkedHashSet<String>(Arrays.asList(LibraryImpl.this.getUrls(rootType)));
            for (VirtualFile file2 : this.getFiles(rootType)) {
                originalUrls.add(file2.getUrl());
            }
            String[] stringArray = ArrayUtil.toStringArray(originalUrls);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl", "getUrls"));
            }
            return stringArray;
        }

        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl", "getFiles"));
            }
            VirtualFile[] virtualFileArray = LibraryImpl.this.getFiles(rootType);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl", "getFiles"));
            }
            return virtualFileArray;
        }
    }
}

