/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.projectWizard.ProjectJdkListRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkComboBox
extends ComboBoxWithWidePopup {
    private static final Icon EMPTY_ICON = EmptyIcon.create((int)1, (int)16);
    @Nullable
    private final Condition<SdkTypeId> myFilter;
    @Nullable
    private final Condition<SdkTypeId> myCreationFilter;
    private JButton mySetUpButton;

    public JdkComboBox(@NotNull ProjectSdksModel jdkModel) {
        if (jdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkModel", "com/intellij/openapi/roots/ui/configuration/JdkComboBox", "<init>"));
        }
        this(jdkModel, null);
    }

    public JdkComboBox(@NotNull ProjectSdksModel jdkModel, @Nullable Condition<SdkTypeId> filter) {
        if (jdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkModel", "com/intellij/openapi/roots/ui/configuration/JdkComboBox", "<init>"));
        }
        this(jdkModel, filter, filter);
    }

    public JdkComboBox(final @NotNull ProjectSdksModel jdkModel, @Nullable Condition<SdkTypeId> filter, @Nullable Condition<SdkTypeId> creationFilter) {
        if (jdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkModel", "com/intellij/openapi/roots/ui/configuration/JdkComboBox", "<init>"));
        }
        super((ComboBoxModel)new JdkComboBoxModel(jdkModel, JdkComboBox.getSdkFilter(filter)));
        this.myFilter = filter;
        this.myCreationFilter = creationFilter;
        this.setRenderer((ListCellRenderer)((Object)new ProjectJdkListRenderer(){

            @Override
            public void doCustomize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (JdkComboBox.this.isEnabled()) {
                    this.setIcon(EMPTY_ICON);
                    if (value instanceof InvalidJdkComboBoxItem) {
                        String str = value.toString();
                        this.append(str, SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else if (value instanceof ProjectJdkComboBoxItem) {
                        Sdk jdk2 = jdkModel.getProjectSdk();
                        if (jdk2 != null) {
                            this.setIcon(((SdkType)jdk2.getSdkType()).getIcon());
                            this.append(ProjectBundle.message((String)"project.roots.project.jdk.inherited", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                            this.append(" (" + jdk2.getName() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        } else {
                            String str = value.toString();
                            this.append(str, SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                    } else {
                        super.doCustomize(list, value != null ? ((JdkComboBoxItem)value).getJdk() : new NoneJdkComboBoxItem(), index, selected, hasFocus);
                    }
                }
            }
        }));
    }

    public Dimension getPreferredSize() {
        Rectangle rec = ScreenUtil.getScreenRectangle((int)0, (int)0);
        Dimension size = super.getPreferredSize();
        int maxWidth = rec.width / 4;
        if (size.width > maxWidth) {
            size.width = maxWidth;
        }
        return size;
    }

    public Dimension getMinimumSize() {
        Dimension minSize = super.getMinimumSize();
        Dimension prefSize = this.getPreferredSize();
        if (minSize.width > prefSize.width) {
            minSize.width = prefSize.width;
        }
        return minSize;
    }

    public void setSetupButton(JButton setUpButton, @Nullable Project project2, ProjectSdksModel jdksModel, JdkComboBoxItem firstItem, @Nullable Condition<Sdk> additionalSetup, boolean moduleJdkSetup) {
        this.setSetupButton(setUpButton, project2, jdksModel, firstItem, additionalSetup, ProjectBundle.message((String)"project.roots.set.up.jdk.title", (Object[])new Object[]{moduleJdkSetup ? 1 : 2}));
    }

    public void setSetupButton(final JButton setUpButton, final @Nullable Project project2, final ProjectSdksModel jdksModel, final JdkComboBoxItem firstItem, final @Nullable Condition<Sdk> additionalSetup, final String actionGroupTitle) {
        this.mySetUpButton = setUpButton;
        this.mySetUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultActionGroup group = new DefaultActionGroup();
                jdksModel.createAddActions(group, (JComponent)((Object)JdkComboBox.this), (Consumer<Sdk>)((Consumer)jdk2 -> {
                    if (project2 != null) {
                        JdkListConfigurable configurable = JdkListConfigurable.getInstance(project2);
                        configurable.addJdkNode((Sdk)jdk2, false);
                    }
                    JdkComboBox.this.reloadModel(new JdkComboBoxItem((Sdk)jdk2), project2);
                    JdkComboBox.this.setSelectedJdk((Sdk)jdk2);
                    if (additionalSetup != null && additionalSetup.value(jdk2)) {
                        JdkComboBox.this.setSelectedJdk(firstItem.getJdk());
                    }
                }), (Condition<SdkTypeId>)JdkComboBox.this.myCreationFilter);
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)JdkComboBox.this));
                if (group.getChildrenCount() > 1) {
                    JBPopupFactory.getInstance().createActionGroupPopup(actionGroupTitle, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)setUpButton);
                } else {
                    AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(""), ActionManager.getInstance(), 0);
                    group.getChildren(event)[0].actionPerformed(event);
                }
            }
        });
    }

    public void setEditButton(final JButton editButton, final Project project2, final Computable<Sdk> retrieveJDK) {
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sdk projectJdk = (Sdk)retrieveJDK.compute();
                if (projectJdk != null) {
                    ProjectStructureConfigurable.getInstance(project2).select(projectJdk, true);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JdkComboBoxItem selectedItem = JdkComboBox.this.getSelectedItem();
                if (selectedItem instanceof ProjectJdkComboBoxItem) {
                    editButton.setEnabled(ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel().getProjectSdk() != null);
                } else {
                    editButton.setEnabled(!(selectedItem instanceof InvalidJdkComboBoxItem) && selectedItem != null && selectedItem.getJdk() != null);
                }
            }
        });
    }

    public JButton getSetUpButton() {
        return this.mySetUpButton;
    }

    public JdkComboBoxItem getSelectedItem() {
        return (JdkComboBoxItem)super.getSelectedItem();
    }

    @Nullable
    public Sdk getSelectedJdk() {
        JdkComboBoxItem selectedItem = this.getSelectedItem();
        return selectedItem != null ? selectedItem.getJdk() : null;
    }

    public boolean isProjectJdkSelected() {
        return this.getSelectedItem() instanceof ProjectJdkComboBoxItem;
    }

    public void setSelectedJdk(Sdk jdk2) {
        int index = this.indexOf(jdk2);
        if (index >= 0) {
            this.setSelectedIndex(index);
        }
    }

    public void setInvalidJdk(String name) {
        this.removeInvalidElement();
        this.addItem(new InvalidJdkComboBoxItem(name));
        this.setSelectedIndex(this.getModel().getSize() - 1);
    }

    private int indexOf(Sdk jdk2) {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        int count = model.getSize();
        for (int idx = 0; idx < count; ++idx) {
            Sdk elementAtJdk;
            JdkComboBoxItem elementAt = model.getElementAt(idx);
            if (!(jdk2 == null ? elementAt instanceof NoneJdkComboBoxItem || elementAt instanceof ProjectJdkComboBoxItem : (elementAtJdk = elementAt.getJdk()) != null && jdk2.getName().equals(elementAtJdk.getName()))) continue;
            return idx;
        }
        return -1;
    }

    private void removeInvalidElement() {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        int count = model.getSize();
        for (int idx = 0; idx < count; ++idx) {
            JdkComboBoxItem elementAt = model.getElementAt(idx);
            if (!(elementAt instanceof InvalidJdkComboBoxItem)) continue;
            this.removeItemAt(idx);
            break;
        }
    }

    public void reloadModel(JdkComboBoxItem firstItem, @Nullable Project project2) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        if (project2 == null) {
            model.addElement(firstItem);
            return;
        }
        model.removeAllElements();
        model.addElement(firstItem);
        ProjectSdksModel projectJdksModel = ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel();
        List<Object> projectJdks = new ArrayList<Sdk>(projectJdksModel.getProjectSdks().values());
        if (this.myFilter != null) {
            projectJdks = ContainerUtil.filter(projectJdks, JdkComboBox.getSdkFilter(this.myFilter));
        }
        Collections.sort(projectJdks, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        for (Sdk projectJdk : projectJdks) {
            model.addElement(new JdkComboBoxItem(projectJdk));
        }
    }

    private static Condition<Sdk> getSdkFilter(@Nullable Condition<SdkTypeId> filter) {
        return filter == null ? Conditions.alwaysTrue() : sdk -> filter.value((Object)sdk.getSdkType());
    }

    private static class InvalidJdkComboBoxItem
    extends JdkComboBoxItem {
        private final String mySdkName;

        public InvalidJdkComboBoxItem(String name) {
            super(null);
            this.mySdkName = name;
        }

        @Override
        public String getSdkName() {
            return this.mySdkName;
        }

        @Override
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.invalid.item", (Object[])new Object[]{this.mySdkName});
        }
    }

    public static class NoneJdkComboBoxItem
    extends JdkComboBoxItem {
        public NoneJdkComboBoxItem() {
            super(null);
        }

        @Override
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.none.item", (Object[])new Object[0]);
        }
    }

    public static class ProjectJdkComboBoxItem
    extends JdkComboBoxItem {
        public ProjectJdkComboBoxItem() {
            super(null);
        }

        @Override
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.project.item", (Object[])new Object[0]);
        }
    }

    public static class JdkComboBoxItem {
        private final Sdk myJdk;

        public JdkComboBoxItem(@Nullable Sdk jdk2) {
            this.myJdk = jdk2;
        }

        public Sdk getJdk() {
            return this.myJdk;
        }

        @Nullable
        public String getSdkName() {
            return this.myJdk != null ? this.myJdk.getName() : null;
        }

        public String toString() {
            return this.myJdk.getName();
        }
    }

    private static class JdkComboBoxModel
    extends DefaultComboBoxModel {
        public JdkComboBoxModel(ProjectSdksModel jdksModel, Condition<Sdk> sdkFilter) {
            Object[] jdks = jdksModel.getSdks();
            if (sdkFilter != null) {
                List filtered = ContainerUtil.filter((Object[])jdks, sdkFilter);
                jdks = filtered.toArray(new Sdk[filtered.size()]);
            }
            Arrays.sort(jdks, (s1, s2) -> s1.getName().compareToIgnoreCase(s2.getName()));
            for (Object jdk2 : jdks) {
                this.addElement(new JdkComboBoxItem((Sdk)jdk2));
            }
        }

        @Override
        public JdkComboBoxItem getElementAt(int index) {
            return (JdkComboBoxItem)super.getElementAt(index);
        }
    }
}

