/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.core.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IReparseableLeafElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomModelImpl
extends UserDataHolderBase
implements PomModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.pom.core.impl.PomModelImpl");
    private final Project myProject;
    private final Map<Class<? extends PomModelAspect>, PomModelAspect> myAspects = new HashMap<Class<? extends PomModelAspect>, PomModelAspect>();
    private final Map<PomModelAspect, List<PomModelAspect>> myIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Map<PomModelAspect, List<PomModelAspect>> myInvertedIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Collection<PomModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Stack<Pair<PomModelAspect, PomTransaction>> myBlockedAspects = new Stack();
    private static volatile boolean allowPsiModification = true;

    public PomModelImpl(Project project2) {
        this.myProject = project2;
    }

    public <T extends PomModelAspect> T getModelAspect(@NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/pom/core/impl/PomModelImpl", "getModelAspect"));
        }
        return (T)this.myAspects.get(aClass);
    }

    public void registerAspect(@NotNull Class<? extends PomModelAspect> aClass, @NotNull PomModelAspect aspect, @NotNull Set<PomModelAspect> dependencies) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/pom/core/impl/PomModelImpl", "registerAspect"));
        }
        if (aspect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aspect", "com/intellij/pom/core/impl/PomModelImpl", "registerAspect"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/pom/core/impl/PomModelImpl", "registerAspect"));
        }
        this.myAspects.put(aClass, aspect);
        Iterator<PomModelAspect> iterator = dependencies.iterator();
        ArrayList<PomModelAspect> deps = new ArrayList<PomModelAspect>();
        while (iterator.hasNext()) {
            PomModelAspect depend = iterator.next();
            deps.addAll(this.getAllDependencies(depend));
        }
        deps.add(aspect);
        for (PomModelAspect pomModelAspect : deps) {
            List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(pomModelAspect);
            if (pomModelAspects != null) {
                pomModelAspects.add(aspect);
                continue;
            }
            this.myInvertedIncidence.put(pomModelAspect, new ArrayList<PomModelAspect>(Collections.singletonList(aspect)));
        }
        this.myIncidence.put(aspect, deps);
    }

    private List<PomModelAspect> getAllDependencies(PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    private List<PomModelAspect> getAllDependants(PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    public void addModelListener(@NotNull PomModelListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/pom/core/impl/PomModelImpl", "addModelListener"));
        }
        this.myListeners.add(listener2);
    }

    public void addModelListener(final @NotNull PomModelListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/pom/core/impl/PomModelImpl", "addModelListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/pom/core/impl/PomModelImpl", "addModelListener"));
        }
        this.addModelListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                PomModelImpl.this.removeModelListener(listener2);
            }
        });
    }

    public void removeModelListener(@NotNull PomModelListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/pom/core/impl/PomModelImpl", "removeModelListener"));
        }
        this.myListeners.remove(listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void runTransaction(@NotNull PomTransaction transaction) throws IncorrectOperationException {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/pom/core/impl/PomModelImpl", "runTransaction"));
        }
        if (!PomModelImpl.isAllowPsiModification()) {
            throw new IncorrectOperationException("Must not modify PSI inside save listener");
        }
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        ArrayList<Throwable> throwables = new ArrayList<Throwable>(0);
        PomModelAspect aspect = transaction.getTransactionAspect();
        this.startTransaction(transaction);
        try {
            PomModelEvent event;
            DebugUtil.startPsiModification(null);
            this.myBlockedAspects.push((Object)Pair.create((Object)aspect, (Object)transaction));
            try {
                transaction.run();
                event = transaction.getAccumulatedEvent();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                try {
                    this.commitTransaction(transaction);
                }
                catch (ProcessCanceledException e2) {
                    throw e2;
                }
                catch (Throwable t) {
                    throwables.add(t);
                }
                finally {
                    DebugUtil.finishPsiModification();
                }
                if (!throwables.isEmpty()) {
                    CompoundRuntimeException.throwIfNotEmpty(throwables);
                }
                // MONITOREXIT : object
                return;
            }
            finally {
                this.myBlockedAspects.pop();
            }
            Pair<PomModelAspect, PomTransaction> block = this.getBlockingTransaction(aspect, transaction);
            if (block != null) {
                PomModelEvent currentEvent = ((PomTransaction)block.getSecond()).getAccumulatedEvent();
                currentEvent.merge(event);
                return;
            }
            Set changedAspects = event.getChangedAspects();
            LinkedHashSet<PomModelAspect> dependants = new LinkedHashSet<PomModelAspect>();
            for (PomModelAspect pomModelAspect : changedAspects) {
                dependants.addAll(this.getAllDependants(pomModelAspect));
            }
            for (PomModelAspect modelAspect : dependants) {
                if (changedAspects.contains(modelAspect)) continue;
                modelAspect.update(event);
            }
            Iterator<PomModelListener> iterator = this.myListeners.iterator();
            block45: while (iterator.hasNext()) {
                PomModelAspect modelAspect;
                PomModelListener listener2 = iterator.next();
                Set changedAspects2 = event.getChangedAspects();
                Iterator iterator2 = changedAspects2.iterator();
                do {
                    if (!iterator2.hasNext()) continue block45;
                } while (!listener2.isAspectChangeInteresting(modelAspect = (PomModelAspect)iterator2.next()));
                listener2.modelChanged(event);
            }
            return;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            throwables.add(t);
            return;
        }
        finally {
            try {
                this.commitTransaction(transaction);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                throwables.add(t);
            }
            finally {
                DebugUtil.finishPsiModification();
            }
            if (!throwables.isEmpty()) {
                CompoundRuntimeException.throwIfNotEmpty(throwables);
            }
        }
    }

    @Nullable
    private Pair<PomModelAspect, PomTransaction> getBlockingTransaction(PomModelAspect aspect, PomTransaction transaction) {
        List<PomModelAspect> allDependants = this.getAllDependants(aspect);
        for (PomModelAspect pomModelAspect : allDependants) {
            ListIterator blocksIterator = this.myBlockedAspects.listIterator(this.myBlockedAspects.size());
            while (blocksIterator.hasPrevious()) {
                Pair pair = (Pair)blocksIterator.previous();
                if (pomModelAspect != pair.getFirst() || !PsiTreeUtil.isAncestor((PsiElement)((PomTransaction)pair.getSecond()).getChangeScope(), (PsiElement)transaction.getChangeScope(), (boolean)false) || PomModelImpl.getContainingFileByTree(((PomTransaction)pair.getSecond()).getChangeScope()) == null) continue;
                return pair;
            }
        }
        return null;
    }

    private void commitTransaction(PomTransaction transaction) {
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(transaction.getChangeScope());
        Document document2 = containingFileByTree != null ? manager.getCachedDocument(containingFileByTree) : null;
        boolean docSynced = false;
        if (document2 != null) {
            int oldLength = containingFileByTree.getTextLength();
            docSynced = synchronizer.commitTransaction(document2);
            if (docSynced) {
                BlockSupportImpl.sendAfterChildrenChangedEvent((PsiManagerImpl)PsiManager.getInstance((Project)this.myProject), containingFileByTree, oldLength, true);
            }
        }
        if (containingFileByTree != null) {
            boolean isFromCommit;
            boolean bl = isFromCommit = ApplicationManager.getApplication().isDispatchThread() && ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).isCommitInProgress();
            if (!isFromCommit && !synchronizer.isIgnorePsiEvents()) {
                this.reparseParallelTrees(containingFileByTree, synchronizer);
                if (docSynced) {
                    containingFileByTree.getViewProvider().contentsSynchronized();
                }
            }
        }
        if (progressIndicator != null) {
            progressIndicator.finishNonCancelableSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparseParallelTrees(PsiFile changedFile, PsiToDocumentSynchronizer synchronizer) {
        List allFiles = changedFile.getViewProvider().getAllFiles();
        if (allFiles.size() <= 1) {
            return;
        }
        CharSequence newText = changedFile.getNode().getChars();
        for (PsiFile file2 : allFiles) {
            Runnable changeAction;
            FileElement fileElement = file2 == changedFile ? null : ((PsiFileImpl)file2).getTreeElement();
            Runnable runnable2 = changeAction = fileElement == null ? null : this.reparseFile(file2, fileElement, newText);
            if (changeAction == null) continue;
            synchronizer.setIgnorePsiEvents(true);
            try {
                CodeStyleManager.getInstance((Project)file2.getProject()).performActionWithFormatterDisabled(changeAction);
            }
            finally {
                synchronizer.setIgnorePsiEvents(false);
            }
        }
    }

    @Nullable
    private Runnable reparseFile(final @NotNull PsiFile file2, @NotNull FileElement treeElement, @NotNull CharSequence newText) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/pom/core/impl/PomModelImpl", "reparseFile"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/pom/core/impl/PomModelImpl", "reparseFile"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/pom/core/impl/PomModelImpl", "reparseFile"));
        }
        TextRange changedPsiRange = DocumentCommitThread.getChangedPsiRange(file2, treeElement, newText);
        if (changedPsiRange == null) {
            return null;
        }
        Runnable reparseLeaf = PomModelImpl.tryReparseOneLeaf(treeElement, newText, changedPsiRange);
        if (reparseLeaf != null) {
            return reparseLeaf;
        }
        final DiffLog log = BlockSupport.getInstance(this.myProject).reparseRange(file2, treeElement, changedPsiRange, newText, (ProgressIndicator)new EmptyProgressIndicator(), treeElement.getText());
        return new Runnable(){

            @Override
            public void run() {
                PomModelImpl.this.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)file2, PomModelImpl.this.getModelAspect(TreeAspect.class)){

                    @Nullable
                    public PomModelEvent runInner() throws IncorrectOperationException {
                        return new TreeAspectEvent(PomModelImpl.this, log.performActualPsiChange(file2));
                    }
                });
            }
        };
    }

    @Nullable
    private static Runnable tryReparseOneLeaf(@NotNull FileElement treeElement, @NotNull CharSequence newText, @NotNull TextRange changedPsiRange) {
        IElementType leafType;
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/pom/core/impl/PomModelImpl", "tryReparseOneLeaf"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/pom/core/impl/PomModelImpl", "tryReparseOneLeaf"));
        }
        if (changedPsiRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedPsiRange", "com/intellij/pom/core/impl/PomModelImpl", "tryReparseOneLeaf"));
        }
        final LeafElement leaf = treeElement.findLeafElementAt(changedPsiRange.getStartOffset());
        IElementType iElementType = leafType = leaf == null ? null : leaf.getElementType();
        if (!(leafType instanceof IReparseableLeafElementType)) {
            return null;
        }
        CharSequence newLeafText = PomModelImpl.getLeafChangedText(leaf, treeElement, newText, changedPsiRange);
        final ASTNode copy = newLeafText == null ? null : ((IReparseableLeafElementType)leafType).reparseLeaf((ASTNode)leaf, newLeafText);
        return copy == null ? null : new Runnable(){

            @Override
            public void run() {
                leaf.getTreeParent().replaceChild(leaf, copy);
            }
        };
    }

    private static CharSequence getLeafChangedText(LeafElement leaf, FileElement treeElement, CharSequence newFileText, TextRange changedPsiRange) {
        if (leaf.getTextRange().getEndOffset() >= changedPsiRange.getEndOffset()) {
            int leafStart = leaf.getTextRange().getStartOffset();
            int newLeafEnd = newFileText.length() - (treeElement.getTextLength() - leaf.getTextRange().getEndOffset());
            if (newLeafEnd > leafStart) {
                return newFileText.subSequence(leafStart, newLeafEnd);
            }
        }
        return null;
    }

    private void startTransaction(@NotNull PomTransaction transaction) {
        Document document2;
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/pom/core/impl/PomModelImpl", "startTransaction"));
        }
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.startNonCancelableSection();
        }
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiElement changeScope = transaction.getChangeScope();
        PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(changeScope);
        boolean physical = changeScope.isPhysical();
        if (physical && synchronizer.toProcessPsiEvent()) {
            if (this.isDocumentUncommitted(containingFileByTree)) {
                throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
                throw new IncorrectOperationException("Must not change PSI outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
            }
        }
        if (containingFileByTree != null) {
            ((SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)this.myProject)).fastenBelts(containingFileByTree.getViewProvider().getVirtualFile());
            if (containingFileByTree instanceof PsiFileImpl) {
                ((PsiFileImpl)containingFileByTree).beforeAstChange();
            }
        }
        BlockSupportImpl.sendBeforeChildrenChangeEvent((PsiManagerImpl)PsiManager.getInstance((Project)this.myProject), changeScope, true);
        Document document3 = containingFileByTree == null ? null : (document2 = physical ? manager.getDocument(containingFileByTree) : manager.getCachedDocument(containingFileByTree));
        if (document2 != null) {
            synchronizer.startTransaction(this.myProject, document2, changeScope);
        }
    }

    private boolean isDocumentUncommitted(@Nullable PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document cachedDocument = manager.getCachedDocument(file2);
        return cachedDocument != null && manager.isUncommited(cachedDocument);
    }

    @Nullable
    private static PsiFile getContainingFileByTree(@NotNull PsiElement changeScope) {
        PsiFile psiFile;
        if (changeScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeScope", "com/intellij/pom/core/impl/PomModelImpl", "getContainingFileByTree"));
        }
        ASTNode node = changeScope.getNode();
        if (node == null) {
            psiFile = changeScope.getContainingFile();
        } else {
            FileElement fileElement = TreeUtil.getFileElement((TreeElement)node);
            if (fileElement == null) {
                return null;
            }
            psiFile = (PsiFile)fileElement.getPsi();
        }
        return psiFile.getNode() != null ? psiFile : null;
    }

    public static <T extends Throwable> void guardPsiModificationsIn(@NotNull ThrowableRunnable<T> runnable2) throws T {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/pom/core/impl/PomModelImpl", "guardPsiModificationsIn"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean old = allowPsiModification;
        try {
            allowPsiModification = false;
            runnable2.run();
        }
        finally {
            allowPsiModification = old;
        }
    }

    public static boolean isAllowPsiModification() {
        return allowPsiModification;
    }
}

