/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;

public class JavaLightStubBuilder
extends LightStubBuilder {
    @Override
    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file2, @NotNull LighterAST tree) {
        LighterASTNode ref;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/JavaLightStubBuilder", "createStubForFile"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/JavaLightStubBuilder", "createStubForFile"));
        }
        if (!(file2 instanceof PsiJavaFile)) {
            StubElement stubElement = super.createStubForFile(file2, tree);
            if (stubElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/JavaLightStubBuilder", "createStubForFile"));
            }
            return stubElement;
        }
        String refText = "";
        LighterASTNode pkg = LightTreeUtil.firstChildOfType(tree, tree.getRoot(), JavaElementType.PACKAGE_STATEMENT);
        if (pkg != null && (ref = LightTreeUtil.firstChildOfType(tree, pkg, JavaElementType.JAVA_CODE_REFERENCE)) != null) {
            refText = JavaSourceUtil.getReferenceText(tree, ref);
        }
        PsiJavaFileStubImpl psiJavaFileStubImpl = new PsiJavaFileStubImpl((PsiJavaFile)file2, StringRef.fromString((String)refText), false);
        if (psiJavaFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/JavaLightStubBuilder", "createStubForFile"));
        }
        return psiJavaFileStubImpl;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        IElementType nodeType;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/JavaLightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/JavaLightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        IElementType parentType = parent.getElementType();
        if (JavaLightStubBuilder.checkByTypes(parentType, nodeType = node.getElementType())) {
            return true;
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            CodeBlockVisitor visitor = new CodeBlockVisitor();
            ((TreeElement)node).acceptTree(visitor);
            return visitor.result;
        }
        return false;
    }

    @Override
    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        IElementType nodeType;
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/JavaLightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/JavaLightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/JavaLightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        IElementType parentType = parent.getTokenType();
        if (JavaLightStubBuilder.checkByTypes(parentType, nodeType = node.getTokenType())) {
            return true;
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            CodeBlockVisitor visitor = new CodeBlockVisitor();
            ((LighterLazyParseableNode)node).accept((LighterLazyParseableNode.Visitor)visitor);
            return visitor.result;
        }
        return false;
    }

    private static boolean checkByTypes(IElementType parentType, IElementType nodeType) {
        if (ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(parentType)) {
            return true;
        }
        if (nodeType == JavaElementType.RECEIVER_PARAMETER) {
            return true;
        }
        if (nodeType == JavaElementType.PARAMETER && parentType != JavaElementType.PARAMETER_LIST) {
            return true;
        }
        if (nodeType == JavaElementType.PARAMETER_LIST && parentType == JavaElementType.LAMBDA_EXPRESSION) {
            return true;
        }
        return nodeType == JavaDocElementType.DOC_COMMENT;
    }

    private static class CodeBlockVisitor
    extends RecursiveTreeElementWalkingVisitor
    implements LighterLazyParseableNode.Visitor {
        private static final TokenSet BLOCK_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.ANNOTATION, JavaElementType.CLASS, JavaElementType.ANONYMOUS_CLASS});
        private boolean result = true;
        private IElementType last;
        private boolean seenNew;

        private CodeBlockVisitor() {
        }

        @Override
        protected void visitNode(TreeElement element) {
            if (BLOCK_ELEMENTS.contains(element.getElementType())) {
                this.result = false;
                this.stopWalking();
                return;
            }
            super.visitNode(element);
        }

        public boolean visit(IElementType type) {
            if (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type)) {
                return true;
            }
            if (type == JavaTokenType.AT) {
                this.result = false;
                return false;
            }
            if (type == JavaTokenType.NEW_KEYWORD) {
                this.seenNew = true;
            } else if (this.seenNew && type == JavaTokenType.SEMICOLON) {
                this.seenNew = false;
            } else {
                if (this.seenNew && type == JavaTokenType.LBRACE && this.last != JavaTokenType.RBRACKET) {
                    this.result = false;
                    return false;
                }
                if (type == JavaTokenType.CLASS_KEYWORD && this.last != JavaTokenType.DOT) {
                    this.result = false;
                    return false;
                }
            }
            this.last = type;
            return true;
        }
    }
}

