/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.actions.ViewStructureAction;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStructureTestFixture
implements Disposable {
    private final CodeInsightTestFixture myFixture;
    private FileStructurePopup myPopup;
    private PsiFile myFile;

    public FileStructureTestFixture(CodeInsightTestFixture fixture) {
        this.myFixture = fixture;
    }

    @Nullable
    public FilteringTreeStructure.FilteringNode update() {
        Ref nodeRef = new Ref();
        FileStructurePopup popup = this.getPopup();
        popup.getTreeBuilder().refilter().doWhenProcessed(() -> {
            this.getStructure().rebuild();
            this.updateTree();
            this.getBuilder().updateFromRoot();
            TreeUtil.expandAll((JTree)this.getTree());
            nodeRef.set((Object)popup.selectPsiElement(popup.getCurrentElement(this.myFile)));
            this.getBuilder().getUi().select(nodeRef.get(), null);
        });
        return (FilteringTreeStructure.FilteringNode)nodeRef.get();
    }

    public Tree getTree() {
        return this.getPopup().getTree();
    }

    public FilteringTreeBuilder getBuilder() {
        return this.getPopup().getTreeBuilder();
    }

    public FileStructurePopup.MyTreeSpeedSearch getSpeedSearch() {
        return (FileStructurePopup.MyTreeSpeedSearch)this.getPopup().getSpeedSearch();
    }

    public void updateTree() {
        this.updateRecursively(this.getRootNode());
    }

    public FilteringTreeStructure getStructure() {
        FilteringTreeStructure structure = (FilteringTreeStructure)this.getBuilder().getTreeStructure();
        assert (structure != null);
        return structure;
    }

    public FilteringTreeStructure.FilteringNode getRootNode() {
        return this.getStructure().getRootElement();
    }

    public void updateRecursively(FilteringTreeStructure.FilteringNode node) {
        node.update();
        for (FilteringTreeStructure.FilteringNode child : node.children()) {
            this.updateRecursively(child);
        }
    }

    @NotNull
    public FileStructurePopup getPopup() {
        if (this.myPopup == null || this.myFile != this.myFixture.getFile()) {
            if (this.myPopup != null) {
                Disposer.dispose((Disposable)this.myPopup);
                this.myPopup = null;
            }
            this.myFile = this.myFixture.getFile();
            this.myPopup = ViewStructureAction.createPopup(this.myFixture.getProject(), (FileEditor)TextEditorProvider.getInstance().getTextEditor(this.myFixture.getEditor()));
            assert (this.myPopup != null);
            Disposer.register((Disposable)this, (Disposable)this.myPopup);
            this.myPopup.createCenterPanel();
            this.myPopup.getTreeBuilder().getUi().getUpdater().setPassThroughMode(true);
        }
        FileStructurePopup fileStructurePopup = this.myPopup;
        if (fileStructurePopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/FileStructureTestFixture", "getPopup"));
        }
        return fileStructurePopup;
    }

    public void dispose() {
        this.myPopup = null;
        this.myFile = null;
    }
}

