/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.WaitFor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.NettyUtil;
import org.junit.Assert;

public class ThreadTracker {
    private final Collection<Thread> before = ThreadTracker.getThreads();
    private final boolean myDefaultProjectInitialized = ((ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized();
    private static final Method getThreads = ReflectionUtil.getDeclaredMethod(Thread.class, (String)"getThreads", (Class[])new Class[0]);
    private static final Set<String> wellKnownOffenders = new THashSet();

    @NotNull
    public static Collection<Thread> getThreads() {
        Object[] threads;
        try {
            threads = (Thread[])getThreads.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList arrayList = ContainerUtilRt.newArrayList((Object[])threads);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/ThreadTracker", "getThreads"));
        }
        return arrayList;
    }

    public static void longRunningThreadCreated(@NotNull Disposable parentDisposable, String ... threadNamePrefixes) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/testFramework/ThreadTracker", "longRunningThreadCreated"));
        }
        if (threadNamePrefixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadNamePrefixes", "com/intellij/testFramework/ThreadTracker", "longRunningThreadCreated"));
        }
        wellKnownOffenders.addAll(Arrays.asList(threadNamePrefixes));
        Disposer.register((Disposable)parentDisposable, () -> {
            if (threadNamePrefixes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadNamePrefixes", "com/intellij/testFramework/ThreadTracker", "lambda$longRunningThreadCreated$0"));
            }
            wellKnownOffenders.removeAll(Arrays.asList(threadNamePrefixes));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLeak() throws AssertionError {
        NettyUtil.awaitQuiescenceOfGlobalEventExecutor(100L, TimeUnit.SECONDS);
        ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
        try {
            if (this.myDefaultProjectInitialized != ((ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized()) {
                return;
            }
            THashSet after2 = new THashSet(ThreadTracker.getThreads());
            after2.removeAll(this.before);
            for (final Thread thread : after2) {
                StackTraceElement[] stackTrace;
                ThreadGroup group;
                if (thread == Thread.currentThread() || (group = thread.getThreadGroup()) != null && "system".equals(group.getName())) continue;
                String name = thread.getName();
                if (ContainerUtil.exists(wellKnownOffenders, name::contains) || !thread.isAlive()) continue;
                if (thread.getStackTrace().length == 0) {
                    thread.interrupt();
                    if (new WaitFor(10000){

                        protected boolean condition() {
                            return !thread.isAlive();
                        }
                    }.isConditionRealized()) continue;
                }
                if ((stackTrace = thread.getStackTrace()).length == 0 || ThreadTracker.isIdleApplicationPoolThread(thread, stackTrace)) continue;
                String trace = "Thread leaked: " + thread + "; " + (Object)((Object)thread.getState()) + " (" + thread.isAlive() + ")\n--- its stacktrace:\n";
                for (StackTraceElement stackTraceElement : stackTrace) {
                    trace = trace + " at " + stackTraceElement + "\n";
                }
                trace = trace + "---\n";
                Assert.fail((String)trace);
            }
        }
        finally {
            this.before.clear();
        }
    }

    private static boolean isIdleApplicationPoolThread(Thread thread, StackTraceElement[] stackTrace) {
        if (!thread.getName().startsWith("ApplicationImpl pooled thread ")) {
            return false;
        }
        boolean insideTPEgetTask = Arrays.stream(stackTrace).anyMatch(element -> element.getMethodName().equals("getTask") && element.getClassName().equals("java.util.concurrent.ThreadPoolExecutor"));
        return insideTPEgetTask;
    }

    public static void awaitThreadTerminationWithParentParentGroup(@NotNull String grandThreadGroup, int timeout, @NotNull TimeUnit unit) {
        Thread jdiThread;
        if (grandThreadGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grandThreadGroup", "com/intellij/testFramework/ThreadTracker", "awaitThreadTerminationWithParentParentGroup"));
        }
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/testFramework/ThreadTracker", "awaitThreadTerminationWithParentParentGroup"));
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + unit.toMillis(timeout) && (jdiThread = (Thread)ContainerUtil.find(ThreadTracker.getThreads(), thread -> {
            if (grandThreadGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grandThreadGroup", "com/intellij/testFramework/ThreadTracker", "lambda$awaitThreadTerminationWithParentParentGroup$2"));
            }
            ThreadGroup group = thread.getThreadGroup();
            return group != null && group.getParent() != null && grandThreadGroup.equals(group.getParent().getName());
        })) != null) {
            try {
                long timeLeft = start + unit.toMillis(timeout) - System.currentTimeMillis();
                System.out.println("Waiting for the " + jdiThread + " for " + timeLeft + "ms");
                jdiThread.join(timeLeft);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        wellKnownOffenders.add("AWT-EventQueue-");
        wellKnownOffenders.add("AWT-Shutdown");
        wellKnownOffenders.add("AWT-Windows");
        wellKnownOffenders.add("CompilerThread0");
        wellKnownOffenders.add("Finalizer");
        wellKnownOffenders.add("IDEA Test Case Thread");
        wellKnownOffenders.add("Image Fetcher ");
        wellKnownOffenders.add("Java2D Disposer");
        wellKnownOffenders.add("JobScheduler FJ pool ");
        wellKnownOffenders.add("JPS thread pool");
        wellKnownOffenders.add("Keep-Alive-Timer");
        wellKnownOffenders.add("main");
        wellKnownOffenders.add("Monitor Ctrl-Break");
        wellKnownOffenders.add("Netty ");
        wellKnownOffenders.add("External compiler");
        wellKnownOffenders.add("Reference Handler");
        wellKnownOffenders.add("RMI TCP Connection");
        wellKnownOffenders.add("Signal Dispatcher");
        wellKnownOffenders.add("timer-int");
        wellKnownOffenders.add("timer-sys");
        wellKnownOffenders.add("TimerQueue");
        wellKnownOffenders.add("UserActivityMonitor thread");
        wellKnownOffenders.add("VM Periodic Task Thread");
        wellKnownOffenders.add("VM Thread");
        wellKnownOffenders.add("YJPAgent-Telemetry");
        ThreadTracker.longRunningThreadCreated((Disposable)ApplicationManager.getApplication(), "Periodic tasks thread", "ApplicationImpl pooled thread ", "Process I/O pool ");
    }
}

