/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DebugReflectionUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.reflect.Field;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CachedValueChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.CachedValueChecker");
    private static final boolean DO_CHECKS = ApplicationManager.getApplication().isUnitTestMode();
    private static final Set<String> ourCheckedKeys = ContainerUtil.newConcurrentSet();

    CachedValueChecker() {
    }

    static void checkProvider(@NotNull CachedValueProvider provider, @NotNull Key key2, @NotNull UserDataHolder userDataHolder) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/CachedValueChecker", "checkProvider"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/CachedValueChecker", "checkProvider"));
        }
        if (userDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userDataHolder", "com/intellij/util/CachedValueChecker", "checkProvider"));
        }
        if (!DO_CHECKS) {
            return;
        }
        if (!ourCheckedKeys.add(key2.toString())) {
            return;
        }
        THashSet visited = ContainerUtil.newIdentityTroveSet();
        DebugReflectionUtil.BackLink path = CachedValueChecker.findReferencedPsi(provider, userDataHolder, 6, (Set<Object>)visited, null);
        if (path != null) {
            LOG.error("Incorrect CachedValue use. Provider references PSI, causing memory leaks and possible invalid element access, provider=" + provider + "\n" + path);
        }
    }

    @Nullable
    private static synchronized DebugReflectionUtil.BackLink findReferencedPsi(@NotNull Object o, final @Nullable UserDataHolder toIgnore, final int depth, final @NotNull Set<Object> visited, final @Nullable DebugReflectionUtil.BackLink backLink) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/CachedValueChecker", "findReferencedPsi"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/util/CachedValueChecker", "findReferencedPsi"));
        }
        if (depth == 0 || o == toIgnore || !visited.add(o)) {
            return null;
        }
        if (o instanceof Project || o instanceof Module || o instanceof Application) {
            return null;
        }
        if (o instanceof PsiElement) {
            if (toIgnore instanceof PsiElement && ((PsiElement)toIgnore).getContainingFile() != null && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)o), (PsiElement)((PsiElement)toIgnore), (boolean)true)) {
                return null;
            }
            return backLink;
        }
        final Ref result2 = Ref.create();
        DebugReflectionUtil.processStronglyReferencedValues(o, new PairProcessor<Object, Field>(){

            public boolean process(Object next, Field field) {
                result2.set((Object)CachedValueChecker.findReferencedPsi(next, toIgnore, depth - 1, visited, new DebugReflectionUtil.BackLink(next, field, backLink)));
                return result2.isNull();
            }
        });
        return (DebugReflectionUtil.BackLink)result2.get();
    }
}

