/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingDetails
implements VcsFullCommitDetails {
    private static final VcsUserImpl STUB_USER = new VcsUserImpl("", "");
    private static final String LOADING = "Loading...";
    @NotNull
    private final Computable<CommitId> myCommitIdComputable;
    private final long myLoadingTaskIndex;
    @Nullable
    private volatile CommitId myCommitId;

    public LoadingDetails(@NotNull Computable<CommitId> commitIdComputable, long loadingTaskIndex) {
        if (commitIdComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIdComputable", "com/intellij/vcs/log/data/LoadingDetails", "<init>"));
        }
        this.myCommitIdComputable = commitIdComputable;
        this.myLoadingTaskIndex = loadingTaskIndex;
    }

    protected CommitId getCommitId() {
        if (this.myCommitId == null) {
            this.myCommitId = (CommitId)this.myCommitIdComputable.compute();
        }
        return this.myCommitId;
    }

    public long getLoadingTaskIndex() {
        return this.myLoadingTaskIndex;
    }

    @NotNull
    public Collection<Change> getChanges() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/LoadingDetails", "getChanges"));
        }
        return list;
    }

    @NotNull
    public String getFullMessage() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/LoadingDetails", "getFullMessage"));
        }
        return "";
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.getCommitId().getRoot();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/LoadingDetails", "getRoot"));
        }
        return virtualFile;
    }

    @NotNull
    public String getSubject() {
        if (LOADING == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/LoadingDetails", "getSubject"));
        }
        return LOADING;
    }

    @NotNull
    public VcsUser getAuthor() {
        VcsUserImpl vcsUserImpl = STUB_USER;
        if (vcsUserImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/LoadingDetails", "getAuthor"));
        }
        return vcsUserImpl;
    }

    @NotNull
    public VcsUser getCommitter() {
        VcsUserImpl vcsUserImpl = STUB_USER;
        if (vcsUserImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/LoadingDetails", "getCommitter"));
        }
        return vcsUserImpl;
    }

    public long getAuthorTime() {
        return -1L;
    }

    public long getCommitTime() {
        return -1L;
    }

    @NotNull
    public Hash getId() {
        Hash hash = this.getCommitId().getHash();
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/LoadingDetails", "getId"));
        }
        return hash;
    }

    @NotNull
    public List<Hash> getParents() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/LoadingDetails", "getParents"));
        }
        return list;
    }

    public long getTimestamp() {
        return -1L;
    }
}

