/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUserRegistryImpl
implements Disposable,
VcsUserRegistry {
    private static final File USER_CACHE_APP_DIR = new File(PathManager.getSystemPath(), "vcs-users");
    private static final Logger LOG = Logger.getInstance(VcsUserRegistryImpl.class);
    private static final int STORAGE_VERSION = 1;
    private static final PersistentEnumeratorBase.DataFilter ACCEPT_ALL_DATA_FILTER = id -> true;
    @Nullable
    private final PersistentEnumerator<VcsUser> myPersistentEnumerator;
    @NotNull
    private final Interner<VcsUser> myInterner;

    VcsUserRegistryImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "<init>"));
        }
        File mapFile = new File(USER_CACHE_APP_DIR, project2.getLocationHash() + "." + 1);
        this.myPersistentEnumerator = this.initEnumerator(mapFile);
        this.myInterner = new Interner();
    }

    @Nullable
    private PersistentEnumerator<VcsUser> initEnumerator(@NotNull File mapFile) {
        if (mapFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapFile", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "initEnumerator"));
        }
        try {
            return (PersistentEnumerator)IOUtil.openCleanOrResetBroken(() -> {
                if (mapFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapFile", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "lambda$initEnumerator$1"));
                }
                return new PersistentEnumerator(mapFile, (KeyDescriptor)new MyDescriptor(), Page.PAGE_SIZE);
            }, (File)mapFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public VcsUser createUser(@NotNull String name, @NotNull String email) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "createUser"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "createUser"));
        }
        Interner<VcsUser> interner = this.myInterner;
        // MONITORENTER : interner
        VcsUser vcsUser = (VcsUser)this.myInterner.intern((Object)new VcsUserImpl(name, email));
        // MONITOREXIT : interner
        if (vcsUser != null) return vcsUser;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "createUser"));
    }

    public void addUser(@NotNull VcsUser user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "addUser"));
        }
        try {
            if (this.myPersistentEnumerator != null) {
                this.myPersistentEnumerator.enumerate((Object)user);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void addUsers(@NotNull Collection<VcsUser> users) {
        if (users == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "users", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "addUsers"));
        }
        for (VcsUser user : users) {
            this.addUser(user);
        }
    }

    @NotNull
    public Set<VcsUser> getUsers() {
        HashSet hashSet;
        try {
            Set users = this.myPersistentEnumerator != null ? this.myPersistentEnumerator.getAllDataObjects(ACCEPT_ALL_DATA_FILTER) : Collections.emptySet();
            hashSet = ContainerUtil.newHashSet(users);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            Set<VcsUser> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "getUsers"));
            }
            return set;
        }
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "getUsers"));
        }
        return hashSet;
    }

    public void flush() {
        if (this.myPersistentEnumerator != null) {
            this.myPersistentEnumerator.force();
        }
    }

    public void dispose() {
        try {
            if (this.myPersistentEnumerator != null) {
                this.myPersistentEnumerator.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private class MyDescriptor
    implements KeyDescriptor<VcsUser> {
        private MyDescriptor() {
        }

        public void save(@NotNull DataOutput out, VcsUser value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/VcsUserRegistryImpl$MyDescriptor", "save"));
            }
            IOUtil.writeUTF((DataOutput)out, (String)value.getName());
            IOUtil.writeUTF((DataOutput)out, (String)value.getEmail());
        }

        public VcsUser read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/VcsUserRegistryImpl$MyDescriptor", "read"));
            }
            String name = IOUtil.readUTF((DataInput)in);
            String email = IOUtil.readUTF((DataInput)in);
            return VcsUserRegistryImpl.this.createUser(name, email);
        }

        public int getHashCode(VcsUser value) {
            return value.hashCode();
        }

        public boolean isEqual(VcsUser val1, VcsUser val2) {
            return val1.equals(val2);
        }
    }
}

