/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.idea.RareLogger;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaFileTypeManager;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.impl.CodeInsightProviders;
import com.jetbrains.jsonSchema.impl.JsonSchemaExportedDefinitions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaObjectCodeInsightWrapper;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceEx;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaServiceEx {
    private static final Logger LOGGER = Logger.getInstance(JsonSchemaServiceImpl.class);
    private static final Logger RARE_LOGGER = RareLogger.wrap(LOGGER, false);
    @NotNull
    private final Project myProject;
    private final Object myLock;
    private final Map<VirtualFile, JsonSchemaObjectCodeInsightWrapper> myWrappers;
    private final Set<VirtualFile> mySchemaFiles;
    private volatile boolean initialized;
    private final JsonSchemaExportedDefinitions myDefinitions;

    public JsonSchemaServiceImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "<init>"));
        }
        this.myWrappers = new HashMap<VirtualFile, JsonSchemaObjectCodeInsightWrapper>();
        this.mySchemaFiles = ContainerUtil.newConcurrentSet();
        this.myLock = new Object();
        this.myProject = project2;
        this.myDefinitions = new JsonSchemaExportedDefinitions((Consumer<PairConsumer<VirtualFile, NullableLazyValue<JsonSchemaObject>>>)((Consumer)this::iterateSchemas));
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project2).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new JsonSchemaVfsListener(project2, this));
        this.ensureSchemaFiles(project2);
    }

    @NotNull
    protected JsonSchemaProviderFactory[] getProviderFactories() {
        JsonSchemaProviderFactory[] jsonSchemaProviderFactoryArray = (JsonSchemaProviderFactory[])JsonSchemaProviderFactory.EP_NAME.getExtensions();
        if (jsonSchemaProviderFactoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getProviderFactories"));
        }
        return jsonSchemaProviderFactoryArray;
    }

    @Override
    @Nullable
    public Annotator getAnnotator(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getAnnotator() : null;
    }

    @Override
    @Nullable
    public CompletionContributor getCompletionContributor(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getContributor() : null;
    }

    @Override
    public boolean hasSchema(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null;
    }

    @Override
    public boolean isRegisteredSchemaFile(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "isRegisteredSchemaFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "isRegisteredSchemaFile"));
        }
        if (!this.initialized) {
            this.ensureSchemaFiles(project2);
        }
        return this.mySchemaFiles.contains(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSchemaFiles(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "ensureSchemaFiles"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.initialized) {
                JsonSchemaProviderFactory[] factories;
                for (JsonSchemaProviderFactory factory : factories = this.getProviderFactories()) {
                    List<JsonSchemaFileProvider> providers = factory.getProviders(project2);
                    for (JsonSchemaFileProvider provider : providers) {
                        VirtualFile schemaFile = provider.getSchemaFile();
                        if (schemaFile == null) continue;
                        this.mySchemaFiles.add(schemaFile);
                    }
                }
                this.initialized = true;
            }
        }
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file2, @NotNull Consumer<String> errorConsumer) {
        String text;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "isSchemaFile"));
        }
        if (errorConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorConsumer", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "isSchemaFile"));
        }
        try {
            text = VfsUtilCore.loadText((VirtualFile)file2);
        }
        catch (IOException e) {
            errorConsumer.consume((Object)e.getMessage());
            return false;
        }
        try {
            return JsonSchemaReader.isJsonSchema(this.getDefinitions(), file2, text, errorConsumer);
        }
        catch (Exception e) {
            this.reset();
            errorConsumer.consume((Object)e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private JsonSchemaExportedDefinitions getDefinitions() {
        JsonSchemaExportedDefinitions definitions;
        Object object = this.myLock;
        synchronized (object) {
            definitions = this.myDefinitions;
        }
        JsonSchemaExportedDefinitions jsonSchemaExportedDefinitions = definitions;
        if (jsonSchemaExportedDefinitions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getDefinitions"));
        }
        return jsonSchemaExportedDefinitions;
    }

    @Override
    @Nullable
    public DocumentationProvider getDocumentationProvider(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getDocumentationProvider() : null;
    }

    @Override
    public void iterateSchemaObjects(VirtualFile file2, @NotNull Processor<JsonSchemaObject> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "iterateSchemaObjects"));
        }
        CodeInsightProviders wrapper = this.getWrapper(file2);
        if (wrapper == null) {
            return;
        }
        wrapper.iterateSchemaObjects(consumer);
    }

    @Override
    @Nullable
    public List<Pair<Boolean, String>> getMatchingSchemaDescriptors(@Nullable VirtualFile file2) {
        List<JsonSchemaObjectCodeInsightWrapper> wrappers = this.getWrappers(file2);
        if (wrappers == null || wrappers.isEmpty()) {
            return null;
        }
        return ContainerUtil.map(wrappers, (Function)((NotNullFunction)wrapper -> Pair.create((Object)wrapper.isUserSchema(), (Object)wrapper.getName())));
    }

    @Nullable
    private JsonSchemaObjectCodeInsightWrapper createWrapper(@NotNull JsonSchemaFileProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "createWrapper"));
        }
        JsonSchemaObject resultObject = JsonSchemaServiceImpl.readObject(provider, this.getDefinitions());
        if (resultObject == null) {
            return null;
        }
        return new JsonSchemaObjectCodeInsightWrapper(this.myProject, provider.getName(), provider.getSchemaType(), provider.getSchemaFile(), resultObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonSchemaObject readObject(@NotNull JsonSchemaFileProvider provider, @Nullable JsonSchemaExportedDefinitions definitions) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "readObject"));
        }
        VirtualFile file2 = provider.getSchemaFile();
        if (file2 == null) {
            return null;
        }
        Reader reader = null;
        try {
            String text = VfsUtil.loadText((VirtualFile)file2);
            reader = new StringReader(text);
            JsonSchemaObject jsonSchemaObject = new JsonSchemaReader(provider.getSchemaFile()).read(reader, definitions);
            return jsonSchemaObject;
        }
        catch (Exception e) {
            JsonSchemaServiceImpl.logException(provider, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    JsonSchemaServiceImpl.logException(provider, e);
                }
            }
        }
        return null;
    }

    private static void logException(@NotNull JsonSchemaFileProvider provider, Exception e) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "logException"));
        }
        String message = "Error while processing json schema file: " + e.getMessage();
        if (provider instanceof JsonSchemaImportedProviderMarker) {
            RARE_LOGGER.info(message, (Throwable)e);
        } else {
            LOGGER.error(message, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.myLock;
        synchronized (object) {
            this.myWrappers.clear();
            this.myDefinitions.reset();
            this.initialized = false;
            this.mySchemaFiles.clear();
        }
        JsonSchemaFileTypeManager.getInstance().reset();
    }

    @Nullable
    private CodeInsightProviders getWrapper(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        FileType type = file2.getFileType();
        if (type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage().isKindOf((Language)JsonLanguage.INSTANCE)) {
            List<JsonSchemaObjectCodeInsightWrapper> wrappers = this.getWrappers(file2);
            if (wrappers == null || wrappers.isEmpty()) {
                return null;
            }
            return wrappers.size() == 1 ? (CodeInsightProviders)wrappers.get(0) : new CompositeCodeInsightProviderWithWarning(wrappers);
        }
        return null;
    }

    public void iterateSchemas(@NotNull PairConsumer<VirtualFile, NullableLazyValue<JsonSchemaObject>> consumer) {
        JsonSchemaProviderFactory[] factories;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "iterateSchemas"));
        }
        for (JsonSchemaProviderFactory factory : factories = this.getProviderFactories()) {
            for (final JsonSchemaFileProvider provider : factory.getProviders(this.myProject)) {
                consumer.consume((Object)provider.getSchemaFile(), (Object)new NullableLazyValue<JsonSchemaObject>(){

                    protected JsonSchemaObject compute() {
                        return JsonSchemaServiceImpl.readObject(provider, null);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropProviderFromCache(@NotNull VirtualFile key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "dropProviderFromCache"));
        }
        Object object = this.myLock;
        synchronized (object) {
            Set<VirtualFile> dirtySet = this.myDefinitions.dropKey(key2);
            Iterator<VirtualFile> iterator = this.myWrappers.keySet().iterator();
            while (iterator.hasNext()) {
                VirtualFile current = iterator.next();
                if (!dirtySet.contains(current)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<JsonSchemaObjectCodeInsightWrapper> getWrappers(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        ArrayList<JsonSchemaObjectCodeInsightWrapper> wrappers = new ArrayList<JsonSchemaObjectCodeInsightWrapper>();
        JsonSchemaProviderFactory[] factories = this.getProviderFactories();
        Object object = this.myLock;
        synchronized (object) {
            HashSet<VirtualFile> files = this.mySchemaFiles.isEmpty() ? new HashSet<VirtualFile>() : null;
            for (JsonSchemaProviderFactory factory : factories) {
                for (JsonSchemaFileProvider provider : factory.getProviders(this.myProject)) {
                    VirtualFile key2 = provider.getSchemaFile();
                    if (files != null) {
                        files.add(key2);
                    }
                    if (!provider.isAvailable(this.myProject, file2)) continue;
                    JsonSchemaObjectCodeInsightWrapper wrapper = this.myWrappers.get(key2);
                    if (wrapper == null) {
                        wrapper = this.createWrapper(provider);
                        if (wrapper == null) {
                            return null;
                        }
                        this.myWrappers.putIfAbsent(key2, wrapper);
                    }
                    wrappers.add(wrapper);
                }
            }
            if (files != null) {
                this.mySchemaFiles.addAll(files);
            }
        }
        return wrappers;
    }

    @Override
    public boolean checkFileForId(@NotNull String id, @NotNull VirtualFile file2) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "checkFileForId"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "checkFileForId"));
        }
        return this.myDefinitions.checkFileForId(id, file2);
    }

    @Override
    public Set<VirtualFile> getSchemaFiles() {
        if (!this.initialized) {
            this.ensureSchemaFiles(this.myProject);
        }
        return Collections.unmodifiableSet(this.mySchemaFiles);
    }

    private static class CompositeCodeInsightProviderWithWarning
    implements CodeInsightProviders {
        private final List<JsonSchemaObjectCodeInsightWrapper> myWrappers;
        private final CompletionContributor myContributor;
        private final Annotator myAnnotator;
        private final DocumentationProvider myDocumentationProvider;

        public CompositeCodeInsightProviderWithWarning(List<JsonSchemaObjectCodeInsightWrapper> wrappers) {
            List<Object> userSchemaWrappers = ContainerUtil.filter(wrappers, JsonSchemaObjectCodeInsightWrapper::isUserSchema);
            this.myWrappers = !userSchemaWrappers.isEmpty() && userSchemaWrappers.size() + 1 == wrappers.size() ? userSchemaWrappers : wrappers;
            this.myContributor = new CompletionContributor(){

                public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
                    if (parameters == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning$1", "fillCompletionVariants"));
                    }
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning$1", "fillCompletionVariants"));
                    }
                    for (JsonSchemaObjectCodeInsightWrapper wrapper : myWrappers) {
                        wrapper.getContributor().fillCompletionVariants(parameters, result2);
                    }
                }
            };
            this.myAnnotator = new Annotator(){

                public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning$2", "annotate"));
                    }
                    if (holder == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning$2", "annotate"));
                    }
                    for (JsonSchemaObjectCodeInsightWrapper wrapper : myWrappers) {
                        wrapper.getAnnotator().annotate(element, holder);
                    }
                }
            };
            ArrayList<DocumentationProvider> list = new ArrayList<DocumentationProvider>();
            for (JsonSchemaObjectCodeInsightWrapper wrapper : this.myWrappers) {
                list.add(wrapper.getDocumentationProvider());
            }
            this.myDocumentationProvider = CompositeDocumentationProvider.wrapProviders(list);
        }

        @Override
        @NotNull
        public CompletionContributor getContributor() {
            CompletionContributor completionContributor = this.myContributor;
            if (completionContributor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning", "getContributor"));
            }
            return completionContributor;
        }

        @Override
        @NotNull
        public Annotator getAnnotator() {
            Annotator annotator2 = this.myAnnotator;
            if (annotator2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning", "getAnnotator"));
            }
            return annotator2;
        }

        @Override
        @NotNull
        public DocumentationProvider getDocumentationProvider() {
            DocumentationProvider documentationProvider = this.myDocumentationProvider;
            if (documentationProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning", "getDocumentationProvider"));
            }
            return documentationProvider;
        }

        @Override
        public boolean iterateSchemaObjects(@NotNull Processor<JsonSchemaObject> consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$CompositeCodeInsightProviderWithWarning", "iterateSchemaObjects"));
            }
            for (JsonSchemaObjectCodeInsightWrapper wrapper : this.myWrappers) {
                if (wrapper.iterateSchemaObjects(consumer)) continue;
                return false;
            }
            return true;
        }
    }
}

