/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.AsyncFramesHeader;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/debugger/ExecutionStackView;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "displayName", "", "(Lorg/jetbrains/debugger/SuspendContext;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;Ljava/lang/String;)V", "getSuspendContext", "()Lorg/jetbrains/debugger/SuspendContext;", "topCallFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "getViewSupport$script_debugger_ui", "()Lorg/jetbrains/debugger/DebuggerViewSupport;", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "getTopFrame", "script-debugger-ui"})
public final class ExecutionStackView
extends XExecutionStack {
    private CallFrameView topCallFrameView;
    @NotNull
    private final SuspendContext<?> suspendContext;
    @NotNull
    private final DebuggerViewSupport viewSupport;
    private final Script topFrameScript;
    private final SourceInfo topFrameSourceInfo;

    @Nullable
    public CallFrameView getTopFrame() {
        block7: {
            CallFrameView callFrameView;
            Object topCallFrame;
            block6: {
                topCallFrame = this.suspendContext.getTopFrame();
                if (this.topCallFrameView == null) break block6;
                CallFrameView callFrameView2 = this.topCallFrameView;
                if (callFrameView2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!(Intrinsics.areEqual((Object)callFrameView2.getCallFrame(), topCallFrame) ^ true)) break block7;
            }
            ExecutionStackView executionStackView = this;
            Object obj = topCallFrame;
            if (obj != null) {
                Object obj2 = obj;
                ExecutionStackView executionStackView2 = executionStackView;
                CallFrame it = (CallFrame)obj2;
                CallFrameView callFrameView3 = new CallFrameView(it, this.viewSupport, this.topFrameScript, this.topFrameSourceInfo, null, this.suspendContext.getVm(), 16, null);
                executionStackView = executionStackView2;
                callFrameView = callFrameView3;
            } else {
                callFrameView = null;
            }
            executionStackView.topCallFrameView = callFrameView;
        }
        return this.topCallFrameView;
    }

    /*
     * WARNING - void declaration
     */
    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        void context$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Promise<CallFrame[]> promise2 = this.suspendContext.getFrames();
        SuspendContext<?> suspendContext = this.suspendContext;
        $receiver$iv.done((Consumer)new ContextDependentAsyncResultConsumer<CallFrame[]>((SuspendContext)context$iv, (SuspendContext)context$iv, this, firstFrameIndex, container){
            final /* synthetic */ SuspendContext $context;
            final /* synthetic */ ExecutionStackView this$0;
            final /* synthetic */ int $firstFrameIndex$inlined;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container$inlined;

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void consume(Object result2, Vm vm) {
                List result3;
                CallFrame[] frames = (CallFrame[])result2;
                int count = ((Object[])frames).length - this.$firstFrameIndex$inlined;
                if (count < 1) {
                    result3 = CollectionsKt.emptyList();
                } else {
                    result3 = new ArrayList<E>(count);
                    int n = this.$firstFrameIndex$inlined;
                    int n2 = ((Object[])frames).length - 1;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            if (i == false) {
                                ArrayList arrayList = (ArrayList)result3;
                                CallFrameView callFrameView = this.this$0.getTopFrame();
                                if (callFrameView == null) {
                                    Intrinsics.throwNpe();
                                }
                                arrayList.add(callFrameView);
                            } else {
                                Script script;
                                CallFrame frame = (CallFrame)((Object[])frames)[i];
                                String asyncFunctionName = frame.getAsyncFunctionName();
                                if (asyncFunctionName != null) {
                                    ((ArrayList)result3).add(new AsyncFramesHeader(asyncFunctionName));
                                }
                                if ((script = this.this$0.getSuspendContext().getVm().getScriptManager().getScript(frame)) != null) {
                                    boolean isInLibraryContent;
                                    SourceInfo sourceInfo = this.this$0.getViewSupport$script_debugger_ui().getSourceInfo(script, frame);
                                    boolean bl = isInLibraryContent = sourceInfo != null && this.this$0.getViewSupport$script_debugger_ui().isInLibraryContent(sourceInfo, script);
                                    if (!isInLibraryContent || XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames()) {
                                        ((ArrayList)result3).add(new CallFrameView(frame, this.this$0.getViewSupport$script_debugger_ui(), script, sourceInfo, isInLibraryContent, this.this$0.getSuspendContext().getVm()));
                                    }
                                }
                            }
                            if (i == n2) break;
                            ++i;
                        }
                    }
                }
                this.$container$inlined.addStackFrames(result3, true);
            }
            {
                this.$context = $captured_local_variable$1;
                this.this$0 = executionStackView;
                this.$firstFrameIndex$inlined = n;
                this.$container$inlined = xStackFrameContainer;
                super($super_call_param$2);
            }
        });
    }

    @NotNull
    public final SuspendContext<?> getSuspendContext() {
        return this.suspendContext;
    }

    @NotNull
    public final DebuggerViewSupport getViewSupport$script_debugger_ui() {
        return this.viewSupport;
    }

    public ExecutionStackView(@NotNull SuspendContext<?> suspendContext, @NotNull DebuggerViewSupport viewSupport, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo, @NotNull String displayName) {
        Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        super(displayName, AllIcons.Debugger.ThreadAtBreakpoint);
        this.suspendContext = suspendContext;
        this.viewSupport = viewSupport;
        this.topFrameScript = topFrameScript;
        this.topFrameSourceInfo = topFrameSourceInfo;
    }

    public /* synthetic */ ExecutionStackView(SuspendContext suspendContext, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        if ((n & 0x10) != 0) {
            string = "";
        }
        this(suspendContext, debuggerViewSupport, script, sourceInfo, string);
    }
}

