/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate;

import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.GenerateToStringWorker;
import org.jetbrains.java.generate.element.ClassElement;
import org.jetbrains.java.generate.element.Element;
import org.jetbrains.java.generate.element.ElementComparator;
import org.jetbrains.java.generate.element.ElementFactory;
import org.jetbrains.java.generate.element.ElementUtils;
import org.jetbrains.java.generate.element.FieldElement;
import org.jetbrains.java.generate.element.GenerationHelper;
import org.jetbrains.java.generate.exception.GenerateCodeException;
import org.jetbrains.java.generate.exception.PluginException;
import org.jetbrains.java.generate.psi.PsiAdapter;
import org.jetbrains.java.generate.velocity.VelocityFactory;

public class GenerationUtil {
    private static final Logger logger = Logger.getInstance((String)("#" + GenerationUtil.class.getName()));

    public static void handleException(Project project2, Exception e) throws RuntimeException {
        logger.info((Throwable)e);
        if (e instanceof GenerateCodeException) {
            Messages.showMessageDialog((Project)project2, (String)("Velocity error generating code - see IDEA log for more details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Warning", (Icon)Messages.getWarningIcon());
        } else if (e instanceof PluginException) {
            Messages.showMessageDialog((Project)project2, (String)("A PluginException was thrown while performing the action - see IDEA log for details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Warning", (Icon)Messages.getWarningIcon());
        } else {
            if (e instanceof RuntimeException) {
                Messages.showMessageDialog((Project)project2, (String)("An unrecoverable exception was thrown while performing the action - see IDEA log for details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Error", (Icon)Messages.getErrorIcon());
                throw (RuntimeException)e;
            }
            Messages.showMessageDialog((Project)project2, (String)("An unrecoverable exception was thrown while performing the action - see IDEA log for details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Error", (Icon)Messages.getErrorIcon());
            throw new RuntimeException(e);
        }
    }

    public static PsiElementClassMember[] combineToClassMemberList(PsiField[] filteredFields, PsiMethod[] filteredMethods) {
        int i;
        PsiElementClassMember[] members = new PsiElementClassMember[filteredFields.length + filteredMethods.length];
        for (i = 0; i < filteredFields.length; ++i) {
            members[i] = new PsiFieldMember(filteredFields[i]);
        }
        for (i = 0; i < filteredMethods.length; ++i) {
            members[filteredFields.length + i] = new PsiMethodMember(filteredMethods[i]);
        }
        return members;
    }

    public static List<PsiMember> convertClassMembersToPsiMembers(@Nullable List<PsiElementClassMember> classMemberList) {
        if (classMemberList == null || classMemberList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PsiMember> psiMemberList = new ArrayList<PsiMember>();
        for (PsiElementClassMember classMember : classMemberList) {
            psiMemberList.add((PsiMember)classMember.getElement());
        }
        return psiMemberList;
    }

    public static void applyJavaDoc(PsiMethod newMethod, String existingJavaDoc, String newJavaDoc) {
        String text = newJavaDoc != null ? newJavaDoc : existingJavaDoc;
        PsiAdapter.addOrReplaceJavadoc(newMethod, text, true);
    }

    public static String velocityGenerateCode(PsiClass clazz, Collection<? extends PsiMember> selectedMembers, Map<String, String> params, String templateMacro, int sortElements, boolean useFullyQualifiedName) throws GenerateCodeException {
        return GenerationUtil.velocityGenerateCode(clazz, selectedMembers, Collections.emptyList(), params, Collections.emptyMap(), templateMacro, sortElements, useFullyQualifiedName, false);
    }

    public static String velocityGenerateCode(@Nullable PsiClass clazz, Collection<? extends PsiMember> selectedMembers, Collection<? extends PsiMember> selectedNotNullMembers, Map<String, String> params, Map<String, Object> contextMap, String templateMacro, int sortElements, boolean useFullyQualifiedName, boolean useAccessors) throws GenerateCodeException {
        if (templateMacro == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try {
            VelocityContext vc = new VelocityContext();
            logger.debug("Velocity Context - adding fields");
            List<FieldElement> fieldElements = ElementUtils.getOnlyAsFieldElements(selectedMembers, selectedNotNullMembers, useAccessors);
            vc.put("fields", fieldElements);
            if (fieldElements.size() == 1) {
                vc.put("field", (Object)fieldElements.get(0));
            }
            PsiClass member = clazz != null ? clazz : (PsiMember)ContainerUtil.getFirstItem(selectedMembers);
            logger.debug("Velocity Context - adding methods");
            vc.put("methods", ElementUtils.getOnlyAsMethodElements(selectedMembers));
            logger.debug("Velocity Context - adding members (fields and methods)");
            List<Element> elements = ElementUtils.getOnlyAsFieldAndMethodElements(selectedMembers, selectedNotNullMembers, useAccessors);
            if (sortElements != 0) {
                Collections.sort(elements, new ElementComparator(sortElements));
            }
            vc.put("members", elements);
            if (clazz != null) {
                ClassElement ce = ElementFactory.newClassElement(clazz);
                vc.put("class", (Object)ce);
                if (logger.isDebugEnabled()) {
                    logger.debug("Velocity Context - adding class: " + ce);
                }
                vc.put("classname", (Object)(useFullyQualifiedName ? ce.getQualifiedName() : ce.getName()));
                vc.put("FQClassname", (Object)ce.getQualifiedName());
            }
            if (member != null) {
                vc.put("java_version", (Object)PsiAdapter.getJavaVersion((PsiElement)member));
                Project project2 = member.getProject();
                vc.put("settings", (Object)CodeStyleSettingsManager.getSettings((Project)project2));
                vc.put("project", (Object)project2);
            }
            vc.put("helper", GenerationHelper.class);
            vc.put("StringUtil", StringUtil.class);
            vc.put("NameUtil", NameUtil.class);
            for (String paramName : contextMap.keySet()) {
                vc.put(paramName, contextMap.get(paramName));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Velocity Macro:\n" + templateMacro);
            }
            VelocityEngine velocity = VelocityFactory.getVelocityEngine();
            logger.debug("Executing velocity +++ START +++");
            velocity.evaluate((Context)vc, (Writer)sw, GenerateToStringWorker.class.getName(), templateMacro);
            logger.debug("Executing velocity +++ END +++");
            if (vc.get("autoImportPackages") != null) {
                params.put("autoImportPackages", (String)vc.get("autoImportPackages"));
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GenerateCodeException("Error in Velocity code generator", e);
        }
        return StringUtil.convertLineSeparators((String)sw.getBuffer().toString());
    }
}

