/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.changedetection.state.DirSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FilesSnapshotSet;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.util.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileCollectionSnapshotImpl
implements FileCollectionSnapshot {
    final Map<String, IncrementalFileSnapshot> snapshots;

    public FileCollectionSnapshotImpl(Map<String, IncrementalFileSnapshot> snapshots) {
        this.snapshots = snapshots;
    }

    public List<File> getFiles() {
        ArrayList files = Lists.newArrayList();
        for (Map.Entry<String, IncrementalFileSnapshot> entry : this.snapshots.entrySet()) {
            if (entry.getValue() instanceof DirSnapshot) continue;
            files.add(new File(entry.getKey()));
        }
        return files;
    }

    @Override
    public FilesSnapshotSet getSnapshot() {
        return new FilesSnapshotSet(){

            public FileSnapshot findSnapshot(File file) {
                IncrementalFileSnapshot s = FileCollectionSnapshotImpl.this.snapshots.get(file.getAbsolutePath());
                if (s instanceof FileSnapshot) {
                    return (FileSnapshot)((Object)s);
                }
                return null;
            }
        };
    }

    @Override
    public FileCollectionSnapshot.ChangeIterator<String> iterateContentChangesSince(FileCollectionSnapshot oldSnapshot, Set<FileCollectionSnapshot.ChangeFilter> filters) {
        FileCollectionSnapshotImpl oldSnapshotImpl = (FileCollectionSnapshotImpl)oldSnapshot;
        final HashMap<String, IncrementalFileSnapshot> otherSnapshots = new HashMap<String, IncrementalFileSnapshot>(oldSnapshotImpl.snapshots);
        final Iterator<String> currentFiles = this.snapshots.keySet().iterator();
        final boolean includeAdded = !filters.contains((Object)FileCollectionSnapshot.ChangeFilter.IgnoreAddedFiles);
        return new FileCollectionSnapshot.ChangeIterator<String>(){
            private Iterator<String> removedFiles;

            @Override
            public boolean next(ChangeListener<String> listener) {
                while (currentFiles.hasNext()) {
                    String currentFile = (String)currentFiles.next();
                    IncrementalFileSnapshot otherFile = (IncrementalFileSnapshot)otherSnapshots.remove(currentFile);
                    if (otherFile == null) {
                        if (!includeAdded) continue;
                        listener.added(currentFile);
                        return true;
                    }
                    if (FileCollectionSnapshotImpl.this.snapshots.get(currentFile).isContentUpToDate(otherFile)) continue;
                    listener.changed(currentFile);
                    return true;
                }
                if (this.removedFiles == null) {
                    this.removedFiles = otherSnapshots.keySet().iterator();
                }
                if (this.removedFiles.hasNext()) {
                    listener.removed(this.removedFiles.next());
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public FileCollectionSnapshot updateFrom(FileCollectionSnapshot newSnapshot) {
        if (this.snapshots.isEmpty()) {
            return this;
        }
        FileCollectionSnapshotImpl newSnapshotImpl = (FileCollectionSnapshotImpl)newSnapshot;
        if (newSnapshotImpl.snapshots.isEmpty()) {
            return newSnapshotImpl;
        }
        HashMap<String, IncrementalFileSnapshot> newSnapshots = new HashMap<String, IncrementalFileSnapshot>(this.snapshots.size());
        for (String path : this.snapshots.keySet()) {
            IncrementalFileSnapshot newValue = newSnapshotImpl.snapshots.get(path);
            if (newValue == null) continue;
            newSnapshots.put(path, newValue);
        }
        return new FileCollectionSnapshotImpl(newSnapshots);
    }

    @Override
    public FileCollectionSnapshot applyAllChangesSince(FileCollectionSnapshot oldSnapshot, FileCollectionSnapshot target) {
        FileCollectionSnapshotImpl oldSnapshotImpl = (FileCollectionSnapshotImpl)oldSnapshot;
        FileCollectionSnapshotImpl targetImpl = (FileCollectionSnapshotImpl)target;
        HashMap<String, IncrementalFileSnapshot> newSnapshots = new HashMap<String, IncrementalFileSnapshot>(targetImpl.snapshots);
        this.diff(this.snapshots, oldSnapshotImpl.snapshots, newSnapshots);
        return new FileCollectionSnapshotImpl(newSnapshots);
    }

    private void diff(Map<String, IncrementalFileSnapshot> snapshots, Map<String, IncrementalFileSnapshot> oldSnapshots, Map<String, IncrementalFileSnapshot> target) {
        if (oldSnapshots.isEmpty()) {
            target.putAll(snapshots);
            return;
        }
        HashMap<String, IncrementalFileSnapshot> otherSnapshots = new HashMap<String, IncrementalFileSnapshot>(oldSnapshots);
        for (Map.Entry<String, IncrementalFileSnapshot> entry : snapshots.entrySet()) {
            IncrementalFileSnapshot otherFile = (IncrementalFileSnapshot)otherSnapshots.remove(entry.getKey());
            if (otherFile == null) {
                target.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue().isContentAndMetadataUpToDate(otherFile)) continue;
            target.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, IncrementalFileSnapshot> entry : otherSnapshots.entrySet()) {
            target.remove(entry.getKey());
        }
    }
}

