/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.junit3.JUnit3IdeaTestRunner;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.JUnitForkedSplitter;
import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.rt.execution.junit.segments.SegmentedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;

public class JUnitStarter {
    public static final int VERSION = 5;
    public static final String IDE_VERSION = "-ideVersion";
    public static final String JUNIT3_PARAMETER = "-junit3";
    public static final String JUNIT4_PARAMETER = "-junit4";
    public static final String JUNIT5_PARAMETER = "-junit5";
    public static final String JUNIT5_KEY = "idea.is.junit5";
    private static final String SOCKET = "-socket";
    public static final String JUNIT3_RUNNER_NAME = "com.intellij.junit3.JUnit3IdeaTestRunner";
    public static final String JUNIT4_RUNNER_NAME = "com.intellij.junit4.JUnit4IdeaTestRunner";
    public static final String JUNIT5_RUNNER_NAME = "com.intellij.junit5.JUnit5IdeaTestRunner";
    private static String ourForkMode;
    private static String ourCommandFileName;
    private static String ourWorkingDirs;
    private static int ourCount;
    public static boolean SM_RUNNER;

    private static boolean isSmRunner() {
        try {
            String property = System.getProperty("idea.junit.sm_runner");
            return property != null;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static void main(String[] args) throws IOException {
        Vector<String> argList = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            argList.addElement(arg);
        }
        ArrayList listeners = new ArrayList();
        String[] name = new String[1];
        String agentName = JUnitStarter.processParameters(argList, listeners, name);
        if (!JUnitStarter.canWorkWithJUnitVersion(System.err, agentName)) {
            System.exit(-3);
        }
        if (!JUnitStarter.checkVersion(args, System.err)) {
            System.exit(-3);
        }
        Object[] array = new String[argList.size()];
        argList.copyInto(array);
        int exitCode = JUnitStarter.prepareStreamsAndStart((String[])array, agentName, listeners, name[0]);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processParameters(Vector args, List listeners, String[] params) {
        String arg;
        int i;
        String agentName = JUnitStarter.isJUnit5Preferred() ? JUNIT5_RUNNER_NAME : JUNIT4_RUNNER_NAME;
        Vector<String> result = new Vector<String>(args.size());
        for (i = 0; i < args.size(); ++i) {
            arg = (String)args.get(i);
            if (arg.startsWith(IDE_VERSION)) continue;
            if (arg.equals(JUNIT3_PARAMETER)) {
                agentName = JUNIT3_RUNNER_NAME;
                continue;
            }
            if (arg.equals(JUNIT4_PARAMETER)) {
                agentName = JUNIT4_RUNNER_NAME;
                continue;
            }
            if (arg.equals(JUNIT5_PARAMETER)) {
                agentName = JUNIT5_RUNNER_NAME;
                continue;
            }
            if (arg.startsWith("@name")) {
                params[0] = arg.substring("@name".length());
                continue;
            }
            if (arg.startsWith("@w@")) {
                ourWorkingDirs = arg.substring(3);
                continue;
            }
            if (arg.startsWith("@@@")) {
                int pos = arg.indexOf(44);
                ourForkMode = arg.substring(3, pos);
                ourCommandFileName = arg.substring(pos + 1);
                continue;
            }
            if (arg.startsWith("@@")) {
                if (!new File(arg.substring(2)).exists()) continue;
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(arg.substring(2)));
                    while ((line = reader.readLine()) != null) {
                        listeners.add(line);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (arg.startsWith(SOCKET)) {
                int port = Integer.parseInt(arg.substring(SOCKET.length()));
                try {
                    Socket socket = new Socket(InetAddress.getByName("127.0.0.1"), port);
                    DataInputStream os = new DataInputStream(socket.getInputStream());
                    try {
                        os.readBoolean();
                    }
                    finally {
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            int count = RepeatCount.getCount(arg);
            if (count != 0) {
                ourCount = count;
                continue;
            }
            result.addElement(arg);
        }
        args.removeAllElements();
        for (i = 0; i < result.size(); ++i) {
            arg = (String)result.get(i);
            args.addElement(arg);
        }
        if (JUNIT3_RUNNER_NAME.equals(agentName)) {
            try {
                Class.forName("org.junit.runner.Computer");
                agentName = JUNIT4_RUNNER_NAME;
            }
            catch (ClassNotFoundException e) {
                return JUNIT3_RUNNER_NAME;
            }
        }
        try {
            String forceJUnit3 = System.getProperty("idea.force.junit3");
            if (forceJUnit3 != null && Boolean.valueOf(forceJUnit3).booleanValue()) {
                return JUNIT3_RUNNER_NAME;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return agentName;
    }

    public static boolean isJUnit5Preferred() {
        String useJUnit5 = System.getProperty(JUNIT5_KEY);
        Boolean boolValue = useJUnit5 == null ? null : Boolean.valueOf(useJUnit5);
        return boolValue != null && boolValue != false;
    }

    public static boolean checkVersion(String[] args, PrintStream printStream) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith(IDE_VERSION)) continue;
            int ideVersion = Integer.parseInt(arg.substring(IDE_VERSION.length(), arg.length()));
            if (ideVersion != 5) {
                printStream.println("Wrong agent version: 5. IDE expects version: " + ideVersion);
                printStream.flush();
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWorkWithJUnitVersion(PrintStream printStream, String agentName) {
        try {
            JUnitStarter.junitVersionChecks(agentName);
        }
        catch (Throwable e) {
            printStream.println("!!! JUnit version 3.8 or later expected:");
            printStream.println();
            e.printStackTrace(printStream);
            printStream.flush();
            boolean bl = false;
            return bl;
        }
        finally {
            printStream.flush();
        }
        return true;
    }

    private static void junitVersionChecks(String agentName) throws ClassNotFoundException {
        Class.forName("junit.framework.ComparisonFailure");
        JUnitStarter.getAgentClass(agentName);
        new TestRunner().setPrinter((ResultPrinter)new JUnit3IdeaTestRunner.MockResultPrinter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int prepareStreamsAndStart(String[] args, String agentName, ArrayList listeners, String name) {
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        try {
            PrintStream err;
            IdeaTestRunner testRunner = (IdeaTestRunner)JUnitStarter.getAgentClass(agentName).newInstance();
            PrintStream out = SM_RUNNER ? System.out : new SegmentedOutputStream(System.out);
            PrintStream printStream = err = SM_RUNNER ? System.err : new SegmentedOutputStream(System.err);
            if (!SM_RUNNER) {
                System.setOut(new PrintStream(out));
                System.setErr(new PrintStream(err));
            }
            if (ourCommandFileName != null && (!"none".equals(ourForkMode) || ourWorkingDirs != null && new File(ourWorkingDirs).length() > 0L)) {
                ArrayList<String> newArgs = new ArrayList<String>();
                newArgs.add(agentName);
                newArgs.addAll(listeners);
                PrintStream printOutputStream = SM_RUNNER ? out : ((SegmentedOutputStream)out).getPrintStream();
                PrintStream printErrStream = SM_RUNNER ? err : ((SegmentedOutputStream)err).getPrintStream();
                int n = new JUnitForkedSplitter(ourWorkingDirs, ourForkMode, printOutputStream, printErrStream, newArgs).startSplitting(args, name, ourCommandFileName);
                return n;
            }
            testRunner.setStreams(out, err, 0);
            int n = testRunner.startRunnerWithArgs(args, listeners, name, ourCount, true);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            int n = -2;
            return n;
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
    }

    static Class getAgentClass(String agentName) throws ClassNotFoundException {
        return Class.forName(agentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printClassesList(List classNames, String packageName, String category, File tempFile) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
        try {
            writer.println(packageName);
            writer.println(category);
            for (int i = 0; i < classNames.size(); ++i) {
                writer.println(classNames.get(i));
            }
        }
        finally {
            writer.close();
        }
    }

    static {
        ourCount = 1;
        SM_RUNNER = JUnitStarter.isSmRunner();
    }
}

