/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit4.discovery;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.DiscoveryFilter;
import org.junit.gen5.engine.DiscoverySelector;
import org.junit.gen5.engine.EngineDiscoveryRequest;
import org.junit.gen5.engine.Filter;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.discovery.ClassFilter;
import org.junit.gen5.engine.junit4.discovery.ClassSelectorResolver;
import org.junit.gen5.engine.junit4.discovery.ClasspathSelectorResolver;
import org.junit.gen5.engine.junit4.discovery.DiscoverySelectorResolver;
import org.junit.gen5.engine.junit4.discovery.MethodSelectorResolver;
import org.junit.gen5.engine.junit4.discovery.PackageNameSelectorResolver;
import org.junit.gen5.engine.junit4.discovery.TestClassCollector;
import org.junit.gen5.engine.junit4.discovery.TestClassRequest;
import org.junit.gen5.engine.junit4.discovery.TestClassRequestResolver;
import org.junit.gen5.engine.junit4.discovery.UniqueIdSelectorResolver;
import org.junit.gen5.engine.support.descriptor.EngineDescriptor;
import org.junit.gen5.engine.support.filter.ExclusionReasonConsumingFilter;

@API(value=API.Usage.Internal)
public class JUnit4DiscoveryRequestResolver {
    private final EngineDescriptor engineDescriptor;
    private final Logger logger;

    public JUnit4DiscoveryRequestResolver(EngineDescriptor engineDescriptor, Logger logger) {
        this.engineDescriptor = engineDescriptor;
        this.logger = logger;
    }

    public void resolve(EngineDiscoveryRequest discoveryRequest) {
        TestClassCollector collector = this.collectTestClasses(discoveryRequest);
        Set<TestClassRequest> requests = this.filterAndConvertToTestClassRequests(discoveryRequest, collector);
        this.populateEngineDescriptor(requests);
    }

    private TestClassCollector collectTestClasses(EngineDiscoveryRequest discoveryRequest) {
        TestClassCollector collector = new TestClassCollector();
        for (DiscoverySelectorResolver<?> selectorResolver : this.getAllDiscoverySelectorResolvers()) {
            this.resolveSelectorsOfSingleType(discoveryRequest, selectorResolver, collector);
        }
        return collector;
    }

    private List<DiscoverySelectorResolver<?>> getAllDiscoverySelectorResolvers() {
        return Arrays.asList(new ClasspathSelectorResolver(), new PackageNameSelectorResolver(), new ClassSelectorResolver(), new MethodSelectorResolver(), new UniqueIdSelectorResolver(this.logger));
    }

    private <T extends DiscoverySelector> void resolveSelectorsOfSingleType(EngineDiscoveryRequest discoveryRequest, DiscoverySelectorResolver<T> selectorResolver, TestClassCollector collector) {
        discoveryRequest.getSelectorsByType(selectorResolver.getSelectorClass()).forEach(selector -> selectorResolver.resolve(selector, collector));
    }

    private Set<TestClassRequest> filterAndConvertToTestClassRequests(EngineDiscoveryRequest discoveryRequest, TestClassCollector collector) {
        List allClassFilters = discoveryRequest.getDiscoveryFiltersByType(ClassFilter.class);
        ExclusionReasonConsumingFilter classFilter = new ExclusionReasonConsumingFilter((Filter)DiscoveryFilter.combine((Collection)allClassFilters), (testClass, reason) -> this.logger.info(String.format("Class %s was excluded by a class filter: %s", testClass.getName(), reason.orElse("<unknown reason>"))));
        return collector.toRequests(classFilter.toPredicate());
    }

    private void populateEngineDescriptor(Set<TestClassRequest> requests) {
        new TestClassRequestResolver((TestDescriptor)this.engineDescriptor, this.logger).populateEngineDescriptorFrom(requests);
    }
}

