/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit4.execution;

import java.util.logging.Logger;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.EngineExecutionListener;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestExecutionResult;
import org.junit.gen5.engine.junit4.descriptor.RunnerTestDescriptor;
import org.junit.gen5.engine.junit4.execution.RunListenerAdapter;
import org.junit.gen5.engine.junit4.execution.TestRun;
import org.junit.runner.JUnitCore;
import org.junit.runner.notification.RunListener;

@API(value=API.Usage.Internal)
public class RunnerExecutor {
    private final EngineExecutionListener engineExecutionListener;
    private final Logger logger;

    public RunnerExecutor(EngineExecutionListener engineExecutionListener, Logger logger) {
        this.engineExecutionListener = engineExecutionListener;
        this.logger = logger;
    }

    public void execute(RunnerTestDescriptor runnerTestDescriptor) {
        TestRun testRun = new TestRun(runnerTestDescriptor, this.logger);
        JUnitCore core = new JUnitCore();
        core.addListener((RunListener)new RunListenerAdapter(testRun, this.engineExecutionListener));
        try {
            core.run(runnerTestDescriptor.toRequest());
        }
        catch (Throwable t) {
            this.reportUnexpectedFailure(testRun, runnerTestDescriptor, TestExecutionResult.failed((Throwable)t));
        }
    }

    private void reportUnexpectedFailure(TestRun testRun, RunnerTestDescriptor runnerTestDescriptor, TestExecutionResult result) {
        if (testRun.isNotStarted((TestDescriptor)runnerTestDescriptor)) {
            this.engineExecutionListener.executionStarted((TestDescriptor)runnerTestDescriptor);
        }
        this.engineExecutionListener.executionFinished((TestDescriptor)runnerTestDescriptor, result);
    }
}

