/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.ui.ConfigureCvsGlobalSettingsDialog;
import com.intellij.cvsSupport2.config.ui.CvsConfigurationsListEditor;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.ui.CvsTabbedWindowComponent;
import com.intellij.icons.AllIcons;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.errorView.ContentManagerProvider;
import com.intellij.ui.errorView.ErrorViewFactory;
import com.intellij.util.ui.ErrorTreeView;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CvsTabbedWindow
implements Disposable {
    private final Project myProject;
    private Editor myOutput = null;
    private ErrorTreeView myErrorsView;

    public CvsTabbedWindow(Project project) {
        this.myProject = project;
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CvsTabbedWindow.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow toolWindow = CvsTabbedWindow.this.getToolWindow();
                ContentManager contentManager = toolWindow.getContentManager();
                contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                    public void contentRemoved(ContentManagerEvent event) {
                        JComponent removedComponent;
                        JComponent component = event.getContent().getComponent();
                        JComponent jComponent = removedComponent = component instanceof CvsTabbedWindowComponent ? ((CvsTabbedWindowComponent)component).getComponent() : component;
                        if (removedComponent == CvsTabbedWindow.this.myErrorsView) {
                            CvsTabbedWindow.this.myErrorsView.dispose();
                            CvsTabbedWindow.this.myErrorsView = null;
                        } else if (CvsTabbedWindow.this.myOutput != null && removedComponent == CvsTabbedWindow.this.myOutput.getComponent()) {
                            EditorFactory.getInstance().releaseEditor(CvsTabbedWindow.this.myOutput);
                            CvsTabbedWindow.this.myOutput = null;
                        }
                    }
                });
                toolWindow.installWatcher(contentManager);
            }
        });
    }

    public void dispose() {
        if (this.myOutput != null) {
            EditorFactory.getInstance().releaseEditor(this.myOutput);
            this.myOutput = null;
        }
        if (this.myErrorsView != null) {
            this.myErrorsView.dispose();
            this.myErrorsView = null;
        }
    }

    @NotNull
    private ToolWindow getToolWindow() {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.VCS);
        assert (toolWindow != null) : "Version Control ToolWindow should be available at this point.";
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/ui/CvsTabbedWindow", "getToolWindow"));
        }
        return toolWindow2;
    }

    public static CvsTabbedWindow getInstance(Project project) {
        return (CvsTabbedWindow)PeriodicalTasksCloser.getInstance().safeGetService(project, CvsTabbedWindow.class);
    }

    public void addTab(String title, JComponent component, boolean selectTab, boolean replaceContent, boolean lockable, boolean addDefaultToolbar, @Nullable ActionGroup toolbarActions, @NonNls String helpId) {
        ContentManager contentManager = this.getToolWindow().getContentManager();
        Content existingContent = contentManager.findContent(title);
        if (existingContent != null) {
            JComponent existingComponent = existingContent.getComponent();
            if (existingComponent instanceof DeactivateListener) {
                ((DeactivateListener)((Object)existingComponent)).deactivated();
            }
            if (!replaceContent) {
                contentManager.setSelectedContent(existingContent);
                return;
            }
            if (!existingContent.isPinned()) {
                contentManager.removeContent(existingContent, true);
                existingContent.release();
            }
        }
        CvsTabbedWindowComponent newComponent = new CvsTabbedWindowComponent(component, addDefaultToolbar, toolbarActions, contentManager, helpId);
        Content content = contentManager.getFactory().createContent(newComponent.getShownComponent(), title, lockable);
        newComponent.setContent(content);
        contentManager.addContent(content);
        if (selectTab) {
            this.getToolWindow().activate(null, false);
        }
    }

    public ErrorTreeView getErrorsTreeView() {
        if (this.myErrorsView == null) {
            this.myErrorsView = ErrorViewFactory.SERVICE.getInstance().createErrorTreeView(this.myProject, null, true, new AnAction[]{(DefaultActionGroup)ActionManager.getInstance().getAction("CvsActions")}, new AnAction[]{new GlobalCvsSettingsAction(), new ReconfigureCvsRootAction()}, new ContentManagerProvider(){

                public ContentManager getParentContent() {
                    return CvsTabbedWindow.this.getToolWindow().getContentManager();
                }
            });
            this.addTab(CvsBundle.message((String)"tab.title.errors", (Object[])new Object[0]), this.myErrorsView.getComponent(), true, false, true, false, null, "cvs.errors");
        }
        this.getToolWindow().activate(null, false);
        return this.myErrorsView;
    }

    public Editor getOutput() {
        if (this.myOutput == null) {
            Editor outputEditor = CvsTabbedWindow.createOutputEditor(this.myProject);
            this.addTab(CvsBundle.message((String)"tab.title.cvs.output", (Object[])new Object[0]), outputEditor.getComponent(), false, false, false, true, null, "cvs.cvsOutput");
            this.myOutput = outputEditor;
        }
        return this.myOutput;
    }

    @NotNull
    private static Editor createOutputEditor(Project project) {
        Editor result = EditorFactory.getInstance().createViewer(EditorFactory.getInstance().createDocument((CharSequence)""), project);
        EditorSettings editorSettings = result.getSettings();
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setFoldingOutlineShown(false);
        Editor editor = result;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/ui/CvsTabbedWindow", "createOutputEditor"));
        }
        return editor;
    }

    private class ReconfigureCvsRootAction
    extends AnAction {
        public ReconfigureCvsRootAction() {
            super(CvsBundle.message((String)"action.name.reconfigure.cvs.root", (Object[])new Object[0]), null, AllIcons.Nodes.Cvs_roots);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Object data = ErrorTreeView.CURRENT_EXCEPTION_DATA_KEY.getData(e.getDataContext());
            e.getPresentation().setEnabled(data instanceof CvsException);
        }

        public void actionPerformed(AnActionEvent e) {
            Object data = ErrorTreeView.CURRENT_EXCEPTION_DATA_KEY.getData(e.getDataContext());
            CvsConfigurationsListEditor.reconfigureCvsRoot(((CvsException)((Object)data)).getCvsRoot(), CvsTabbedWindow.this.myProject);
        }
    }

    private static class GlobalCvsSettingsAction
    extends AnAction {
        public GlobalCvsSettingsAction() {
            super(CvsBundle.message((String)"configure.global.cvs.settings.action.name", (Object[])new Object[0]), null, AllIcons.Nodes.Cvs_global);
        }

        public void actionPerformed(AnActionEvent e) {
            new ConfigureCvsGlobalSettingsDialog(e.getProject()).show();
        }
    }

    public static interface DeactivateListener {
        public void deactivated();
    }
}

