/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBookmarkCommand {
    public static void createBookmarkAsynchronously(final @NotNull List<HgRepository> repositories, final @NotNull String name, final boolean isActive) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/command/HgBookmarkCommand", "createBookmarkAsynchronously"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/zmlx/hg4idea/command/HgBookmarkCommand", "createBookmarkAsynchronously"));
        }
        final Project project = ((HgRepository)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(repositories))).getProject();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            VcsNotifier.getInstance((Project)project).notifyError("Hg Error", "Bookmark name is empty");
        }
        new Task.Backgroundable(project, HgVcsMessages.message("hg4idea.progress.bookmark", name)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/command/HgBookmarkCommand$1", "run"));
                }
                for (HgRepository repository : repositories) {
                    HgBookmarkCommand.executeBookmarkCommandSynchronously(project, repository.getRoot(), name, isActive ? ContainerUtil.emptyList() : Collections.singletonList("--inactive"));
                }
            }
        }.queue();
    }

    public static void deleteBookmarkSynchronously(@NotNull Project project, @NotNull VirtualFile repo, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgBookmarkCommand", "deleteBookmarkSynchronously"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgBookmarkCommand", "deleteBookmarkSynchronously"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/zmlx/hg4idea/command/HgBookmarkCommand", "deleteBookmarkSynchronously"));
        }
        HgBookmarkCommand.executeBookmarkCommandSynchronously(project, repo, name, Collections.singletonList("-d"));
    }

    private static void executeBookmarkCommandSynchronously(@NotNull Project project, @NotNull VirtualFile repositoryRoot, @NotNull String name, @NotNull List<String> args) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgBookmarkCommand", "executeBookmarkCommandSynchronously"));
        }
        if (repositoryRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryRoot", "org/zmlx/hg4idea/command/HgBookmarkCommand", "executeBookmarkCommandSynchronously"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/zmlx/hg4idea/command/HgBookmarkCommand", "executeBookmarkCommandSynchronously"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/zmlx/hg4idea/command/HgBookmarkCommand", "executeBookmarkCommandSynchronously"));
        }
        ArrayList arguments = ContainerUtil.newArrayList(args);
        arguments.add(name);
        HgCommandResult result = new HgCommandExecutor(project).executeInCurrentThread(repositoryRoot, "bookmark", arguments);
        if (project.isDisposed()) {
            return;
        }
        HgUtil.getRepositoryManager(project).updateRepository(repositoryRoot);
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(project).notifyError(result, "Hg Error", String.format("Hg bookmark command failed for repository %s with name %s ", repositoryRoot.getName(), name));
        }
    }
}

