/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.ui;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.ui.TaskDialogPanel;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TaskDialogPanelProvider {
    private static final ExtensionPointName<TaskDialogPanelProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.tasks.dialogPanelProvider");

    public static List<TaskDialogPanel> getOpenTaskPanels(final @NotNull Project project, final @NotNull Task task) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/ui/TaskDialogPanelProvider", "getOpenTaskPanels"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/ui/TaskDialogPanelProvider", "getOpenTaskPanels"));
        }
        return ContainerUtil.mapNotNull((Object[])Extensions.getExtensions(EP_NAME), (Function)new NullableFunction<TaskDialogPanelProvider, TaskDialogPanel>(){

            @Nullable
            public TaskDialogPanel fun(TaskDialogPanelProvider provider) {
                return provider.getOpenTaskPanel(project, task);
            }
        });
    }

    public static List<TaskDialogPanel> getCloseTaskPanels(final @NotNull Project project, final @NotNull LocalTask task) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/ui/TaskDialogPanelProvider", "getCloseTaskPanels"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/ui/TaskDialogPanelProvider", "getCloseTaskPanels"));
        }
        return ContainerUtil.mapNotNull((Object[])Extensions.getExtensions(EP_NAME), (Function)new NullableFunction<TaskDialogPanelProvider, TaskDialogPanel>(){

            @Nullable
            public TaskDialogPanel fun(TaskDialogPanelProvider provider) {
                return provider.getCloseTaskPanel(project, task);
            }
        });
    }

    @Nullable
    public abstract TaskDialogPanel getOpenTaskPanel(@NotNull Project var1, @NotNull Task var2);

    @Nullable
    public abstract TaskDialogPanel getCloseTaskPanel(@NotNull Project var1, @NotNull LocalTask var2);
}

