/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.CommonBundle;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.checkin.GitCommitAndPushExecutor;
import git4idea.checkin.GitUserNameNotDefinedDialog;
import git4idea.commands.Git;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.crlf.GitCrlfDialog;
import git4idea.crlf.GitCrlfProblemsDetector;
import git4idea.crlf.GitCrlfUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    private static final Logger LOG = Logger.getInstance(GitCheckinHandlerFactory.class);

    public GitCheckinHandlerFactory() {
        super(GitVcs.getKey());
    }

    @NotNull
    protected CheckinHandler createVcsHandler(CheckinProjectPanel panel) {
        MyCheckinHandler myCheckinHandler = new MyCheckinHandler(panel);
        if (myCheckinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory", "createVcsHandler"));
        }
        return myCheckinHandler;
    }

    private class MyCheckinHandler
    extends CheckinHandler {
        @NotNull
        private final CheckinProjectPanel myPanel;
        @NotNull
        private final Project myProject;

        public MyCheckinHandler(CheckinProjectPanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "<init>"));
            }
            this.myPanel = panel;
            this.myProject = this.myPanel.getProject();
        }

        public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
            if (this.emptyCommitMessage()) {
                return CheckinHandler.ReturnResult.CANCEL;
            }
            if (this.commitOrCommitAndPush(executor)) {
                CheckinHandler.ReturnResult result = this.checkUserName();
                if (result != CheckinHandler.ReturnResult.COMMIT) {
                    return result;
                }
                result = this.warnAboutCrlfIfNeeded();
                if (result != CheckinHandler.ReturnResult.COMMIT) {
                    return result;
                }
                return this.warnAboutDetachedHeadIfNeeded();
            }
            return CheckinHandler.ReturnResult.COMMIT;
        }

        @NotNull
        private CheckinHandler.ReturnResult warnAboutCrlfIfNeeded() {
            GitVcsSettings settings = GitVcsSettings.getInstance(this.myProject);
            if (!settings.warnAboutCrlf()) {
                CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
                if (returnResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "warnAboutCrlfIfNeeded"));
                }
                return returnResult;
            }
            final Git git = (Git)ServiceManager.getService(Git.class);
            final Collection files = this.myPanel.getVirtualFiles();
            final AtomicReference crlfHelper = new AtomicReference();
            ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, "Checking for line separator issues...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$1", "run"));
                    }
                    crlfHelper.set(GitCrlfProblemsDetector.detect(MyCheckinHandler.this.myProject, git, files));
                }
            });
            if (crlfHelper.get() == null) {
                CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.CANCEL;
                if (returnResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "warnAboutCrlfIfNeeded"));
                }
                return returnResult;
            }
            if (((GitCrlfProblemsDetector)crlfHelper.get()).shouldWarn()) {
                Pair codeAndDontWarn = (Pair)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<Pair<Integer, Boolean>>(){

                    public Pair<Integer, Boolean> compute() {
                        GitCrlfDialog dialog = new GitCrlfDialog(MyCheckinHandler.this.myProject);
                        dialog.show();
                        return Pair.create((Object)dialog.getExitCode(), (Object)dialog.dontWarnAgain());
                    }
                });
                int decision = (Integer)codeAndDontWarn.first;
                boolean dontWarnAgain = (Boolean)codeAndDontWarn.second;
                if (decision == 1) {
                    CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.CANCEL;
                    if (returnResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "warnAboutCrlfIfNeeded"));
                    }
                    return returnResult;
                }
                if (decision == 0) {
                    VirtualFile anyRoot = (VirtualFile)this.myPanel.getRoots().iterator().next();
                    this.setCoreAutoCrlfAttribute(anyRoot);
                } else if (dontWarnAgain) {
                    settings.setWarnAboutCrlf(false);
                }
                CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
                if (returnResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "warnAboutCrlfIfNeeded"));
                }
                return returnResult;
            }
            CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
            if (returnResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "warnAboutCrlfIfNeeded"));
            }
            return returnResult;
        }

        private void setCoreAutoCrlfAttribute(@NotNull VirtualFile aRoot) {
            if (aRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aRoot", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "setCoreAutoCrlfAttribute"));
            }
            try {
                GitConfigUtil.setValue(this.myProject, aRoot, "core.autocrlf", GitCrlfUtil.RECOMMENDED_VALUE, "--global");
            }
            catch (VcsException e) {
                LOG.warn("Couldn't globally set core.autocrlf in " + aRoot, (Throwable)e);
            }
        }

        private CheckinHandler.ReturnResult checkUserName() {
            GitUserNameNotDefinedDialog dialog;
            Project project = this.myPanel.getProject();
            GitVcs vcs = GitVcs.getInstance(project);
            assert (vcs != null);
            Collection<VirtualFile> affectedRoots = this.getSelectedRoots();
            Map<VirtualFile, Couple<String>> defined = this.getDefinedUserNames(project, affectedRoots, false);
            ArrayList<VirtualFile> allRoots = new ArrayList<VirtualFile>(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs)));
            ArrayList<VirtualFile> notDefined = new ArrayList<VirtualFile>(affectedRoots);
            notDefined.removeAll(defined.keySet());
            if (notDefined.isEmpty()) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            GitVersion version = vcs.getVersion();
            if (System.getenv("HOME") == null && GitVersionSpecialty.DOESNT_DEFINE_HOME_ENV_VAR.existsIn(version)) {
                Messages.showErrorDialog((Project)project, (String)("You are using Git " + version + " which doesn't define %HOME% environment variable properly.\n" + "Consider updating Git to a newer version " + "or define %HOME% to point to the place where the global .gitconfig is stored \n" + "(it is usually %USERPROFILE% or %HOMEDRIVE%%HOMEPATH%)."), (String)"HOME Variable Is Not Defined");
                return CheckinHandler.ReturnResult.CANCEL;
            }
            if (defined.isEmpty() && allRoots.size() > affectedRoots.size()) {
                allRoots.removeAll(affectedRoots);
                defined.putAll(this.getDefinedUserNames(project, allRoots, true));
            }
            if ((dialog = new GitUserNameNotDefinedDialog(project, notDefined, affectedRoots, defined)).showAndGet()) {
                return this.setUserNameUnderProgress(project, notDefined, dialog) ? CheckinHandler.ReturnResult.COMMIT : CheckinHandler.ReturnResult.CANCEL;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }

        @NotNull
        private Map<VirtualFile, Couple<String>> getDefinedUserNames(final @NotNull Project project, final @NotNull Collection<VirtualFile> roots, final boolean stopWhenFoundFirst) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "getDefinedUserNames"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "getDefinedUserNames"));
            }
            final HashMap defined = ContainerUtil.newHashMap();
            ProgressManager.getInstance().run((Task)new Task.Modal(project, "Checking Git user name...", true){

                public void run(@NotNull ProgressIndicator pi) {
                    if (pi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$3", "run"));
                    }
                    for (VirtualFile root : roots) {
                        try {
                            Couple nameAndEmail = MyCheckinHandler.this.getUserNameAndEmailFromGitConfig(project, root);
                            String name = (String)nameAndEmail.getFirst();
                            String email = (String)nameAndEmail.getSecond();
                            if (name == null || email == null) continue;
                            defined.put(root, nameAndEmail);
                            if (!stopWhenFoundFirst) continue;
                            return;
                        }
                        catch (VcsException e) {
                            LOG.error("Couldn't get user.name and user.email for root " + root, (Throwable)e);
                        }
                    }
                }
            });
            HashMap hashMap = defined;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "getDefinedUserNames"));
            }
            return hashMap;
        }

        private boolean setUserNameUnderProgress(final @NotNull Project project, final @NotNull Collection<VirtualFile> notDefined, final @NotNull GitUserNameNotDefinedDialog dialog) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "setUserNameUnderProgress"));
            }
            if (notDefined == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notDefined", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "setUserNameUnderProgress"));
            }
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "setUserNameUnderProgress"));
            }
            final Ref error = Ref.create();
            ProgressManager.getInstance().run((Task)new Task.Modal(project, "Setting Git User Name...", true){

                public void run(@NotNull ProgressIndicator pi) {
                    if (pi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$4", "run"));
                    }
                    try {
                        if (dialog.isGlobal()) {
                            GitConfigUtil.setValue(project, (VirtualFile)notDefined.iterator().next(), "user.name", dialog.getUserName(), "--global");
                            GitConfigUtil.setValue(project, (VirtualFile)notDefined.iterator().next(), "user.email", dialog.getUserEmail(), "--global");
                        } else {
                            for (VirtualFile root : notDefined) {
                                GitConfigUtil.setValue(project, root, "user.name", dialog.getUserName(), new String[0]);
                                GitConfigUtil.setValue(project, root, "user.email", dialog.getUserEmail(), new String[0]);
                            }
                        }
                    }
                    catch (VcsException e) {
                        String message = "Couldn't set user.name and user.email";
                        LOG.error(message, (Throwable)e);
                        error.set((Object)message);
                    }
                }
            });
            if (error.isNull()) {
                return true;
            }
            Messages.showErrorDialog((Component)this.myPanel.getComponent(), (String)((String)error.get()));
            return false;
        }

        @NotNull
        private Couple<String> getUserNameAndEmailFromGitConfig(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "getUserNameAndEmailFromGitConfig"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "getUserNameAndEmailFromGitConfig"));
            }
            String name = GitConfigUtil.getValue(project, root, "user.name");
            String email = GitConfigUtil.getValue(project, root, "user.email");
            Couple couple = Couple.of((Object)name, (Object)email);
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "getUserNameAndEmailFromGitConfig"));
            }
            return couple;
        }

        private boolean emptyCommitMessage() {
            if (this.myPanel.getCommitMessage().trim().isEmpty()) {
                Messages.showMessageDialog((Component)this.myPanel.getComponent(), (String)GitBundle.message("git.commit.message.empty", new Object[0]), (String)GitBundle.message("git.commit.message.empty.title", new Object[0]), (Icon)Messages.getErrorIcon());
                return true;
            }
            return false;
        }

        private CheckinHandler.ReturnResult warnAboutDetachedHeadIfNeeded() {
            String message;
            String title;
            DetachedRoot detachedRoot = this.getDetachedRoot();
            if (detachedRoot == null || !GitVcsSettings.getInstance(this.myProject).warnAboutDetachedHead()) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            CharSequence rootPath = StringUtil.last((CharSequence)detachedRoot.myRoot.getPresentableUrl(), (int)50, (boolean)true);
            String messageCommonStart = "The Git repository <code>" + rootPath + "</code>";
            if (detachedRoot.myRebase) {
                title = "Unfinished rebase process";
                message = messageCommonStart + " <br/> has an <b>unfinished rebase</b> process. <br/>" + "You probably want to <b>continue rebase</b> instead of committing. <br/>" + "Committing during rebase may lead to the commit loss. <br/>" + this.readMore("http://www.kernel.org/pub/software/scm/git/docs/git-rebase.html", "Read more about Git rebase");
            } else {
                title = "Commit in detached HEAD may be dangerous";
                message = messageCommonStart + " is in the <b>detached HEAD</b> state. <br/>" + "You can look around, make experimental changes and commit them, but be sure to checkout a branch not to lose your work. <br/>" + "Otherwise you risk losing your changes. <br/>" + this.readMore("http://gitolite.com/detached-head.html", "Read more about detached HEAD");
            }
            DialogWrapper.DoNotAskOption dontAskAgain = new DialogWrapper.DoNotAskOption(){

                public boolean isToBeShown() {
                    return true;
                }

                public void setToBeShown(boolean toBeShown, int exitCode) {
                    if (exitCode == 0) {
                        GitVcsSettings.getInstance(MyCheckinHandler.this.myProject).setWarnAboutDetachedHead(toBeShown);
                    }
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return false;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    if ("Don't warn again" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$5", "getDoNotShowMessage"));
                    }
                    return "Don't warn again";
                }
            };
            int choice = Messages.showOkCancelDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)title, (String)"Commit", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)dontAskAgain);
            if (choice == 0) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }

        private boolean commitOrCommitAndPush(@Nullable CommitExecutor executor) {
            return executor == null || executor instanceof GitCommitAndPushExecutor;
        }

        private String readMore(String link, String message) {
            if (Messages.canShowMacSheetPanel()) {
                return message + ":\n" + link;
            }
            return String.format("<a href='%s'>%s</a>.", link, message);
        }

        @Nullable
        private DetachedRoot getDetachedRoot() {
            GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(this.myPanel.getProject());
            for (VirtualFile root : this.getSelectedRoots()) {
                GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot(root);
                if (repository == null || repository.isOnBranch()) continue;
                return new DetachedRoot(root, repository.isRebaseInProgress());
            }
            return null;
        }

        @NotNull
        private Collection<VirtualFile> getSelectedRoots() {
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            HashSet<VirtualFile> result = new HashSet<VirtualFile>();
            for (FilePath path : ChangesUtil.getPaths((Collection)this.myPanel.getSelectedChanges())) {
                VirtualFile root = vcsManager.getVcsRootFor(path);
                if (root == null) continue;
                result.add(root);
            }
            HashSet<VirtualFile> hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler", "getSelectedRoots"));
            }
            return hashSet;
        }

        private class DetachedRoot {
            final VirtualFile myRoot;
            final boolean myRebase;

            public DetachedRoot(VirtualFile root, boolean rebase) {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$DetachedRoot", "<init>"));
                }
                this.myRoot = root;
                this.myRebase = rebase;
            }
        }
    }
}

