/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import org.jetbrains.annotations.NotNull;

public class GitFreezingProcess {
    private static final Logger LOG = Logger.getInstance(GitFreezingProcess.class);
    @NotNull
    private final String myOperationTitle;
    @NotNull
    private final Runnable myRunnable;
    @NotNull
    private final Application myApplication;
    @NotNull
    private final ChangeListManagerEx myChangeListManager;
    @NotNull
    private final ProjectManagerEx myProjectManager;
    @NotNull
    private final SaveAndSyncHandler mySaveAndSyncHandler;

    public GitFreezingProcess(@NotNull Project project, @NotNull String operationTitle, @NotNull Runnable runnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/util/GitFreezingProcess", "<init>"));
        }
        if (operationTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationTitle", "git4idea/util/GitFreezingProcess", "<init>"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "git4idea/util/GitFreezingProcess", "<init>"));
        }
        this.myOperationTitle = operationTitle;
        this.myRunnable = runnable;
        this.myApplication = ApplicationManager.getApplication();
        this.myChangeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        this.mySaveAndSyncHandler = SaveAndSyncHandler.getInstance();
    }

    public void execute() {
        LOG.debug("starting");
        try {
            LOG.debug("saving documents, blocking project autosync");
            this.saveAndBlockInAwt();
            LOG.debug("freezing the ChangeListManager");
            this.freeze();
            try {
                LOG.debug("running the operation");
                this.myRunnable.run();
                LOG.debug("operation completed.");
            }
            finally {
                LOG.debug("unfreezing the ChangeListManager");
                this.unfreezeInAwt();
            }
        }
        finally {
            LOG.debug("unblocking project autosync");
            this.unblockInAwt();
        }
        LOG.debug("finished.");
    }

    public void saveAndBlock() {
        this.myProjectManager.blockReloadingProjectOnExternalChanges();
        FileDocumentManager.getInstance().saveAllDocuments();
        this.mySaveAndSyncHandler.blockSaveOnFrameDeactivation();
        this.mySaveAndSyncHandler.blockSyncOnFrameActivation();
    }

    private void saveAndBlockInAwt() {
        RethrowingRunnable rethrowingRunnable = new RethrowingRunnable(new Runnable(){

            @Override
            public void run() {
                GitFreezingProcess.this.saveAndBlock();
            }
        });
        this.myApplication.invokeAndWait((Runnable)rethrowingRunnable, ModalityState.defaultModalityState());
        rethrowingRunnable.rethrowIfHappened();
    }

    private void unblockInAwt() {
        RethrowingRunnable rethrowingRunnable = new RethrowingRunnable(new Runnable(){

            @Override
            public void run() {
                GitFreezingProcess.this.unblock();
            }
        });
        this.myApplication.invokeAndWait((Runnable)rethrowingRunnable, ModalityState.defaultModalityState());
        rethrowingRunnable.rethrowIfHappened();
    }

    public void unblock() {
        this.myProjectManager.unblockReloadingProjectOnExternalChanges();
        this.mySaveAndSyncHandler.unblockSaveOnFrameDeactivation();
        this.mySaveAndSyncHandler.unblockSyncOnFrameActivation();
    }

    private void freeze() {
        this.myChangeListManager.freezeImmediately("Local changes are not available until Git " + this.myOperationTitle + " is finished.");
    }

    private void unfreeze() {
        this.myChangeListManager.letGo();
    }

    private void unfreezeInAwt() {
        RethrowingRunnable rethrowingRunnable = new RethrowingRunnable(new Runnable(){

            @Override
            public void run() {
                GitFreezingProcess.this.unfreeze();
            }
        });
        this.myApplication.invokeAndWait((Runnable)rethrowingRunnable, ModalityState.defaultModalityState());
        rethrowingRunnable.rethrowIfHappened();
    }

    private static class RethrowingRunnable
    implements Runnable {
        private final Runnable myRunnable;
        private RuntimeException myException;

        RethrowingRunnable(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "git4idea/util/GitFreezingProcess$RethrowingRunnable", "<init>"));
            }
            this.myRunnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.myRunnable.run();
            }
            catch (Throwable t) {
                RuntimeException re;
                this.myException = re = new RuntimeException(t);
                throw re;
            }
        }

        void rethrowIfHappened() {
            if (this.myException != null) {
                throw this.myException;
            }
        }
    }
}

