/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAugmentProvider {
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.lang.psiAugmentProvider");

    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/augment/PsiAugmentProvider", "getAugments"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/augment/PsiAugmentProvider", "getAugments"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/augment/PsiAugmentProvider", "getAugments"));
        }
        return list;
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/psi/augment/PsiAugmentProvider", "inferType"));
        }
        return null;
    }

    @Nullable
    protected Boolean hasModifierProperty(@NotNull PsiModifierList modifierList, @NotNull String name) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "com/intellij/psi/augment/PsiAugmentProvider", "hasModifierProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/augment/PsiAugmentProvider", "hasModifierProperty"));
        }
        return null;
    }

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(final @NotNull PsiElement element, final @NotNull Class<Psi> type) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        final List result = ContainerUtil.newSmartList();
        PsiAugmentProvider.forEach(element.getProject(), new Processor<PsiAugmentProvider>(){

            public boolean process(PsiAugmentProvider provider) {
                result.addAll(provider.getAugments(element, type));
                return true;
            }
        });
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        return list;
    }

    @Nullable
    public static PsiType getInferredType(final @NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/psi/augment/PsiAugmentProvider", "getInferredType"));
        }
        final Ref result = Ref.create();
        PsiAugmentProvider.forEach(typeElement.getProject(), new Processor<PsiAugmentProvider>(){

            public boolean process(PsiAugmentProvider provider) {
                PsiType type = provider.inferType(typeElement);
                if (type != null) {
                    result.set((Object)type);
                    return false;
                }
                return true;
            }
        });
        return (PsiType)result.get();
    }

    @Nullable
    public static Boolean checkModifierProperty(final @NotNull PsiModifierList modifierList, final @NotNull String name) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "com/intellij/psi/augment/PsiAugmentProvider", "checkModifierProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/augment/PsiAugmentProvider", "checkModifierProperty"));
        }
        final Ref result = Ref.create();
        PsiAugmentProvider.forEach(modifierList.getProject(), new Processor<PsiAugmentProvider>(){

            public boolean process(PsiAugmentProvider provider) {
                Boolean property = provider.hasModifierProperty(modifierList, name);
                if (property != null) {
                    result.set((Object)property);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)result.get();
    }

    private static void forEach(Project project, Processor<PsiAugmentProvider> processor) {
        boolean dumb = DumbService.isDumb(project);
        for (PsiAugmentProvider provider : (PsiAugmentProvider[])Extensions.getExtensions(EP_NAME)) {
            if (dumb && !DumbService.isDumbAware(provider)) continue;
            try {
                boolean goOn = processor.process((Object)provider);
                if (goOn) continue;
                break;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(PsiAugmentProvider.class).error("provider: " + provider, (Throwable)e);
            }
        }
    }
}

