/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UsageInfoToUsageConverter {
    private UsageInfoToUsageConverter() {
    }

    @NotNull
    public static Usage convert(@NotNull TargetElementsDescriptor descriptor, @NotNull UsageInfo usageInfo) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        PsiElement[] primaryElements = descriptor.getPrimaryElements();
        Usage usage = UsageInfoToUsageConverter.convert(primaryElements, usageInfo);
        if (usage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        return usage;
    }

    @NotNull
    public static Usage convert(@NotNull PsiElement[] primaryElements, @NotNull UsageInfo usageInfo) {
        if (primaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        PsiElement usageElement = usageInfo.getElement();
        if (usageElement != null && primaryElements.length != 0) {
            for (ReadWriteAccessDetector detector : (ReadWriteAccessDetector[])Extensions.getExtensions(ReadWriteAccessDetector.EP_NAME)) {
                if (!UsageInfoToUsageConverter.isReadWriteAccessibleElements(primaryElements, detector)) continue;
                ReadWriteAccessDetector.Access rwAccess = detector.getExpressionAccess(usageElement);
                ReadWriteAccessUsageInfo2UsageAdapter readWriteAccessUsageInfo2UsageAdapter = new ReadWriteAccessUsageInfo2UsageAdapter(usageInfo, rwAccess != ReadWriteAccessDetector.Access.Write, rwAccess != ReadWriteAccessDetector.Access.Read);
                if (readWriteAccessUsageInfo2UsageAdapter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
                }
                return readWriteAccessUsageInfo2UsageAdapter;
            }
        }
        UsageInfo2UsageAdapter usageInfo2UsageAdapter = new UsageInfo2UsageAdapter(usageInfo);
        if (usageInfo2UsageAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        return usageInfo2UsageAdapter;
    }

    @NotNull
    public static Usage[] convert(@NotNull TargetElementsDescriptor descriptor, @NotNull UsageInfo[] usageInfos) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        Usage[] usages = new Usage[usageInfos.length];
        for (int i = 0; i < usages.length; ++i) {
            usages[i] = UsageInfoToUsageConverter.convert(descriptor, usageInfos[i]);
        }
        if (usages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        return usages;
    }

    @NotNull
    public static Usage[] convert(@NotNull PsiElement[] primaryElements, @NotNull UsageInfo[] usageInfos) {
        if (primaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        Usage[] usageArray = (Usage[])ContainerUtil.map((Object[])usageInfos, info -> {
            if (primaryElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/usages/UsageInfoToUsageConverter", "lambda$convert$0"));
            }
            return UsageInfoToUsageConverter.convert(primaryElements, info);
        }, (Object[])new Usage[usageInfos.length]);
        if (usageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter", "convert"));
        }
        return usageArray;
    }

    private static boolean isReadWriteAccessibleElements(@NotNull PsiElement[] elements, @NotNull ReadWriteAccessDetector detector) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/usages/UsageInfoToUsageConverter", "isReadWriteAccessibleElements"));
        }
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/intellij/usages/UsageInfoToUsageConverter", "isReadWriteAccessibleElements"));
        }
        for (PsiElement element : elements) {
            if (detector.isReadWriteAccessible(element)) continue;
            return false;
        }
        return true;
    }

    public static class TargetElementsDescriptor {
        private final List<SmartPsiElementPointer<PsiElement>> myPrimarySearchedElements;
        private final List<SmartPsiElementPointer<PsiElement>> myAdditionalSearchedElements;

        public TargetElementsDescriptor(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "<init>"));
            }
            this(new PsiElement[]{element});
        }

        public TargetElementsDescriptor(@NotNull PsiElement[] primarySearchedElements) {
            if (primarySearchedElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primarySearchedElements", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "<init>"));
            }
            this(primarySearchedElements, PsiElement.EMPTY_ARRAY);
        }

        public TargetElementsDescriptor(@NotNull PsiElement[] primarySearchedElements, @NotNull PsiElement[] additionalSearchedElements) {
            if (primarySearchedElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primarySearchedElements", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "<init>"));
            }
            if (additionalSearchedElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalSearchedElements", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "<init>"));
            }
            this.myPrimarySearchedElements = TargetElementsDescriptor.convertToSmartPointers(primarySearchedElements);
            this.myAdditionalSearchedElements = TargetElementsDescriptor.convertToSmartPointers(additionalSearchedElements);
        }

        @NotNull
        private static PsiElement[] convertToPsiElements(@NotNull List<SmartPsiElementPointer<PsiElement>> primary) {
            if (primary == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primary", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "convertToPsiElements"));
            }
            PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.toArray((Collection)ContainerUtil.mapNotNull(primary, SmartPsiElementPointer::getElement), PsiElement.ARRAY_FACTORY);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "convertToPsiElements"));
            }
            return psiElementArray;
        }

        @NotNull
        private static List<SmartPsiElementPointer<PsiElement>> convertToSmartPointers(@NotNull PsiElement[] primaryElements) {
            if (primaryElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "convertToSmartPointers"));
            }
            if (primaryElements.length == 0) {
                List<SmartPsiElementPointer<PsiElement>> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "convertToSmartPointers"));
                }
                return list;
            }
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(primaryElements[0].getProject());
            List list = ContainerUtil.mapNotNull((Object[])primaryElements, smartPointerManager::createSmartPsiElementPointer);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "convertToSmartPointers"));
            }
            return list;
        }

        @NotNull
        public PsiElement[] getPrimaryElements() {
            PsiElement[] psiElementArray = TargetElementsDescriptor.convertToPsiElements(this.myPrimarySearchedElements);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "getPrimaryElements"));
            }
            return psiElementArray;
        }

        @NotNull
        public PsiElement[] getAdditionalElements() {
            PsiElement[] psiElementArray = TargetElementsDescriptor.convertToPsiElements(this.myAdditionalSearchedElements);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "getAdditionalElements"));
            }
            return psiElementArray;
        }

        @NotNull
        public List<PsiElement> getAllElements() {
            PsiElement element;
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(this.myPrimarySearchedElements.size() + this.myAdditionalSearchedElements.size());
            for (SmartPsiElementPointer<PsiElement> pointer : this.myPrimarySearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            for (SmartPsiElementPointer<PsiElement> pointer : this.myAdditionalSearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            ArrayList<PsiElement> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "getAllElements"));
            }
            return arrayList;
        }

        @NotNull
        public List<SmartPsiElementPointer<PsiElement>> getAllElementPointers() {
            List list = ContainerUtil.concat(this.myPrimarySearchedElements, this.myAdditionalSearchedElements);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor", "getAllElementPointers"));
            }
            return list;
        }
    }
}

