/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.DocumentsEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.UndoHelper;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerspectiveFileEditor
extends UserDataHolderBase
implements DocumentsEditor,
Committable {
    private final Wrapper myWrapper = new Wrapper();
    private boolean myInitialised = false;
    private boolean myInitializing;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private final Project myProject;
    private final VirtualFile myFile;
    private final UndoHelper myUndoHelper;
    private boolean myInvalidated;

    protected PerspectiveFileEditor(Project project, VirtualFile file) {
        Document document;
        this.myProject = project;
        this.myUndoHelper = new UndoHelper(project, this);
        this.myFile = file;
        FileEditorManager.getInstance(this.myProject).addFileEditorManagerListener(new FileEditorManagerAdapter(){

            @Override
            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/xml/ui/PerspectiveFileEditor$1", "selectionChanged"));
                }
                if (!PerspectiveFileEditor.this.isValid()) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PerspectiveFileEditor.this.myUndoHelper.isShowing() && !PerspectiveFileEditor.this.getComponent().isShowing()) {
                            PerspectiveFileEditor.this.deselectNotify();
                        } else if (!PerspectiveFileEditor.this.myUndoHelper.isShowing() && PerspectiveFileEditor.this.getComponent().isShowing()) {
                            PerspectiveFileEditor.this.selectNotify();
                        }
                    }
                });
                FileEditor oldEditor = event.getOldEditor();
                FileEditor newEditor = event.getNewEditor();
                if (oldEditor == null || newEditor == null) {
                    return;
                }
                if (oldEditor.getComponent().isShowing() && newEditor.getComponent().isShowing()) {
                    return;
                }
                if (PerspectiveFileEditor.this.equals(oldEditor)) {
                    if (newEditor instanceof TextEditor) {
                        PerspectiveFileEditor.this.ensureInitialized();
                        DomElement selectedDomElement = PerspectiveFileEditor.this.getSelectedDomElement();
                        if (selectedDomElement != null) {
                            PerspectiveFileEditor.this.setSelectionInTextEditor((TextEditor)newEditor, selectedDomElement);
                        }
                    }
                } else if (PerspectiveFileEditor.this.equals(newEditor)) {
                    if (oldEditor instanceof TextEditor) {
                        DomElement element = PerspectiveFileEditor.this.getSelectedDomElementFromTextEditor((TextEditor)oldEditor);
                        if (element != null) {
                            PerspectiveFileEditor.this.ensureInitialized();
                            PerspectiveFileEditor.this.setSelectedDomElement(element);
                        }
                    } else if (oldEditor instanceof PerspectiveFileEditor) {
                        PerspectiveFileEditor.this.ensureInitialized();
                        DomElement selectedDomElement = ((PerspectiveFileEditor)oldEditor).getSelectedDomElement();
                        if (selectedDomElement != null) {
                            PerspectiveFileEditor.this.setSelectedDomElement(selectedDomElement);
                        }
                    }
                }
            }
        }, this);
        this.myUndoHelper.startListeningDocuments();
        PsiFile psiFile = this.getPsiFile();
        if (psiFile != null && (document = PsiDocumentManager.getInstance(this.getProject()).getDocument(psiFile)) != null) {
            this.addWatchedDocument(document);
        }
    }

    @Nullable
    protected abstract DomElement getSelectedDomElement();

    protected abstract void setSelectedDomElement(DomElement var1);

    public final void addWatchedElement(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/util/xml/ui/PerspectiveFileEditor", "addWatchedElement"));
        }
        this.addWatchedDocument(this.getDocumentManager().getDocument(DomUtil.getFile(domElement)));
    }

    public final void removeWatchedElement(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/util/xml/ui/PerspectiveFileEditor", "removeWatchedElement"));
        }
        this.removeWatchedDocument(this.getDocumentManager().getDocument(DomUtil.getFile(domElement)));
    }

    public final void addWatchedDocument(Document document) {
        this.myUndoHelper.addWatchedDocument(document);
    }

    public final void removeWatchedDocument(Document document) {
        this.myUndoHelper.removeWatchedDocument(document);
    }

    @Nullable
    protected DomElement getSelectedDomElementFromTextEditor(TextEditor textEditor) {
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        PsiElement psiElement = psiFile.findElementAt(textEditor.getEditor().getCaretModel().getOffset());
        if (psiElement == null) {
            return null;
        }
        XmlTag xmlTag = PsiTreeUtil.getParentOfType(psiElement, XmlTag.class);
        return DomManager.getDomManager(this.myProject).getDomElement(xmlTag);
    }

    public void setSelectionInTextEditor(TextEditor textEditor, DomElement element) {
        if (element != null && element.isValid()) {
            XmlTag tag = element.getXmlTag();
            if (tag == null) {
                return;
            }
            PsiFile file = tag.getContainingFile();
            if (file == null) {
                return;
            }
            Document document = this.getDocumentManager().getDocument(file);
            if (document == null || !document.equals(textEditor.getEditor().getDocument())) {
                return;
            }
            textEditor.getEditor().getCaretModel().moveToOffset(tag.getTextOffset());
            textEditor.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    protected final PsiDocumentManager getDocumentManager() {
        return PsiDocumentManager.getInstance(this.myProject);
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return PsiManager.getInstance(this.myProject).findFile(this.myFile);
    }

    @Override
    public final Document[] getDocuments() {
        return this.myUndoHelper.getDocuments();
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final VirtualFile getVirtualFile() {
        return this.myFile;
    }

    public void dispose() {
        if (this.myInvalidated) {
            return;
        }
        this.myInvalidated = true;
        this.myUndoHelper.stopListeningDocuments();
    }

    @Override
    public final boolean isModified() {
        return FileDocumentManager.getInstance().isFileModified(this.getVirtualFile());
    }

    @Override
    public boolean isValid() {
        return this.getVirtualFile().isValid();
    }

    @Override
    public void selectNotify() {
        if (!this.checkIsValid() || this.myInvalidated) {
            return;
        }
        this.ensureInitialized();
        this.setShowing(true);
        if (this.myInitialised) {
            this.reset();
        }
    }

    protected final void setShowing(boolean b) {
        this.myUndoHelper.setShowing(b);
    }

    protected final synchronized void ensureInitialized() {
        if (!this.isInitialised() && !this.myInitializing) {
            this.myInitializing = true;
            JComponent component = this.createCustomComponent();
            this.myWrapper.setContent(component);
            this.myInitialised = true;
        }
    }

    @Override
    public void deselectNotify() {
        if (!this.checkIsValid() || this.myInvalidated) {
            return;
        }
        this.setShowing(false);
        this.commit();
    }

    @Override
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Override
    public FileEditorLocation getCurrentLocation() {
        return new FileEditorLocation(){

            @Override
            @NotNull
            public FileEditor getEditor() {
                PerspectiveFileEditor perspectiveFileEditor = PerspectiveFileEditor.this;
                if (perspectiveFileEditor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/PerspectiveFileEditor$2", "getEditor"));
                }
                return perspectiveFileEditor;
            }

            @Override
            public int compareTo(@NotNull FileEditorLocation fileEditorLocation) {
                if (fileEditorLocation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorLocation", "com/intellij/util/xml/ui/PerspectiveFileEditor$2", "compareTo"));
                }
                return 0;
            }
        };
    }

    @Override
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/util/xml/ui/PerspectiveFileEditor", "setState"));
        }
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/xml/ui/PerspectiveFileEditor", "addPropertyChangeListener"));
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/xml/ui/PerspectiveFileEditor", "removePropertyChangeListener"));
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected boolean checkIsValid() {
        if (!this.myInvalidated && !this.isValid()) {
            this.myInvalidated = true;
            this.myPropertyChangeSupport.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
        return !this.myInvalidated;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        Wrapper wrapper = this.getWrapper();
        if (wrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/PerspectiveFileEditor", "getComponent"));
        }
        return wrapper;
    }

    @NotNull
    protected abstract JComponent createCustomComponent();

    public Wrapper getWrapper() {
        return this.myWrapper;
    }

    protected final synchronized boolean isInitialised() {
        return this.myInitialised;
    }
}

