/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class XDebugProcess {
    private final XDebugSession mySession;
    private ProcessHandler myProcessHandler;

    protected XDebugProcess(@NotNull XDebugSession session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/XDebugProcess", "<init>"));
        }
        this.mySession = session;
    }

    public final XDebugSession getSession() {
        return this.mySession;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (XBreakpointHandler.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/XDebugProcess", "getBreakpointHandlers"));
        }
        return XBreakpointHandler.EMPTY_ARRAY;
    }

    @NotNull
    public abstract XDebuggerEditorsProvider getEditorsProvider();

    public void sessionInitialized() {
    }

    public void startPausing() {
    }

    @Deprecated
    public void startStepOver() {
        throw new AbstractMethodError();
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.startStepOver();
    }

    @Deprecated
    public void startForceStepInto() {
        this.startStepInto();
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.startForceStepInto();
    }

    @Deprecated
    public void startStepInto() {
        throw new AbstractMethodError();
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.startStepInto();
    }

    @Deprecated
    public void startStepOut() {
        throw new AbstractMethodError();
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.startStepOut();
    }

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return null;
    }

    public void stop() {
        throw new AbstractMethodError();
    }

    @NotNull
    public Promise stopAsync() {
        this.stop();
        Promise<Void> promise = Promise.DONE;
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/XDebugProcess", "stopAsync"));
        }
        return promise;
    }

    @Deprecated
    public void resume() {
        throw new AbstractMethodError();
    }

    public void resume(@Nullable XSuspendContext context) {
        this.resume();
    }

    @Deprecated
    public void runToPosition(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/XDebugProcess", "runToPosition"));
        }
        throw new AbstractMethodError();
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/XDebugProcess", "runToPosition"));
        }
        this.runToPosition(position);
    }

    public boolean checkCanPerformCommands() {
        return true;
    }

    public boolean checkCanInitBreakpoints() {
        return true;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return null;
    }

    @NotNull
    public final ProcessHandler getProcessHandler() {
        if (this.myProcessHandler == null) {
            this.myProcessHandler = this.doGetProcessHandler();
            if (this.myProcessHandler == null) {
                this.myProcessHandler = new DefaultDebugProcessHandler();
            }
        }
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/XDebugProcess", "getProcessHandler"));
        }
        return processHandler;
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(this.getSession().getProject()).getConsole();
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/XDebugProcess", "createConsole"));
        }
        return consoleView;
    }

    @Nullable
    public XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return null;
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftToolbar", "com/intellij/xdebugger/XDebugProcess", "registerAdditionalActions"));
        }
        if (topToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topToolbar", "com/intellij/xdebugger/XDebugProcess", "registerAdditionalActions"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xdebugger/XDebugProcess", "registerAdditionalActions"));
        }
    }

    public String getCurrentStateMessage() {
        return this.mySession.isStopped() ? XDebuggerBundle.message("debugger.state.message.disconnected", new Object[0]) : XDebuggerBundle.message("debugger.state.message.connected", new Object[0]);
    }

    @Nullable
    public HyperlinkListener getCurrentStateHyperlinkListener() {
        return null;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        XDebugTabLayouter xDebugTabLayouter = new XDebugTabLayouter(){};
        if (xDebugTabLayouter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/XDebugProcess", "createTabLayouter"));
        }
        return xDebugTabLayouter;
    }

    public boolean isValuesCustomSorted() {
        return false;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame == null ? null : frame.getEvaluator();
    }

    public boolean isLibraryFrameFilterSupported() {
        return false;
    }
}

