/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.commons.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.Preconditions;

@API(value=API.Usage.Internal)
public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static RuntimeException throwAsUncheckedException(Throwable t) {
        Preconditions.notNull(t, "Throwable must not be null");
        ExceptionUtils.throwAs(t);
        return null;
    }

    private static <T extends Throwable> void throwAs(Throwable t) throws T {
        throw t;
    }

    public static String readStackTrace(Throwable throwable) {
        Preconditions.notNull(throwable, "Throwable must not be null");
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }
}

