/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine;

import java.util.Optional;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.Preconditions;
import org.junit.gen5.commons.util.ToStringBuilder;

@API(value=API.Usage.Experimental)
public class TestExecutionResult {
    private static final TestExecutionResult SUCCESSFUL_RESULT = new TestExecutionResult(Status.SUCCESSFUL, null);
    private final Status status;
    private final Throwable throwable;

    public static TestExecutionResult successful() {
        return SUCCESSFUL_RESULT;
    }

    public static TestExecutionResult aborted(Throwable throwable) {
        return new TestExecutionResult(Status.ABORTED, throwable);
    }

    public static TestExecutionResult failed(Throwable throwable) {
        return new TestExecutionResult(Status.FAILED, throwable);
    }

    public TestExecutionResult(Status status, Throwable throwable) {
        this.status = (Status)((Object)Preconditions.notNull((Object)((Object)status), (String)"Status must not be null"));
        this.throwable = throwable;
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("status", (Object)this.status);
        builder.append("throwable", (Object)this.throwable);
        return builder.toString();
    }

    public static enum Status {
        SUCCESSFUL,
        ABORTED,
        FAILED;

    }
}

