/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher.listeners;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.launcher.TestIdentifier;
import org.junit.gen5.launcher.TestPlan;

@API(value=API.Usage.Experimental)
public class TestExecutionSummary {
    final AtomicLong testsStarted = new AtomicLong();
    final AtomicLong testsFound = new AtomicLong();
    final AtomicLong testsSkipped = new AtomicLong();
    final AtomicLong testsAborted = new AtomicLong();
    final AtomicLong testsSucceeded = new AtomicLong();
    final AtomicLong testsFailed = new AtomicLong();
    long timeStarted;
    long timeFinished;
    private final TestPlan testPlan;
    private String message;
    private List<Failure> failures = new ArrayList<Failure>();

    public TestExecutionSummary(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    void finishTestRun(String message) {
        this.timeFinished = System.currentTimeMillis();
        this.message = message;
    }

    public void printOn(PrintWriter writer) {
        writer.println(String.format("%n%s after %d ms\n[%10d tests found     ]\n[%10d tests skipped   ]\n[%10d tests started   ]\n[%10d tests aborted   ]\n[%10d tests successful]\n[%10d tests failed    ]\n", this.message, this.timeFinished - this.timeStarted, this.testsFound.get(), this.testsSkipped.get(), this.testsStarted.get(), this.testsAborted.get(), this.testsSucceeded.get(), this.testsFailed.get()));
        writer.flush();
    }

    public void printFailuresOn(PrintWriter writer) {
        if (this.countFailedTests() > 0L) {
            writer.println();
            writer.println(String.format("Test failures (%d):", this.testsFailed.get()));
            this.failures.stream().forEach(failure -> {
                writer.println(String.format("  %s", this.describeTest(failure.getTestIdentifier())));
                failure.getTestIdentifier().getSource().ifPresent(scource -> writer.println(String.format("    %s", scource.toString())));
                writer.println(String.format("    => Exception: %s", failure.getException().getLocalizedMessage()));
            });
        }
        writer.flush();
    }

    private String describeTest(TestIdentifier testIdentifier) {
        ArrayList<String> descriptionParts = new ArrayList<String>();
        this.collectTestDescription(Optional.of(testIdentifier), descriptionParts);
        return descriptionParts.stream().collect(Collectors.joining(":"));
    }

    private void collectTestDescription(Optional<TestIdentifier> optionalIdentifier, List<String> descriptionParts) {
        optionalIdentifier.ifPresent(testIdentifier -> {
            descriptionParts.add(0, testIdentifier.getDisplayName());
            this.collectTestDescription(this.testPlan.getParent((TestIdentifier)testIdentifier), descriptionParts);
        });
    }

    public long countFailedTests() {
        return this.testsFailed.get();
    }

    public void addFailure(TestIdentifier testIdentifier, Throwable throwable) {
        this.failures.add(new Failure(testIdentifier, throwable));
    }

    static class Failure {
        private final TestIdentifier testIdentifier;
        private final Throwable exception;

        public Failure(TestIdentifier testIdentifier, Throwable exception) {
            this.testIdentifier = testIdentifier;
            this.exception = exception;
        }

        public TestIdentifier getTestIdentifier() {
            return this.testIdentifier;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

