/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ShutDownTracker
implements Runnable {
    private final List<Thread> myThreads = new ArrayList<Thread>();
    private final LinkedList<Thread> myShutdownThreads = new LinkedList();
    private final LinkedList<Runnable> myShutdownTasks = new LinkedList();
    private final Thread myThread = new Thread((Runnable)this, "Shutdown tracker");

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(this.myThread);
    }

    @NotNull
    public static ShutDownTracker getInstance() {
        ShutDownTracker shutDownTracker = ShutDownTrackerHolder.ourInstance;
        if (shutDownTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ShutDownTracker", "getInstance"));
        }
        return shutDownTracker;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myThread.isAlive();
    }

    @Override
    public void run() {
        this.ensureStopperThreadsFinished();
        Runnable task = this.removeLast(this.myShutdownTasks);
        while (task != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                Logger.getInstance(ShutDownTracker.class).error(e);
            }
            task = this.removeLast(this.myShutdownTasks);
        }
        Thread thread = this.removeLast(this.myShutdownThreads);
        while (thread != null) {
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            thread = this.removeLast(this.myShutdownThreads);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean waitFor(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/openapi/util/ShutDownTracker", "waitFor"));
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            try {
                void unit;
                this.myThread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myThread.isAlive();
        }
        return false;
    }

    public final void ensureStopperThreadsFinished() {
        Thread[] threads = this.getStopperThreads();
        long started = System.currentTimeMillis();
        while (threads.length > 0) {
            Thread thread = threads[0];
            if (!thread.isAlive()) {
                if (this.isRegistered(thread)) {
                    Logger.getInstance(ShutDownTracker.class).error("Thread '" + thread.getName() + "' did not unregister itself from ShutDownTracker.");
                    this.unregisterStopperThread(thread);
                }
            } else {
                long totalTimeWaited = System.currentTimeMillis() - started;
                if (totalTimeWaited > 3000L) {
                    thread.interrupt();
                }
                try {
                    thread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
    }

    private synchronized boolean isRegistered(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/util/ShutDownTracker", "isRegistered"));
        }
        return this.myThreads.contains(thread);
    }

    @NotNull
    private synchronized Thread[] getStopperThreads() {
        Thread[] threadArray = this.myThreads.toArray(new Thread[this.myThreads.size()]);
        if (threadArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ShutDownTracker", "getStopperThreads"));
        }
        return threadArray;
    }

    public synchronized void registerStopperThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/util/ShutDownTracker", "registerStopperThread"));
        }
        this.myThreads.add(thread);
    }

    public synchronized void unregisterStopperThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/util/ShutDownTracker", "unregisterStopperThread"));
        }
        this.myThreads.remove(thread);
    }

    public synchronized void registerShutdownThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/util/ShutDownTracker", "registerShutdownThread"));
        }
        this.myShutdownThreads.addLast(thread);
    }

    public synchronized void registerShutdownThread(int index, @NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/util/ShutDownTracker", "registerShutdownThread"));
        }
        this.myShutdownThreads.add(index, thread);
    }

    public synchronized void registerShutdownTask(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/util/ShutDownTracker", "registerShutdownTask"));
        }
        this.myShutdownTasks.addLast(task);
    }

    public synchronized void unregisterShutdownTask(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/util/ShutDownTracker", "unregisterShutdownTask"));
        }
        this.myShutdownTasks.remove(task);
    }

    private synchronized <T> T removeLast(@NotNull LinkedList<T> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/util/ShutDownTracker", "removeLast"));
        }
        return list.isEmpty() ? null : (T)list.removeLast();
    }

    public static void invokeAndWait(boolean returnOnTimeout, boolean runInEdt, final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/ShutDownTracker", "invokeAndWait"));
        }
        if (!runInEdt) {
            if (returnOnTimeout) {
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                        semaphore.up();
                    }
                }, "shutdown tracker invoker").start();
                semaphore.waitFor(1000L);
            } else {
                runnable.run();
            }
            return;
        }
        if (returnOnTimeout) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    semaphore.up();
                }
            });
            semaphore.waitFor(1000L);
            return;
        }
        try {
            UIUtil.invokeAndWaitIfNeeded(runnable);
        }
        catch (Exception e) {
            Logger.getInstance(ShutDownTracker.class).error(e);
        }
    }

    private static class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();

        private ShutDownTrackerHolder() {
        }
    }
}

