/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.reference;

import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.reference.ReferencesUpdater;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UpdateReferencesJob
extends Job {
    private final Job subJob;
    private final List<Job> fixJobs = new ArrayList<Job>();

    public UpdateReferencesJob(Job subJob) {
        super(subJob.getEditorController());
        this.subJob = subJob;
    }

    public Job getSubJob() {
        return this.subJob;
    }

    public List<Job> getFixJobs() {
        return Collections.unmodifiableList(this.fixJobs);
    }

    @Override
    public boolean isExecutable() {
        return this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.execute();
        ReferencesUpdater updater = new ReferencesUpdater(this.getEditorController());
        updater.update();
        this.fixJobs.addAll(updater.getExecutedJobs());
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (int i = this.fixJobs.size() - 1; i >= 0; --i) {
            this.fixJobs.get(i).undo();
        }
        this.subJob.undo();
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.redo();
        for (Job fixJob : this.fixJobs) {
            fixJob.redo();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        return this.subJob.getDescription();
    }
}

