/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlNamedElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.ImportReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxColorReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxComponentIdReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxEventHandlerReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFactoryReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFieldIdReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxLocationReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxSourceReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxStaticPropertyReferenceProvider;

public class FxmlReferencesContributor
extends PsiReferenceContributor {
    public static final JavaClassReferenceProvider CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider();

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/plugins/javaFX/fxml/refs/FxmlReferencesContributor", "registerReferenceProviders"));
        }
        XmlAttributeValuePattern attributeValueInFxml = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().withExtension("fxml"));
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute().withName("fx:controller"))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)CLASS_REFERENCE_PROVIDER);
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withName("type")).withParent((ElementPattern)XmlPatterns.xmlTag().withName("fx:root")))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new MyJavaClassReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlTag().inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().withExtension("fxml")), (PsiReferenceProvider)new MyJavaClassReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute().withName("fx:id"))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxFieldIdReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withName("source")).withParent((ElementPattern)XmlPatterns.xmlTag().withName("fx:include")))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxSourceReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withName("source")).withParent((ElementPattern)XmlPatterns.xmlTag().withName("fx:script")))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxSourceReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withName("source")).withParent((ElementPattern)XmlPatterns.xmlTag().withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"fx:reference", "fx:copy"}))))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxComponentIdReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute().withName("fx:factory"))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxFactoryReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withValue(StandardPatterns.string().startsWith("#")).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxEventHandlerReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withValue(StandardPatterns.string().startsWith("@")).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxLocationReferenceProvider(), -100.0);
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withValue(StandardPatterns.string().startsWith("$")).withParent((ElementPattern)XmlPatterns.xmlAttribute().andNot((ElementPattern)XmlPatterns.xmlAttribute().withName("fx:value")))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxComponentIdReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute().withName("url"))).andNot((ElementPattern)XmlPatterns.xmlAttributeValue().withValue(StandardPatterns.string().matches("^https?://.*")))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxLocationReferenceProvider(false, "png", "jpg", "gif", "bmp"));
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute().withName("stylesheets"))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxLocationReferenceProvider(true, "css"));
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withValue(StandardPatterns.string().startsWith("@")).withParent((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withName("value")).withParent((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName("URL")).withParent((ElementPattern)XmlPatterns.xmlTag().withName("stylesheets"))))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxLocationReferenceProvider(false, "css"));
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(XmlProcessingInstruction.class).inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().withExtension("fxml")), (PsiReferenceProvider)new ImportReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxColorReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withName("fx:value")).withParent((ElementPattern)XmlPatterns.xmlTag().withParent((ElementPattern)XmlPatterns.xmlTag().withName("stylesheets"))))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxLocationReferenceProvider(true, "css"));
        registrar.registerReferenceProvider((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withLocalName((ElementPattern)StandardPatterns.string().contains("."))).inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().withExtension("fxml")), (PsiReferenceProvider)new JavaFxStaticPropertyReferenceProvider());
    }

    private static class MyJavaClassReferenceProvider
    extends JavaClassReferenceProvider {
        private MyJavaClassReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/FxmlReferencesContributor$MyJavaClassReferenceProvider", "getReferencesByElement"));
            }
            String name = element instanceof XmlAttributeValue ? ((XmlAttributeValue)element).getValue() : ((XmlTag)element).getName();
            PsiReference[] psiReferenceArray = this.getReferencesByString(name, element, 1);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/FxmlReferencesContributor$MyJavaClassReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }

        @NotNull
        public PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
            int offset;
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/javaFX/fxml/refs/FxmlReferencesContributor$MyJavaClassReferenceProvider", "getReferencesByString"));
            }
            if (str.length() == 0) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/FxmlReferencesContributor$MyJavaClassReferenceProvider", "getReferencesByString"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            PsiReference[] references = super.getReferencesByString(str, position, offsetInPosition);
            int n = offset = position instanceof XmlTag ? 1 : 0;
            if (references.length <= offset) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/FxmlReferencesContributor$MyJavaClassReferenceProvider", "getReferencesByString"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            PsiReference[] results = new PsiReference[references.length - offset];
            for (int i = 0; i < results.length; ++i) {
                results[i] = new JavaClassReferenceWrapper(references[i], position);
            }
            if (results == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/FxmlReferencesContributor$MyJavaClassReferenceProvider", "getReferencesByString"));
            }
            return results;
        }

        private static class JavaClassReferenceWrapper
        implements PsiReference {
            private final PsiReference myReference;
            private final PsiElement myPosition;

            public JavaClassReferenceWrapper(PsiReference reference, PsiElement position) {
                this.myReference = reference;
                this.myPosition = position;
            }

            public PsiElement getElement() {
                return this.myReference.getElement();
            }

            public TextRange getRangeInElement() {
                return this.myReference.getRangeInElement();
            }

            @Nullable
            public PsiElement resolve() {
                PsiElement resolve = this.myReference.resolve();
                if (resolve != null) {
                    return resolve;
                }
                return this.getReferencedClass();
            }

            private PsiElement getReferencedClass() {
                if (this.myPosition instanceof XmlTag) {
                    PsiClass containingClass;
                    PsiElement declaration;
                    XmlElementDescriptor descriptor = ((XmlTag)this.myPosition).getDescriptor();
                    if (descriptor != null && (declaration = descriptor.getDeclaration()) instanceof PsiMethod && ((PsiMethod)declaration).hasModifierProperty("static") && (containingClass = ((PsiMethod)declaration).getContainingClass()) != null && this.myReference.getCanonicalText().equals(containingClass.getName())) {
                        return containingClass;
                    }
                } else if (this.myPosition instanceof XmlAttributeValue) {
                    return JavaFxPsiUtil.findPsiClass(((XmlAttributeValue)this.myPosition).getValue(), this.myPosition);
                }
                return null;
            }

            @NotNull
            public String getCanonicalText() {
                String string = this.myReference.getCanonicalText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/FxmlReferencesContributor$MyJavaClassReferenceProvider$JavaClassReferenceWrapper", "getCanonicalText"));
                }
                return string;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                String oldText = this.getOldName();
                TextRange range = this.getRangeInElement();
                String newText = oldText.substring(0, range.getStartOffset() - 1) + newElementName + oldText.substring(range.getEndOffset() - 1);
                return this.setNewName(newText);
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/FxmlReferencesContributor$MyJavaClassReferenceProvider$JavaClassReferenceWrapper", "bindToElement"));
                }
                String oldText = this.getOldName();
                TextRange range = this.getRangeInElement();
                String newText = (element instanceof PsiPackage ? ((PsiPackage)element).getQualifiedName() : ((PsiClass)element).getName()) + oldText.substring(range.getEndOffset() - 1);
                return this.setNewName(newText);
            }

            private PsiElement setNewName(String newText) {
                if (this.myPosition instanceof XmlTag) {
                    return ((XmlTag)this.myPosition).setName(newText);
                }
                XmlElementFactory xmlElementFactory = XmlElementFactory.getInstance((Project)this.myPosition.getProject());
                XmlAttribute xmlAttribute = xmlElementFactory.createXmlAttribute("attributeName", newText);
                XmlAttributeValue valueElement = xmlAttribute.getValueElement();
                assert (valueElement != null);
                return this.myPosition.replace((PsiElement)valueElement);
            }

            private String getOldName() {
                return this.myPosition instanceof XmlTag ? ((XmlTag)this.myPosition).getName() : ((XmlAttributeValue)this.myPosition).getValue();
            }

            public boolean isReferenceTo(PsiElement element) {
                return this.myReference.isReferenceTo(element) || this.getReferencedClass() == element;
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = this.myReference.getVariants();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/FxmlReferencesContributor$MyJavaClassReferenceProvider$JavaClassReferenceWrapper", "getVariants"));
                }
                return objectArray;
            }

            public boolean isSoft() {
                return true;
            }
        }
    }
}

