/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public abstract class JavaFxPropertyReference<T extends PsiElement>
extends PsiReferenceBase<T> {
    protected final PsiClass myPsiClass;

    public JavaFxPropertyReference(@NotNull T element, PsiClass aClass, boolean soft) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxPropertyReference", "<init>"));
        }
        super(element, soft);
        this.myPsiClass = aClass;
    }

    public JavaFxPropertyReference(@NotNull T element, PsiClass aClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxPropertyReference", "<init>"));
        }
        super(element);
        this.myPsiClass = aClass;
    }

    @Nullable
    public PsiMethod getGetter() {
        if (this.myPsiClass == null) {
            return null;
        }
        return JavaFxPsiUtil.findPropertyGetter(this.myPsiClass, this.getPropertyName());
    }

    @Nullable
    public PsiMethod getSetter() {
        if (this.myPsiClass == null) {
            return null;
        }
        return JavaFxPsiUtil.findInstancePropertySetter(this.myPsiClass, this.getPropertyName());
    }

    @Nullable
    public PsiField getField() {
        if (this.myPsiClass == null) {
            return null;
        }
        return this.myPsiClass.findFieldByName(this.getPropertyName(), true);
    }

    @Nullable
    public PsiMethod getObservableGetter() {
        if (this.myPsiClass == null) {
            return null;
        }
        return JavaFxPsiUtil.findObservablePropertyGetter(this.myPsiClass, this.getPropertyName());
    }

    @Nullable
    public PsiMethod getStaticSetter() {
        return null;
    }

    @Nullable
    public PsiType getType() {
        return JavaFxPsiUtil.getReadablePropertyType(this.resolve());
    }

    @Nullable
    public abstract String getPropertyName();
}

