/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.sceneBuilder;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.sceneBuilder.EditorCallback;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilder;

public class SceneBuilderEditor
extends UserDataHolderBase
implements FileEditor,
EditorCallback {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderEditor");
    private static final String SCENE_CARD = "scene_builder";
    private static final String ERROR_CARD = "error";
    private final Project myProject;
    private final VirtualFile myFile;
    private final CardLayout myLayout;
    private final JPanel myPanel;
    private final JPanel myErrorPanel;
    private final HyperlinkLabel myErrorLabel;
    private JTextArea myErrorStack;
    private final Document myDocument;
    private final ExternalChangeListener myChangeListener;
    private SceneBuilder mySceneBuilder;

    public SceneBuilderEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor", "<init>"));
        }
        this.myLayout = new CardLayout();
        this.myPanel = new JPanel(this.myLayout);
        this.myErrorPanel = new JPanel(new BorderLayout());
        this.myErrorLabel = new HyperlinkLabel();
        this.myProject = project;
        this.myFile = file;
        this.myDocument = FileDocumentManager.getInstance().getDocument(file);
        this.myChangeListener = new ExternalChangeListener();
        this.createErrorPage();
    }

    private void createErrorPage() {
        this.myErrorLabel.setOpaque(false);
        this.myErrorLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                SceneBuilderEditor.this.updateState();
            }
        });
        this.myErrorStack = new JTextArea(50, 20);
        this.myErrorStack.setEditable(false);
        this.myErrorPanel.add((Component)this.myErrorLabel, "North");
        this.myErrorPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myErrorStack), "Center");
        this.myPanel.add(this.myErrorPanel);
    }

    private void showErrorPage(Throwable e) {
        String description;
        if (e != null) {
            LOG.info(e);
        }
        this.removeSceneBuilder();
        if (e != null) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Throwable t = e; t != null && t != t.getCause(); t = t.getCause()) {
                String message = SceneBuilderEditor.getErrorMessage(t);
                if (messages.isEmpty() || !((String)messages.get(messages.size() - 1)).contains(message)) {
                    messages.add(message);
                    continue;
                }
                messages.set(messages.size() - 1, message);
            }
            Collections.reverse(messages);
            description = "\n" + messages.stream().collect(Collectors.joining("\n\n"));
        } else {
            description = "Unknown error occurred";
        }
        this.myErrorLabel.setHyperlinkText("Failed to open the file in the Scene Builder", "", "");
        this.myErrorLabel.setIcon(Messages.getErrorIcon());
        this.myErrorStack.setText(description);
        this.myErrorStack.setVisible(true);
        this.myLayout.show(this.myPanel, ERROR_CARD);
    }

    private static String getErrorMessage(Throwable e) {
        String message = e.getMessage();
        String className = e.getClass().getName();
        if (StringUtil.isEmpty((String)message)) {
            if (e instanceof ClassNotFoundException) {
                return className + ": Unresolved import";
            }
            return className;
        }
        if (!message.contains(className)) {
            return className + ": " + message;
        }
        return message;
    }

    @Override
    public void saveChanges(final String content) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SceneBuilderEditor.this.mySceneBuilder != null) {
                    if (!SceneBuilderEditor.this.myDocument.isWritable() && ReadonlyStatusHandler.getInstance((Project)SceneBuilderEditor.this.myProject).ensureFilesWritable(new VirtualFile[]{SceneBuilderEditor.this.myFile}).hasReadonlyFiles()) {
                        return;
                    }
                    try {
                        SceneBuilderEditor.this.myChangeListener.setRunState(false);
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                CommandProcessor.getInstance().executeCommand(SceneBuilderEditor.this.myProject, new Runnable(){

                                    @Override
                                    public void run() {
                                        SceneBuilderEditor.this.myDocument.setText((CharSequence)content);
                                    }
                                }, "JavaFX Scene Builder edit operation", null);
                            }
                        });
                    }
                    finally {
                        SceneBuilderEditor.this.myChangeListener.setRunState(true);
                    }
                }
            }
        });
    }

    @Override
    public void handleError(final Throwable e) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                SceneBuilderEditor.this.showErrorPage(e);
            }
        });
    }

    private void updateState() {
        this.addSceneBuilder();
    }

    private void addSceneBuilder() {
        this.removeSceneBuilder();
        try {
            FileDocumentManager.getInstance().saveDocument(this.myDocument);
            this.mySceneBuilder = SceneBuilder.create(new File(this.myFile.getPath()).toURI().toURL(), this.myProject, this);
            this.myPanel.add((Component)this.mySceneBuilder.getPanel(), SCENE_CARD);
            this.myLayout.show(this.myPanel, SCENE_CARD);
            this.myChangeListener.start();
        }
        catch (Throwable e) {
            this.showErrorPage(e);
        }
    }

    private void removeSceneBuilder() {
        this.myChangeListener.stop();
        if (this.mySceneBuilder != null) {
            this.myPanel.remove(this.mySceneBuilder.getPanel());
            this.mySceneBuilder.close();
            this.mySceneBuilder = null;
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySceneBuilder == null ? this.myErrorPanel : this.mySceneBuilder.getPanel();
    }

    public void dispose() {
        this.removeSceneBuilder();
        this.myChangeListener.dispose();
    }

    @NotNull
    public String getName() {
        if ("Scene Builder" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor", "getName"));
        }
        return "Scene Builder";
    }

    public void selectNotify() {
        this.updateState();
    }

    public void deselectNotify() {
        this.myChangeListener.stop();
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor", "setState"));
        }
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public boolean isModified() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    private class ExternalChangeListener
    extends DocumentAdapter {
        private volatile boolean myRunState;

        public ExternalChangeListener() {
            SceneBuilderEditor.this.myDocument.addDocumentListener((DocumentListener)this);
        }

        public void start() {
            if (!this.myRunState) {
                this.myRunState = true;
            }
        }

        public void stop() {
            if (this.myRunState) {
                this.myRunState = false;
            }
        }

        public void setRunState(boolean state) {
            this.myRunState = state;
        }

        public void dispose() {
            SceneBuilderEditor.this.myDocument.removeDocumentListener((DocumentListener)this);
        }

        public void documentChanged(DocumentEvent e) {
            if (this.myRunState) {
                SceneBuilderEditor.this.addSceneBuilder();
            }
        }
    }
}

