/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.declaration;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.util.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrModifierFix;
import org.jetbrains.plugins.groovy.codeInspection.declaration.GrMethodMayBeStaticInspectionFilter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrMethodMayBeStaticInspection
extends BaseInspection {
    public boolean myIgnoreTraitMethods = true;
    public boolean myOnlyPrivateOrFinal = false;
    public boolean myIgnoreEmptyMethods = true;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("method.may.be.static.option.ignore.trait.methods", new Object[0]), "myIgnoreTraitMethods");
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("method.may.be.static.only.private.or.final.option", new Object[0]), "myOnlyPrivateOrFinal");
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("method.may.be.static.ignore.empty.method.option", new Object[0]), "myIgnoreEmptyMethods");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitMethod(GrMethod method) {
                if (GrMethodMayBeStaticInspection.this.checkMethod(method)) {
                    GrModifierFix modifierFix = new GrModifierFix(method, "static", false, true, new Function<ProblemDescriptor, PsiModifierList>(){

                        public PsiModifierList fun(ProblemDescriptor descriptor) {
                            PsiElement element = descriptor.getPsiElement();
                            PsiElement parent = element.getParent();
                            assert (parent instanceof GrMethod) : "element: " + element + ", parent:" + parent;
                            return ((GrMethod)parent).getModifierList();
                        }
                    });
                    this.registerError(method.getNameIdentifierGroovy(), GroovyInspectionBundle.message("method.may.be.static", new Object[0]), new LocalQuickFix[]{modifierFix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/declaration/GrMethodMayBeStaticInspection", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }

    private boolean checkMethod(GrMethod method) {
        Condition[] addins;
        if (method.hasModifierProperty("static")) {
            return false;
        }
        if (method.hasModifierProperty("synchronized")) {
            return false;
        }
        if (method.getModifierList().hasExplicitModifier("abstract")) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (this.myIgnoreTraitMethods && containingClass instanceof GrTraitTypeDefinition) {
            return false;
        }
        if (SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null) {
            return false;
        }
        if (OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null) {
            return false;
        }
        if (GrMethodMayBeStaticInspection.ignoreMethod(method)) {
            return false;
        }
        if (this.myOnlyPrivateOrFinal && !method.hasModifierProperty("final") && !method.hasModifierProperty("private")) {
            return false;
        }
        GrOpenBlock block = method.getBlock();
        if (block == null) {
            return false;
        }
        if (this.myIgnoreEmptyMethods && block.getStatements().length == 0) {
            return false;
        }
        if (containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
            return false;
        }
        for (Condition addin : addins = (Condition[])InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensions()) {
            if (!addin.value((Object)method)) continue;
            return false;
        }
        MethodMayBeStaticVisitor visitor = new MethodMayBeStaticVisitor();
        method.accept(visitor);
        return !visitor.haveInstanceRefsOutsideClosures();
    }

    private static boolean ignoreMethod(GrMethod method) {
        GrParameter[] parameters = method.getParameters();
        if (method.getName().equals("propertyMissing") && (parameters.length == 2 || parameters.length == 1)) {
            return true;
        }
        if (method.getName().equals("methodMissing") && (parameters.length == 2 || parameters.length == 1)) {
            return true;
        }
        if (method.getContainingClass() instanceof PsiAnonymousClass) {
            return true;
        }
        for (GrMethodMayBeStaticInspectionFilter filter : (GrMethodMayBeStaticInspectionFilter[])GrMethodMayBeStaticInspectionFilter.EP_NAME.getExtensions()) {
            if (!filter.isIgnored(method)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPrintOrPrintln(PsiElement element) {
        return element instanceof GrGdkMethod && ("print".equals(((PsiMethod)element).getName()) || "println".equals(((PsiMethod)element).getName()));
    }

    private static class MethodMayBeStaticVisitor
    extends GroovyRecursiveElementVisitor {
        private boolean myHaveInstanceRefs = false;

        private MethodMayBeStaticVisitor() {
        }

        @Override
        public void visitElement(GroovyPsiElement element) {
            if (this.myHaveInstanceRefs) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
            if (this.myHaveInstanceRefs) {
                return;
            }
            if (PsiUtil.isSuperReference(referenceExpression)) {
                this.registerInstanceRef();
                return;
            }
            if (PsiUtil.isThisReference(referenceExpression)) {
                if (!(referenceExpression.getParent() instanceof GrReferenceExpression)) {
                    this.registerInstanceRef();
                }
                return;
            }
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null || PsiUtil.isThisOrSuperRef(qualifier)) {
                GroovyResolveResult result = referenceExpression.advancedResolve();
                PsiElement element = result.getElement();
                if (GrMethodMayBeStaticInspection.isPrintOrPrintln(element)) {
                    return;
                }
                PsiElement resolveContext = result.getCurrentFileResolveContext();
                if (qualifier == null && resolveContext != null) {
                    return;
                }
                if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null) {
                    return;
                }
                if (element instanceof PsiMember && !((PsiMember)element).hasModifierProperty("static")) {
                    this.registerInstanceRef();
                }
                if (element == null) {
                    this.registerInstanceRef();
                }
            } else {
                super.visitReferenceExpression(referenceExpression);
            }
        }

        private void registerInstanceRef() {
            this.myHaveInstanceRefs = true;
        }

        @Override
        public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
            super.visitCodeReferenceElement(refElement);
            if (this.myHaveInstanceRefs) {
                return;
            }
            PsiElement resolvedElement = refElement.resolve();
            if (!(resolvedElement instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)resolvedElement;
            PsiElement scope = aClass.getScope();
            if (!(scope instanceof PsiClass)) {
                return;
            }
            if (!aClass.hasModifierProperty("static")) {
                this.registerInstanceRef();
            }
        }

        public boolean haveInstanceRefsOutsideClosures() {
            return this.myHaveInstanceRefs;
        }
    }
}

