/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrMapTypeFromNamedArgs
extends GrMapType {
    private final LinkedHashMap<String, GrExpression> myStringEntries;
    private final List<Couple<GrExpression>> myOtherEntries;
    private final VolatileNotNullLazyValue<List<Couple<PsiType>>> myTypesOfOtherEntries;
    private final VolatileNotNullLazyValue<LinkedHashMap<String, PsiType>> myTypesOfStringEntries;

    public GrMapTypeFromNamedArgs(@NotNull PsiElement context, @NotNull GrNamedArgument[] namedArgs) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "<init>"));
        }
        if (namedArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgs", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "<init>"));
        }
        this(JavaPsiFacade.getInstance((Project)context.getProject()), context.getResolveScope(), namedArgs);
    }

    public GrMapTypeFromNamedArgs(@NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, @NotNull GrNamedArgument[] namedArgs) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "<init>"));
        }
        if (namedArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgs", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "<init>"));
        }
        super(facade, scope);
        this.myTypesOfOtherEntries = new VolatileNotNullLazyValue<List<Couple<PsiType>>>(){

            @NotNull
            protected List<Couple<PsiType>> compute() {
                List list = ContainerUtil.map((Collection)GrMapTypeFromNamedArgs.this.myOtherEntries, (Function)new Function<Couple<GrExpression>, Couple<PsiType>>(){

                    public Couple<PsiType> fun(Couple<GrExpression> pair) {
                        return Couple.of((Object)GrMapTypeFromNamedArgs.this.inferTypePreventingRecursion((GrExpression)pair.first), (Object)GrMapTypeFromNamedArgs.this.inferTypePreventingRecursion((GrExpression)pair.second));
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs$1", "compute"));
                }
                return list;
            }
        };
        this.myTypesOfStringEntries = new VolatileNotNullLazyValue<LinkedHashMap<String, PsiType>>(){

            @NotNull
            protected LinkedHashMap<String, PsiType> compute() {
                LinkedHashMap result = ContainerUtil.newLinkedHashMap();
                for (Map.Entry entry : GrMapTypeFromNamedArgs.this.myStringEntries.entrySet()) {
                    result.put(entry.getKey(), GrMapTypeFromNamedArgs.this.inferTypePreventingRecursion((GrExpression)entry.getValue()));
                }
                LinkedHashMap linkedHashMap = result;
                if (linkedHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs$2", "compute"));
                }
                return linkedHashMap;
            }
        };
        this.myStringEntries = ContainerUtil.newLinkedHashMap();
        this.myOtherEntries = ContainerUtil.newArrayList();
        for (GrNamedArgument namedArg : namedArgs) {
            GrArgumentLabel label = namedArg.getLabel();
            GrExpression expression = namedArg.getExpression();
            if (label == null || expression == null) continue;
            String name = label.getName();
            if (name != null) {
                this.myStringEntries.put(name, expression);
                continue;
            }
            GrExpression labelExpression = label.getExpression();
            if (labelExpression == null) continue;
            this.myOtherEntries.add((Couple<GrExpression>)Couple.of((Object)labelExpression, (Object)expression));
        }
    }

    @Override
    @Nullable
    public PsiType getTypeByStringKey(String key) {
        GrExpression expression = this.myStringEntries.get(key);
        return expression != null ? this.inferTypePreventingRecursion(expression) : null;
    }

    @Override
    @NotNull
    public Set<String> getStringKeys() {
        Set<String> set = this.myStringEntries.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "getStringKeys"));
        }
        return set;
    }

    @Override
    public boolean isEmpty() {
        return this.myStringEntries.isEmpty() && this.myOtherEntries.isEmpty();
    }

    @Override
    @NotNull
    protected PsiType[] getAllKeyTypes() {
        HashSet result = ContainerUtil.newHashSet();
        if (!this.myStringEntries.isEmpty()) {
            result.add(GroovyPsiManager.getInstance(this.myFacade.getProject()).createTypeByFQClassName("java.lang.String", this.getResolveScope()));
        }
        for (Couple<GrExpression> entry : this.myOtherEntries) {
            result.add(this.inferTypePreventingRecursion((GrExpression)entry.first));
        }
        result.remove(null);
        PsiType[] psiTypeArray = result.toArray(GrMapTypeFromNamedArgs.createArray((int)result.size()));
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "getAllKeyTypes"));
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    protected PsiType[] getAllValueTypes() {
        HashSet result = ContainerUtil.newHashSet();
        for (GrExpression grExpression : this.myStringEntries.values()) {
            result.add(this.inferTypePreventingRecursion(grExpression));
        }
        for (Couple couple : this.myOtherEntries) {
            result.add(this.inferTypePreventingRecursion((GrExpression)couple.second));
        }
        result.remove(null);
        PsiType[] psiTypeArray = result.toArray(GrMapTypeFromNamedArgs.createArray((int)result.size()));
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "getAllValueTypes"));
        }
        return psiTypeArray;
    }

    @Nullable
    private PsiType inferTypePreventingRecursion(final GrExpression expression) {
        return (PsiType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)false, (Computable)new Computable<PsiType>(){

            public PsiType compute() {
                return TypesUtil.boxPrimitiveType(expression.getType(), expression.getManager(), GrMapTypeFromNamedArgs.this.myScope);
            }
        });
    }

    @Override
    @NotNull
    protected List<Couple<PsiType>> getOtherEntries() {
        List list = (List)this.myTypesOfOtherEntries.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "getOtherEntries"));
        }
        return list;
    }

    @Override
    @NotNull
    protected LinkedHashMap<String, PsiType> getStringEntries() {
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.myTypesOfStringEntries.getValue();
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs", "getStringEntries"));
        }
        return linkedHashMap;
    }

    public boolean isValid() {
        for (GrExpression grExpression : this.myStringEntries.values()) {
            if (grExpression.isValid()) continue;
            return false;
        }
        for (Couple couple : this.myOtherEntries) {
            if (!((GrExpression)couple.first).isValid()) {
                return false;
            }
            if (((GrExpression)couple.second).isValid()) continue;
            return false;
        }
        return true;
    }
}

