/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;

public class GrReferenceResolveRunner {
    private final GrReferenceExpression place;
    private final GroovyResolverProcessor processor;

    public GrReferenceResolveRunner(GrReferenceExpression place, GroovyResolverProcessor processor) {
        this.place = place;
        this.processor = processor;
    }

    public void resolveImpl() {
        GrExpression qualifier = (GrExpression)this.place.getQualifier();
        if (qualifier == null) {
            if (!ResolveUtil.treeWalkUp(this.place, this.processor, true)) {
                return;
            }
            if (this.place.getContext() instanceof GrMethodCall && !ClosureMissingMethodContributor.processMethodsFromClosures(this.place, this.processor)) {
                return;
            }
        } else if (this.place.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            PsiType qtype = qualifier.getType();
            PsiType componentType = ClosureParameterEnhancer.findTypeForIteration(qtype, (PsiElement)this.place);
            if (componentType != null) {
                ResolveState state = ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier).put(SpreadState.SPREAD_STATE, (Object)SpreadState.create(qtype, null));
                this.processQualifierType(componentType, state);
            }
        } else {
            if (ResolveUtil.isClassReference(this.place)) {
                return;
            }
            if (!this.processJavaLangClass(qualifier)) {
                return;
            }
            this.processQualifier(qualifier);
        }
    }

    private boolean processJavaLangClass(@NotNull GrExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processJavaLangClass"));
        }
        if (!(qualifier instanceof GrReferenceExpression)) {
            return true;
        }
        if (!("class".equals(((GrReferenceExpression)qualifier).getReferenceName()) || PsiUtil.isThisReference(qualifier) || ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass)) {
            return true;
        }
        PsiType classType = ResolveUtil.unwrapClassType(qualifier.getType());
        return classType == null || this.processQualifierType(classType, ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier));
    }

    private boolean processQualifier(@NotNull GrExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processQualifier"));
        }
        PsiType qualifierType = qualifier.getType();
        ResolveState state = ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier);
        if (qualifierType == null || PsiType.VOID.equals((Object)qualifierType)) {
            if (qualifier instanceof GrReferenceExpression) {
                PsiClassType objectQualifier;
                PsiElement resolved = ((GrReferenceExpression)qualifier).resolve();
                if (resolved instanceof PsiClass ? !ResolveUtil.processClassDeclarations((PsiClass)resolved, this.processor, state, null, this.place) : resolved != null && !resolved.processDeclarations((PsiScopeProcessor)this.processor, state, null, (PsiElement)this.place)) {
                    return false;
                }
                if (!(resolved instanceof PsiPackage) && !this.processQualifierType((PsiType)(objectQualifier = TypesUtil.getJavaLangObject(this.place)), state)) {
                    return false;
                }
            }
        } else if (!this.processQualifierType(qualifierType, state)) {
            return false;
        }
        return true;
    }

    private boolean processQualifierType(@NotNull PsiType originalQualifierType, @NotNull ResolveState state) {
        PsiType componentType;
        GroovyPsiManager gmanager;
        GrTypeDefinition arrayClass;
        PsiClassType.ClassResolveResult qualifierResult;
        PsiClass qualifierClass;
        PsiWildcardType wildcard;
        PsiType qualifierType;
        if (originalQualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalQualifierType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processQualifierType"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processQualifierType"));
        }
        PsiType psiType = qualifierType = originalQualifierType instanceof PsiDisjunctionType ? ((PsiDisjunctionType)originalQualifierType).getLeastUpperBound() : originalQualifierType;
        if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                if (this.processQualifierType(conjunct, state)) continue;
                return false;
            }
            return true;
        }
        if (qualifierType instanceof PsiCapturedWildcardType && (wildcard = ((PsiCapturedWildcardType)qualifierType).getWildcard()).isExtends()) {
            PsiType bound = wildcard.getExtendsBound();
            return this.processQualifierType(bound, state);
        }
        if (qualifierType instanceof GrTraitType) {
            return this.processTraitType((GrTraitType)qualifierType, state);
        }
        if (qualifierType instanceof PsiClassType ? (qualifierClass = (qualifierResult = ((PsiClassType)qualifierType).resolveGenerics()).getElement()) != null && !ResolveUtil.processClassDeclarations(qualifierClass, this.processor, state.put(PsiSubstitutor.KEY, (Object)qualifierResult.getSubstitutor()), null, this.place) : qualifierType instanceof PsiArrayType && (arrayClass = (gmanager = GroovyPsiManager.getInstance(this.place.getProject())).getArrayClass(((PsiArrayType)qualifierType).getComponentType())) != null && !ResolveUtil.processClassDeclarations(arrayClass, this.processor, state, null, this.place)) {
            return false;
        }
        if (!(this.place.getParent() instanceof GrMethodCall) && InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Collection") && (componentType = ClosureParameterEnhancer.findTypeForIteration(qualifierType, (PsiElement)this.place)) != null) {
            SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
            this.processQualifierType(componentType, state.put(SpreadState.SPREAD_STATE, (Object)SpreadState.create(qualifierType, spreadState)));
        }
        if (!ResolveUtil.processCategoryMembers(this.place, this.processor, state)) {
            return false;
        }
        return ResolveUtil.processNonCodeMembers(qualifierType, this.processor, this.place, state);
    }

    private boolean processTraitType(@NotNull GrTraitType traitType, @NotNull ResolveState state) {
        if (traitType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processTraitType"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processTraitType"));
        }
        PsiType[] conjuncts = traitType.getConjuncts();
        for (int i = conjuncts.length - 1; i >= 0; --i) {
            if (this.processQualifierType(conjuncts[i], state)) continue;
            return false;
        }
        return true;
    }
}

