/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.transformations.TransformationResult;
import org.jetbrains.plugins.groovy.transformations.TransformationUtilKt;

public class GrTypeDefinitionMembersCache {
    private final SimpleModificationTracker myTreeChangeTracker = new SimpleModificationTracker();
    private final GrTypeDefinition myDefinition;
    private final Collection<?> myDependencies = Arrays.asList(this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);

    public GrTypeDefinitionMembersCache(GrTypeDefinition definition) {
        this.myDefinition = definition;
    }

    public void dropCaches() {
        this.myTreeChangeTracker.incModificationCount();
    }

    public GrTypeDefinition[] getCodeInnerClasses() {
        return (GrTypeDefinition[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.getBodyCodeInnerClasses(this.myDefinition), this.myDependencies));
    }

    public GrMethod[] getCodeMethods() {
        return (GrMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.getBodyCodeMethods(this.myDefinition), this.myDependencies));
    }

    public GrMethod[] getCodeConstructors() {
        return (GrMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.getCodeConstructors(this.myDefinition), this.myDependencies));
    }

    public GrField[] getCodeFields() {
        return (GrField[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.getBodyCodeFields(this.myDefinition), this.myDependencies));
    }

    public PsiClass[] getInnerClasses() {
        assert (!TransformationUtilKt.isUnderTransformation(this.myDefinition));
        return this.getTransformationResult().getInnerClasses();
    }

    public PsiMethod[] getMethods() {
        assert (!TransformationUtilKt.isUnderTransformation(this.myDefinition));
        return this.getTransformationResult().getMethods();
    }

    public PsiMethod[] getConstructors() {
        assert (!TransformationUtilKt.isUnderTransformation(this.myDefinition));
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.getConstructors(this.myDefinition), this.myDependencies));
    }

    public GrField[] getFields() {
        assert (!TransformationUtilKt.isUnderTransformation(this.myDefinition));
        return this.getTransformationResult().getFields();
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes(boolean includeSynthetic) {
        if (includeSynthetic && TransformationUtilKt.isUnderTransformation(this.myDefinition)) {
            includeSynthetic = false;
        }
        PsiClassType[] psiClassTypeArray = (PsiClassType[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)(includeSynthetic ? () -> {
            PsiClassType[] extendsTypes = this.getTransformationResult().getExtendsTypes();
            PsiClassType[] result = GrClassImplUtil.getExtendsListTypes(this.myDefinition, extendsTypes);
            return CachedValueProvider.Result.create((Object)result, this.myDependencies);
        } : () -> {
            PsiClassType[] extendsTypes = GrClassImplUtil.getReferenceListTypes(this.myDefinition.getExtendsClause());
            PsiClassType[] result = GrClassImplUtil.getExtendsListTypes(this.myDefinition, extendsTypes);
            return CachedValueProvider.Result.create((Object)result, this.myDependencies);
        }));
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache", "getExtendsListTypes"));
        }
        return psiClassTypeArray;
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes(boolean includeSynthetic) {
        if (includeSynthetic && TransformationUtilKt.isUnderTransformation(this.myDefinition)) {
            includeSynthetic = false;
        }
        PsiClassType[] psiClassTypeArray = (PsiClassType[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)(includeSynthetic ? () -> {
            PsiClassType[] implementsTypes = this.getTransformationResult().getImplementsTypes();
            PsiClassType[] result = GrClassImplUtil.getImplementsListTypes(this.myDefinition, implementsTypes);
            return CachedValueProvider.Result.create((Object)result, this.myDependencies);
        } : () -> {
            PsiClassType[] implementsTypes = GrClassImplUtil.getReferenceListTypes(this.myDefinition.getImplementsClause());
            PsiClassType[] result = GrClassImplUtil.getImplementsListTypes(this.myDefinition, implementsTypes);
            return CachedValueProvider.Result.create((Object)result, this.myDependencies);
        }));
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache", "getImplementsListTypes"));
        }
        return psiClassTypeArray;
    }

    @NotNull
    private TransformationResult getTransformationResult() {
        TransformationResult transformationResult = (TransformationResult)CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, () -> CachedValueProvider.Result.create((Object)TransformationUtilKt.transformDefinition(this.myDefinition), this.myDependencies));
        if (transformationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache", "getTransformationResult"));
        }
        return transformationResult;
    }
}

