/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class GrTraitField
extends GrLightField
implements PsiMirrorElement {
    private static final Logger LOG = Logger.getInstance(GrTraitField.class);
    private final PsiField myField;

    public GrTraitField(@NotNull PsiField field, GrTypeDefinition clazz, PsiSubstitutor substitutor) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrTraitField", "<init>"));
        }
        super(clazz, GrTraitField.getNewNameForField(field), substitutor.substitute(field.getType()), (PsiElement)field);
        GrModifierList modifierList = this.getModifierList();
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!field.hasModifierProperty(modifier)) continue;
            ((GrLightModifierList)modifierList).addModifier(modifier);
        }
        this.myField = field;
    }

    @NotNull
    private static String getNewNameForField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrTraitField", "getNewNameForField"));
        }
        PsiClass containingClass = field.getContainingClass();
        LOG.assertTrue(containingClass != null);
        String string = GrTraitUtil.getTraitFieldPrefix(containingClass) + field.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrTraitField", "getNewNameForField"));
        }
        return string;
    }

    @NotNull
    public PsiField getPrototype() {
        PsiField psiField = this.myField;
        if (psiField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrTraitField", "getPrototype"));
        }
        return psiField;
    }
}

