/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrDelegatingScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.JavaResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class ResolveUtil {
    private static final Logger LOG = Logger.getInstance(ResolveUtil.class);
    public static final PsiScopeProcessor.Event DECLARATION_SCOPE_PASSED = new PsiScopeProcessor.Event(){};
    private static final Key<PsiType> COMPARABLE = Key.create((String)"java.lang.Comparable");
    private static final Key<PsiType> SERIALIZABLE = Key.create((String)"java.io.Serializable");
    private static final Key<PsiType> STRING = Key.create((String)"java.lang.String");

    private ResolveUtil() {
    }

    public static boolean treeWalkUp(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor, boolean processNonCodeMethods) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "treeWalkUp"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "treeWalkUp"));
        }
        return ResolveUtil.treeWalkUp(place, place, processor, processNonCodeMethods, ResolveState.initial());
    }

    public static boolean treeWalkUp(@NotNull PsiElement place, @NotNull PsiElement originalPlace, @NotNull PsiScopeProcessor processor, boolean processNonCodeMethods, @NotNull ResolveState state) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "treeWalkUp"));
        }
        if (originalPlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalPlace", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "treeWalkUp"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "treeWalkUp"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "treeWalkUp"));
        }
        try {
            return ResolveUtil.doTreeWalkUp(place, originalPlace, processor, (PsiScopeProcessor)(processNonCodeMethods ? processor : null), state);
        }
        catch (StackOverflowError e) {
            LOG.error("StackOverflow", (Throwable)e, new String[]{place.getContainingFile().getText()});
            throw e;
        }
    }

    public static boolean doTreeWalkUp(@NotNull PsiElement place, final @NotNull PsiElement originalPlace, final @NotNull PsiScopeProcessor processor, final @Nullable PsiScopeProcessor nonCodeProcessor, final @NotNull ResolveState state) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "doTreeWalkUp"));
        }
        if (originalPlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalPlace", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "doTreeWalkUp"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "doTreeWalkUp"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "doTreeWalkUp"));
        }
        GrClosableBlock maxScope = nonCodeProcessor != null ? (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)place, GrClosableBlock.class, (boolean)true, (Class[])new Class[]{PsiFile.class}) : null;
        return PsiTreeUtil.treeWalkUp((PsiElement)place, (PsiElement)maxScope, (PairProcessor)new PairProcessor<PsiElement, PsiElement>(){

            public boolean process(PsiElement scope, PsiElement lastParent) {
                ProgressManager.checkCanceled();
                if (!ResolveUtil.doProcessDeclarations(originalPlace, lastParent, scope, ResolveUtil.substituteProcessor(processor, scope), nonCodeProcessor, state)) {
                    return false;
                }
                ResolveUtil.issueLevelChangeEvents(processor, scope);
                return true;
            }
        });
    }

    static boolean doProcessDeclarations(@NotNull PsiElement place, @Nullable PsiElement lastParent, @NotNull PsiElement scope, @NotNull PsiScopeProcessor plainProcessor, @Nullable PsiScopeProcessor nonCodeProcessor, @NotNull ResolveState state) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "doProcessDeclarations"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "doProcessDeclarations"));
        }
        if (plainProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plainProcessor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "doProcessDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "doProcessDeclarations"));
        }
        if (scope instanceof GrClosableBlock && nonCodeProcessor != null) {
            if (!((GrClosableBlock)scope).processClosureDeclarations(plainProcessor, nonCodeProcessor, state, lastParent, place)) {
                return false;
            }
        } else {
            if (scope instanceof PsiClass ? !ResolveUtil.processClassDeclarations((PsiClass)scope, plainProcessor, state, lastParent, place) : !scope.processDeclarations(plainProcessor, state, lastParent, place)) {
                return false;
            }
            if ((scope instanceof GrTypeDefinition || scope instanceof GrClosableBlock) && !ResolveUtil.processStaticImports(plainProcessor, place.getContainingFile(), state, place)) {
                return false;
            }
        }
        return nonCodeProcessor == null || ResolveUtil.processScopeNonCodeMembers(place, lastParent, nonCodeProcessor, scope, state);
    }

    static void issueLevelChangeEvents(PsiScopeProcessor processor, PsiElement run) {
        processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.CHANGE_LEVEL, null);
        if (run instanceof GrClosableBlock && "owner".equals(ResolveUtil.getNameHint(processor)) || run instanceof PsiClass && !(run instanceof PsiAnonymousClass) || run instanceof GrMethod && run.getParent() instanceof GroovyFile) {
            processor.handleEvent(DECLARATION_SCOPE_PASSED, (Object)run);
        }
    }

    static PsiScopeProcessor substituteProcessor(PsiScopeProcessor processor, PsiElement scope) {
        if (scope.getLanguage() != GroovyLanguage.INSTANCE && processor.getHint(NameHint.KEY) != null) {
            return new JavaResolverProcessor(processor);
        }
        return processor;
    }

    private static boolean processScopeNonCodeMembers(@NotNull PsiElement place, @Nullable PsiElement lastParent, @NotNull PsiScopeProcessor processor, @NotNull PsiElement scope, @NotNull ResolveState state) {
        PsiClass psiClass;
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processScopeNonCodeMembers"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processScopeNonCodeMembers"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processScopeNonCodeMembers"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processScopeNonCodeMembers"));
        }
        if (scope instanceof GrTypeDefinition) {
            if (!ResolveUtil.processNonCodeMembers((PsiType)ResolveUtil.createPsiType((GrTypeDefinition)scope), processor, place, state)) {
                return false;
            }
            PsiClassType categoryType = GdkMethodUtil.getCategoryType((PsiClass)scope);
            if (categoryType != null && !ResolveUtil.processNonCodeMembers((PsiType)categoryType, processor, place, state)) {
                return false;
            }
        }
        if (scope instanceof GroovyFileBase && ((GroovyFileBase)scope).isScript() && (psiClass = ((GroovyFileBase)scope).getScriptClass()) != null && !ResolveUtil.processNonCodeMembers((PsiType)ResolveUtil.createPsiType(psiClass), processor, place, state)) {
            return false;
        }
        if (scope instanceof GrClosableBlock) {
            ResolveState _state = state.put(ClassHint.RESOLVE_CONTEXT, (Object)scope);
            PsiClass superClass = ResolveUtil.getLiteralSuperClass((GrClosableBlock)scope);
            if (superClass != null && !ResolveUtil.processClassDeclarations(superClass, processor, _state, null, place)) {
                return false;
            }
            if (!GdkMethodUtil.categoryIteration((GrClosableBlock)scope, processor, _state)) {
                return false;
            }
            if (!ResolveUtil.processNonCodeMembers((PsiType)GrClosureType.create((GrClosableBlock)scope, false), processor, place, _state)) {
                return false;
            }
        }
        return !(scope instanceof GrStatementOwner) || GdkMethodUtil.processMixinToMetaclass((GrStatementOwner)scope, processor, state, lastParent, place);
    }

    @NotNull
    private static PsiClassType createPsiType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "createPsiType"));
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiClassType psiClassType = factory.createType(psiClass);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "createPsiType"));
        }
        return psiClassType;
    }

    public static boolean processChildren(@NotNull PsiElement element, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        PsiElement run;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processChildren"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processChildren"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processChildren"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processChildren"));
        }
        if (!ResolveUtil.shouldProcessProperties((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            return true;
        }
        PsiElement psiElement = run = lastParent == null ? element.getLastChild() : lastParent.getPrevSibling();
        while (run != null) {
            if (!run.processDeclarations(processor, state, null, place)) {
                return false;
            }
            run = run.getPrevSibling();
        }
        return true;
    }

    @Nullable
    public static String getNameHint(PsiScopeProcessor processor) {
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        if (nameHint == null) {
            return null;
        }
        return nameHint.getName(ResolveState.initial());
    }

    public static boolean processElement(@NotNull PsiScopeProcessor processor, @NotNull PsiNamedElement namedElement, @NotNull ResolveState state) {
        String name;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processElement"));
        }
        if (namedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedElement", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processElement"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processElement"));
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint == null ? null : nameHint.getName(state);
        if (name == null || name.equals(namedElement.getName())) {
            return processor.execute((PsiElement)namedElement, state);
        }
        return true;
    }

    public static boolean processAllDeclarations(@NotNull PsiType type, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processAllDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processAllDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processAllDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processAllDeclarations"));
        }
        return ResolveUtil.processAllDeclarationsSeparately(type, processor, processor, state, place);
    }

    public static boolean processAllDeclarationsSeparately(@NotNull PsiType type, @NotNull PsiScopeProcessor processor, @NotNull PsiScopeProcessor nonCodeProcessor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processAllDeclarationsSeparately"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processAllDeclarationsSeparately"));
        }
        if (nonCodeProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonCodeProcessor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processAllDeclarationsSeparately"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processAllDeclarationsSeparately"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processAllDeclarationsSeparately"));
        }
        if ((type = TypesUtil.boxPrimitiveType(type, place.getManager(), place.getResolveScope())) instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            PsiClass psiClass = resolveResult.getElement();
            PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
            state = state.put(PsiSubstitutor.KEY, (Object)substitutor.putAll(resolveResult.getSubstitutor()));
            if (psiClass != null && !ResolveUtil.processClassDeclarations(psiClass, processor, state, null, place)) {
                return false;
            }
        }
        if (!ResolveUtil.processCategoryMembers(place, nonCodeProcessor, state)) {
            return false;
        }
        return ResolveUtil.processNonCodeMembers(type, nonCodeProcessor, place, state);
    }

    public static boolean processNonCodeMembers(@NotNull PsiType type, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processNonCodeMembers"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processNonCodeMembers"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processNonCodeMembers"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processNonCodeMembers"));
        }
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        for (PsiScopeProcessor each : GroovyResolverProcessor.allProcessors(processor)) {
            if (NonCodeMembersContributor.runContributors(type, each, place, state)) continue;
            return false;
        }
        return true;
    }

    private static void collectSuperTypes(PsiType type, Set<String> visited, Project project) {
        PsiType[] superTypes;
        String qName = ResolveUtil.rawCanonicalText(type);
        if (!visited.add(qName)) {
            return;
        }
        for (PsiType superType : superTypes = type.getSuperTypes()) {
            ResolveUtil.collectSuperTypes(TypeConversionUtil.erasure((PsiType)superType), visited, project);
        }
        if (type instanceof PsiArrayType && superTypes.length == 0) {
            PsiType comparable = ResolveUtil.createTypeFromText(project, COMPARABLE, "java.lang.Comparable");
            PsiType serializable = ResolveUtil.createTypeFromText(project, SERIALIZABLE, "java.io.Serializable");
            ResolveUtil.collectSuperTypes(comparable, visited, project);
            ResolveUtil.collectSuperTypes(serializable, visited, project);
        }
        if ("groovy.lang.GString".equals(qName)) {
            ResolveUtil.collectSuperTypes(ResolveUtil.createTypeFromText(project, STRING, "java.lang.String"), visited, project);
        }
    }

    public static PsiType createTypeFromText(Project project, Key<PsiType> key, String text) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiType type = (PsiType)project.getUserData(key);
        if (type == null) {
            type = factory.createTypeFromText(text, null);
            project.putUserData(key, (Object)type);
        }
        return type;
    }

    public static Set<String> getAllSuperTypes(@NotNull PsiType base, Project project) {
        Set result;
        String key;
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getAllSuperTypes"));
        }
        Map cache = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<Map<String, Set<String>>>(){

            public CachedValueProvider.Result<Map<String, Set<String>>> compute() {
                ConcurrentMap result = ContainerUtil.newConcurrentMap();
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
        PsiClass cls = com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)base);
        if (cls instanceof PsiTypeParameter) {
            PsiClass superClass = cls.getSuperClass();
            key = cls.getName() + (superClass == null ? "java.lang.Object" : superClass.getName());
        } else {
            key = base instanceof PsiClassType ? TypesUtil.getQualifiedName(base) : base.getCanonicalText();
        }
        Set set = result = key == null ? null : (Set)cache.get(key);
        if (result == null) {
            result = ContainerUtil.newHashSet();
            ResolveUtil.collectSuperTypes(base, result, project);
            if (key != null) {
                cache.put(key, result);
            }
        }
        return result;
    }

    @NotNull
    private static String rawCanonicalText(@NotNull PsiType type) {
        String qname;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "rawCanonicalText"));
        }
        if (type instanceof PsiClassType && (qname = TypesUtil.getQualifiedName(type)) != null) {
            String string = qname;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "rawCanonicalText"));
            }
            return string;
        }
        String string = TypeConversionUtil.erasure((PsiType)type).getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "rawCanonicalText"));
        }
        return string;
    }

    public static GroovyPsiElement resolveProperty(GroovyPsiElement place, String name) {
        PropertyResolverProcessor processor = new PropertyResolverProcessor(name, place);
        return (GroovyPsiElement)ResolveUtil.resolveExistingElement(place, processor, GrVariable.class, GrReferenceExpression.class);
    }

    @Nullable
    public static PsiClass resolveClass(GroovyPsiElement place, String name) {
        ClassResolverProcessor processor = new ClassResolverProcessor(name, place);
        return (PsiClass)ResolveUtil.resolveExistingElement(place, processor, PsiClass.class);
    }

    @Nullable
    public static <T> T resolveExistingElement(PsiElement place, ResolverProcessor processor, Class<? extends T> ... classes) {
        GroovyResolveResult[] candidates;
        ResolveUtil.treeWalkUp(place, processor, true);
        for (GroovyResolveResult candidate : candidates = processor.getCandidates()) {
            PsiElement element = candidate.getElement();
            if (element == place) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(element)) continue;
                return (T)element;
            }
        }
        return null;
    }

    @NotNull
    public static Pair<GrStatement, GrLabeledStatement> resolveLabelTargets(@Nullable String labelName, @Nullable PsiElement element, boolean isBreak) {
        if (element == null) {
            Pair pair = new Pair(null, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "resolveLabelTargets"));
            }
            return pair;
        }
        if (labelName == null) {
            do {
                if ((element = element.getContext()) != null && !(element instanceof GrClosableBlock) && !(element instanceof GrMember) && !(element instanceof GroovyFile)) continue;
                Pair pair = new Pair(null, null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "resolveLabelTargets"));
                }
                return pair;
            } while (!(element instanceof GrLoopStatement) && (!isBreak || !(element instanceof GrSwitchStatement)));
            Pair pair = new Pair((Object)((GrStatement)element), null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "resolveLabelTargets"));
            }
            return pair;
        }
        GrStatement statement = null;
        do {
            PsiElement last = element;
            if ((element = element.getContext()) == null || element instanceof GrMember || element instanceof GroovyFile) break;
            if (element instanceof GrStatement && !(element instanceof GrClosableBlock)) {
                statement = (GrStatement)element;
            }
            for (PsiElement sibling = element; sibling != null; sibling = sibling.getPrevSibling()) {
                GrLabeledStatement labelStatement = ResolveUtil.findLabelStatementIn(sibling, last, labelName);
                if (labelStatement == null) continue;
                Pair pair = Pair.create((Object)statement, (Object)labelStatement);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "resolveLabelTargets"));
                }
                return pair;
            }
        } while (!(element instanceof GrClosableBlock));
        Pair pair = new Pair(null, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "resolveLabelTargets"));
        }
        return pair;
    }

    private static boolean isApplicableLabelStatement(PsiElement element, String labelName) {
        return element instanceof GrLabeledStatement && labelName.equals(((GrLabeledStatement)element).getName());
    }

    @Nullable
    private static GrLabeledStatement findLabelStatementIn(PsiElement element, PsiElement lastChild, String labelName) {
        if (ResolveUtil.isApplicableLabelStatement(element, labelName)) {
            return (GrLabeledStatement)element;
        }
        for (PsiElement child = element.getFirstChild(); child != null && child != lastChild; child = child.getNextSibling()) {
            GrLabeledStatement statement = ResolveUtil.findLabelStatementIn(child, child, labelName);
            if (statement == null) continue;
            return statement;
        }
        return null;
    }

    @Nullable
    public static GrLabeledStatement resolveLabeledStatement(@Nullable String labelName, @Nullable PsiElement element, boolean isBreak) {
        return (GrLabeledStatement)ResolveUtil.resolveLabelTargets((String)labelName, (PsiElement)element, (boolean)isBreak).second;
    }

    @Nullable
    public static GrStatement resolveLabelTargetStatement(@Nullable String labelName, @Nullable PsiElement element, boolean isBreak) {
        return (GrStatement)ResolveUtil.resolveLabelTargets((String)labelName, (PsiElement)element, (boolean)isBreak).first;
    }

    public static boolean processCategoryMembers(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processCategoryMembers"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processCategoryMembers"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processCategoryMembers"));
        }
        boolean inCodeBlock = true;
        PsiElement lastParent = null;
        for (PsiElement run = place; run != null; run = run.getContext()) {
            ProgressManager.checkCanceled();
            if (run instanceof GrMember) {
                inCodeBlock = false;
            }
            if (run instanceof GrClosableBlock) {
                if (inCodeBlock && !GdkMethodUtil.categoryIteration((GrClosableBlock)run, processor, state)) {
                    return false;
                }
                PsiClass superClass = ResolveUtil.getLiteralSuperClass((GrClosableBlock)run);
                if (superClass != null && !GdkMethodUtil.processCategoryMethods(run, processor, state, superClass)) {
                    return false;
                }
            }
            if (run instanceof GrStatementOwner && !GdkMethodUtil.processMixinToMetaclass((GrStatementOwner)run, processor, state, lastParent, place)) {
                return false;
            }
            lastParent = run;
        }
        return true;
    }

    @Nullable
    private static PsiClass getLiteralSuperClass(GrClosableBlock closure) {
        PsiClassType type = closure.getParent() instanceof GrNamedArgument && closure.getParent().getParent() instanceof GrListOrMap ? LiteralConstructorReference.getTargetConversionType((GrListOrMap)closure.getParent().getParent()) : LiteralConstructorReference.getTargetConversionType(closure);
        return type != null ? type.resolve() : null;
    }

    public static PsiElement[] mapToElements(GroovyResolveResult[] candidates) {
        PsiElement[] elements = new PsiElement[candidates.length];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = candidates[i].getElement();
        }
        return elements;
    }

    public static GroovyResolveResult[] filterSameSignatureCandidates(Collection<? extends GroovyResolveResult> candidates) {
        if (candidates.size() == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (candidates.size() == 1) {
            return candidates.toArray(new GroovyResolveResult[candidates.size()]);
        }
        ArrayList<GroovyResolveResult> result = new ArrayList<GroovyResolveResult>();
        Iterator<? extends GroovyResolveResult> allIterator = candidates.iterator();
        result.add(allIterator.next());
        block0: while (allIterator.hasNext()) {
            PsiSubstitutor currentSubstitutor;
            PsiMethod currentMethod;
            GroovyResolveResult currentResult = allIterator.next();
            if (currentResult instanceof GroovyMethodResult) {
                GroovyMethodResult currentMethodResult = (GroovyMethodResult)currentResult;
                currentMethod = currentMethodResult.getElement();
                currentSubstitutor = currentMethodResult.getSubstitutor(false);
            } else if (currentResult.getElement() instanceof PsiMethod) {
                currentMethod = (PsiMethod)currentResult.getElement();
                currentSubstitutor = currentResult.getSubstitutor();
            } else {
                result.add(currentResult);
                continue;
            }
            Iterator resultIterator = result.iterator();
            while (resultIterator.hasNext()) {
                PsiSubstitutor otherSubstitutor;
                PsiMethod otherMethod;
                GroovyResolveResult otherResult = (GroovyResolveResult)resultIterator.next();
                if (otherResult instanceof GroovyMethodResult) {
                    GroovyMethodResult otherMethodResult = (GroovyMethodResult)otherResult;
                    otherMethod = otherMethodResult.getElement();
                    otherSubstitutor = otherMethodResult.getSubstitutor(false);
                } else {
                    if (!(otherResult.getElement() instanceof PsiMethod)) continue;
                    otherMethod = (PsiMethod)otherResult.getElement();
                    otherSubstitutor = otherResult.getSubstitutor();
                }
                if (ResolveUtil.dominated(currentMethod, currentSubstitutor, otherMethod, otherSubstitutor)) continue block0;
                if (!ResolveUtil.dominated(otherMethod, otherSubstitutor, currentMethod, currentSubstitutor)) continue;
                resultIterator.remove();
            }
            result.add(currentResult);
        }
        return result.toArray(new GroovyResolveResult[result.size()]);
    }

    public static boolean dominated(PsiMethod method1, PsiSubstitutor substitutor1, PsiMethod method2, PsiSubstitutor substitutor2) {
        PsiParameter[] params2;
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        if (params1.length != (params2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < params2.length; ++i) {
            PsiType type2;
            PsiType type1 = TypeConversionUtil.erasure((PsiType)substitutor1.substitute(params1[i].getType()));
            if (type1.equals(type2 = TypeConversionUtil.erasure((PsiType)substitutor2.substitute(params2[i].getType())))) continue;
            return false;
        }
        if (method1 instanceof GrGdkMethod && method2 instanceof GrGdkMethod) {
            PsiType t2;
            PsiMethod static1 = ((GrGdkMethod)method1).getStaticMethod();
            PsiMethod static2 = ((GrGdkMethod)method2).getStaticMethod();
            PsiParameter p1 = static1.getParameterList().getParameters()[0];
            PsiParameter p2 = static2.getParameterList().getParameters()[0];
            PsiType t1 = substitutor1.substitute(p1.getType());
            if (!t1.equals(t2 = substitutor2.substitute(p2.getType()))) {
                if (t1 instanceof PsiClassType) {
                    t1 = TypeConversionUtil.erasure((PsiType)t1);
                }
                if (t2 instanceof PsiClassType) {
                    t2 = TypeConversionUtil.erasure((PsiType)t2);
                }
                return t1.isAssignableFrom(t2);
            }
        }
        return true;
    }

    public static GroovyResolveResult[] getCallVariants(GroovyPsiElement place) {
        PsiElement parent = place.getParent();
        GroovyResolveResult[] variants = GroovyResolveResult.EMPTY_ARRAY;
        if (parent instanceof GrCallExpression) {
            variants = ((GrCallExpression)parent).getCallVariants(place instanceof GrExpression ? (GrExpression)place : null);
        } else if (parent instanceof GrConstructorInvocation) {
            PsiClass clazz = ((GrConstructorInvocation)parent).getDelegatedClass();
            if (clazz != null) {
                PsiMethod[] constructors = clazz.getConstructors();
                variants = ResolveUtil.getConstructorResolveResult(constructors, place);
            }
        } else if (parent instanceof GrAnonymousClassDefinition) {
            PsiElement element = ((GrAnonymousClassDefinition)parent).getBaseClassReferenceGroovy().resolve();
            if (element instanceof PsiClass) {
                PsiMethod[] constructors = ((PsiClass)element).getConstructors();
                variants = ResolveUtil.getConstructorResolveResult(constructors, place);
            }
        } else if (place instanceof GrReferenceExpression) {
            variants = ((GrReferenceExpression)place).getSameNameVariants();
        }
        return variants;
    }

    private static GroovyResolveResult[] getConstructorResolveResult(PsiMethod[] constructors, PsiElement place) {
        GroovyResolveResult[] variants = new GroovyResolveResult[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            boolean isAccessible = com.intellij.psi.util.PsiUtil.isAccessible((PsiMember)constructors[i], (PsiElement)place, null);
            variants[i] = new GroovyResolveResultImpl((PsiElement)constructors[i], isAccessible);
        }
        return variants;
    }

    public static GroovyResolveResult[] getAllClassConstructors(@NotNull PsiClass psiClass, @NotNull PsiSubstitutor substitutor, @Nullable PsiType[] argTypes, @NotNull PsiElement place) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getAllClassConstructors"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getAllClassConstructors"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getAllClassConstructors"));
        }
        MethodResolverProcessor processor = new MethodResolverProcessor(psiClass.getName(), place, true, null, argTypes, PsiType.EMPTY_ARRAY);
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor);
        for (PsiMethod constructor : psiClass.getConstructors()) {
            processor.execute((PsiElement)constructor, state);
        }
        PsiClassType qualifierType = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass);
        ResolveUtil.processNonCodeMembers((PsiType)qualifierType, processor, place, state);
        return processor.getCandidates();
    }

    public static boolean isDefinitelyKeyOfMap(GrReferenceExpression ref) {
        GrExpression qualifier = ResolveUtil.getSelfOrWithQualifier(ref);
        if (qualifier == null) {
            return false;
        }
        if (qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass) {
            return false;
        }
        PsiType type = qualifier.getType();
        if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
            return false;
        }
        String qname = TypesUtil.getQualifiedName(type);
        return !"groovy.util.ConfigObject".equals(qname);
    }

    public static boolean isKeyOfMap(GrReferenceExpression ref) {
        if (!(ref.getParent() instanceof GrIndexProperty) && PsiUtil.isCall(ref)) {
            return false;
        }
        if (ref.multiResolve(false).length > 0) {
            return false;
        }
        return ResolveUtil.mayBeKeyOfMap(ref);
    }

    public static boolean mayBeKeyOfMap(GrReferenceExpression ref) {
        GrExpression qualifier = ResolveUtil.getSelfOrWithQualifier(ref);
        if (qualifier == null) {
            return false;
        }
        if (qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiType)qualifier.getType(), (String)"java.util.Map");
    }

    @Nullable
    public static GrExpression getSelfOrWithQualifier(GrReferenceExpression ref) {
        GrClosableBlock closure;
        GrExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null) {
            return qualifier;
        }
        GrExpression place = ref;
        while ((closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)place, GrClosableBlock.class, (boolean)true, (Class[])new Class[]{GrMember.class, GroovyFile.class})) != null) {
            GrExpression withQualifier;
            GrExpression expression;
            place = closure;
            PsiElement clParent = closure.getParent();
            if (clParent instanceof GrArgumentList) {
                clParent = clParent.getParent();
            }
            if (!(clParent instanceof GrMethodCall) || !((expression = ((GrMethodCall)clParent).getInvokedExpression()) instanceof GrReferenceExpression) || !GdkMethodUtil.isWithName(((GrReferenceExpression)expression).getReferenceName()) || !(((GrReferenceExpression)expression).resolve() instanceof GrGdkMethod) || (withQualifier = ((GrReferenceExpression)expression).getQualifierExpression()) == null) continue;
            return withQualifier;
        }
        return null;
    }

    @NotNull
    public static GroovyResolveResult[] getMethodCandidates(@NotNull PsiType thisType, @Nullable String methodName, @NotNull PsiElement place, PsiType ... argumentTypes) {
        if (thisType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisType", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
        }
        GroovyResolveResult[] groovyResolveResultArray = ResolveUtil.getMethodCandidates(thisType, methodName, place, true, false, false, argumentTypes);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
        }
        return groovyResolveResultArray;
    }

    @NotNull
    public static GroovyResolveResult[] getMethodCandidates(@NotNull PsiType thisType, @Nullable String methodName, @NotNull PsiElement place, boolean resolveClosures, boolean allVariants, boolean byShape, PsiType ... argumentTypes) {
        GroovyResolveResult[] allPropertyCandidates;
        if (thisType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisType", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
        }
        if (methodName == null) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        thisType = TypesUtil.boxPrimitiveType(thisType, place.getManager(), place.getResolveScope());
        MethodResolverProcessor processor = new MethodResolverProcessor(methodName, place, false, thisType, argumentTypes, PsiType.EMPTY_ARRAY, allVariants);
        ResolveState state = ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)place);
        ResolveUtil.processAllDeclarations(thisType, processor, state, place);
        boolean hasApplicableMethods = processor.hasApplicableCandidates();
        Object[] methodCandidates = processor.getCandidates();
        if (hasApplicableMethods && methodCandidates.length == 1) {
            if (methodCandidates == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
            }
            return methodCandidates;
        }
        if (resolveClosures) {
            PropertyResolverProcessor propertyResolver = new PropertyResolverProcessor(methodName, place);
            ResolveUtil.processAllDeclarations(thisType, propertyResolver, state, place);
            allPropertyCandidates = propertyResolver.getCandidates();
        } else {
            allPropertyCandidates = GroovyResolveResult.EMPTY_ARRAY;
        }
        ArrayList<GroovyResolveResult> propertyCandidates = new ArrayList<GroovyResolveResult>(allPropertyCandidates.length);
        for (GroovyResolveResult candidate : allPropertyCandidates) {
            PsiType type;
            PsiElement resolved = candidate.getElement();
            if (!(resolved instanceof GrField) || !ResolveUtil.isApplicableClosureType(type = ((GrField)resolved).getTypeGroovy(), argumentTypes, place)) continue;
            propertyCandidates.add(candidate);
        }
        for (GroovyResolveResult candidate : propertyCandidates) {
            PsiClass containingClass;
            PsiElement element = candidate.getElement();
            if (!(element instanceof GrField) || (containingClass = ((PsiField)element).getContainingClass()) == null || !PsiTreeUtil.isContextAncestor((PsiElement)containingClass, (PsiElement)place, (boolean)true)) continue;
            GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{candidate};
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
            }
            return groovyResolveResultArray;
        }
        ArrayList allCandidates = new ArrayList();
        if (hasApplicableMethods) {
            ContainerUtil.addAll(allCandidates, (Object[])methodCandidates);
        }
        ContainerUtil.addAll(allCandidates, propertyCandidates);
        for (String getterName : GroovyPropertyUtils.suggestGettersName(methodName)) {
            AccessorResolverProcessor getterResolver = new AccessorResolverProcessor(getterName, methodName, place, true, thisType, PsiType.EMPTY_ARRAY);
            ResolveUtil.processAllDeclarations(thisType, getterResolver, state, place);
            GroovyResolveResult[] candidates = getterResolver.getCandidates();
            ArrayList<GroovyResolveResult> applicable = new ArrayList<GroovyResolveResult>();
            for (GroovyResolveResult candidate : candidates) {
                PsiMethod method = (PsiMethod)candidate.getElement();
                assert (method != null);
                PsiType type = PsiUtil.getSmartReturnType(method);
                if (!ResolveUtil.isApplicableClosureType(type, argumentTypes, place)) continue;
                applicable.add(candidate);
            }
            if (applicable.size() == 1) {
                GroovyResolveResult[] groovyResolveResultArray = applicable.toArray(new GroovyResolveResult[applicable.size()]);
                if (groovyResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
                }
                return groovyResolveResultArray;
            }
            ContainerUtil.addAll(allCandidates, applicable);
        }
        if (!allCandidates.isEmpty()) {
            GroovyResolveResult[] groovyResolveResultArray = allCandidates.toArray(new GroovyResolveResult[allCandidates.size()]);
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
            }
            return groovyResolveResultArray;
        }
        if (!hasApplicableMethods) {
            if (methodCandidates == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
            }
            return methodCandidates;
        }
        if (GroovyResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "getMethodCandidates"));
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static boolean isApplicableClosureType(@Nullable PsiType type, @Nullable PsiType[] argTypes, @NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "isApplicableClosureType"));
        }
        if (!(type instanceof GrClosureType)) {
            return false;
        }
        if (argTypes == null) {
            return true;
        }
        GrSignature signature = ((GrClosureType)type).getSignature();
        return GrClosureSignatureUtil.isSignatureApplicable(signature, argTypes, place);
    }

    @Nullable
    public static PsiType extractReturnTypeFromCandidate(GroovyResolveResult candidate, GrExpression expression, @Nullable PsiType[] args) {
        PsiType type;
        PsiElement element = candidate.getElement();
        if (element instanceof PsiMethod && !candidate.isInvokedOnProperty()) {
            return TypesUtil.substituteAndNormalizeType(PsiUtil.getSmartReturnType((PsiMethod)element), candidate.getSubstitutor(), candidate.getSpreadState(), expression);
        }
        if (element instanceof GrField) {
            type = ((GrField)element).getTypeGroovy();
        } else if (element instanceof PsiMethod) {
            type = PsiUtil.getSmartReturnType((PsiMethod)element);
        } else {
            return null;
        }
        if (type instanceof GrClosureType) {
            GrSignature signature = ((GrClosureType)type).getSignature();
            PsiType returnType = GrClosureSignatureUtil.getReturnType(signature, args, expression);
            return TypesUtil.substituteAndNormalizeType(returnType, candidate.getSubstitutor(), candidate.getSpreadState(), expression);
        }
        return null;
    }

    public static boolean isEnumConstant(PsiReference ref, String name, String qName) {
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PsiEnumConstant)) {
            return false;
        }
        if (!name.equals(((PsiEnumConstant)resolved).getName())) {
            return false;
        }
        PsiClass aClass = ((PsiEnumConstant)resolved).getContainingClass();
        if (aClass == null) {
            return false;
        }
        return qName.equals(aClass.getQualifiedName());
    }

    public static boolean isScriptField(GrVariable var) {
        PsiClass context = PsiUtil.getContextClass(var.getParent());
        GrModifierList modifierList = var.getModifierList();
        return context instanceof GroovyScriptClass && modifierList != null && modifierList.findAnnotation("groovy.transform.Field") != null;
    }

    @Nullable
    public static PsiClass resolveAnnotation(PsiElement insideAnnotation) {
        GrAnnotation annotation = (GrAnnotation)PsiTreeUtil.getParentOfType((PsiElement)insideAnnotation, GrAnnotation.class, (boolean)false);
        if (annotation == null) {
            return null;
        }
        GrCodeReferenceElement reference = annotation.getClassReference();
        GroovyResolveResult result = reference.advancedResolve();
        PsiElement element = result.getElement();
        if (element instanceof PsiClass && ((PsiClass)element).isAnnotationType()) {
            return (PsiClass)element;
        }
        return null;
    }

    @NotNull
    public static String inferExpectedPackageName(PsiElement place) {
        PsiPackage aPackage;
        PsiFile file = place.getContainingFile();
        PsiDirectory psiDirectory = file.getContainingDirectory();
        if (psiDirectory != null && file instanceof GroovyFile && (aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory)) != null) {
            String string = aPackage.getQualifiedName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "inferExpectedPackageName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "inferExpectedPackageName"));
        }
        return "";
    }

    public static PsiNamedElement findDuplicate(@NotNull GrVariable variable) {
        PsiElement context;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "findDuplicate"));
        }
        if (ResolveUtil.isScriptField(variable)) {
            String name = variable.getName();
            int count = 0;
            GroovyScriptClass script = (GroovyScriptClass)((GroovyFile)variable.getContainingFile()).getScriptClass();
            assert (script != null);
            for (GrScriptField field : GrScriptField.getScriptFields(script)) {
                if (!name.equals(field.getName())) continue;
                ++count;
            }
            return count > 1 ? GrScriptField.getScriptField(variable) : null;
        }
        PsiNamedElement duplicate = (PsiNamedElement)ResolveUtil.resolveExistingElement(variable, new DuplicateVariablesProcessor(variable), GrVariable.class);
        PsiElement context1 = variable.getContext();
        if (duplicate == null && variable instanceof GrParameter && context1 != null && ((context = context1.getContext()) instanceof GrClosableBlock || context instanceof GrMethod && !(context.getParent() instanceof GroovyFile) || context instanceof GrTryCatchStatement)) {
            duplicate = (PsiNamedElement)ResolveUtil.resolveExistingElement(context.getParent(), new DuplicateVariablesProcessor(variable), GrVariable.class);
        }
        if (duplicate instanceof GrLightParameter && "args".equals(duplicate.getName())) {
            return null;
        }
        return duplicate;
    }

    public static boolean canBePackage(GrReferenceExpression ref) {
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier instanceof GrReferenceExpression) {
            PsiElement resolvedQualifier = ((GrReferenceExpression)qualifier).resolve();
            return resolvedQualifier instanceof PsiPackage;
        }
        return qualifier == null && ref.getParent() instanceof GrReferenceExpression;
    }

    public static boolean canBeClass(GrReferenceExpression ref) {
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier instanceof GrReferenceExpression) {
            PsiElement resolvedQualifier = ((GrReferenceExpression)qualifier).resolve();
            return resolvedQualifier instanceof PsiClass || resolvedQualifier instanceof PsiPackage;
        }
        return qualifier == null;
    }

    public static boolean canBeClassOrPackage(GrReferenceExpression ref) {
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier instanceof GrReferenceExpression) {
            PsiElement resolvedQualifier = ((GrReferenceExpression)qualifier).resolve();
            return resolvedQualifier instanceof PsiClass || resolvedQualifier instanceof PsiPackage;
        }
        return qualifier == null;
    }

    @NotNull
    public static List<Pair<PsiParameter, PsiType>> collectExpectedParamsByArg(@NotNull PsiElement place, @NotNull GroovyResolveResult[] variants, @NotNull GrNamedArgument[] namedArguments, @NotNull GrExpression[] expressionArguments, @NotNull GrClosableBlock[] closureArguments, @NotNull GrExpression arg) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "collectExpectedParamsByArg"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "collectExpectedParamsByArg"));
        }
        if (namedArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArguments", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "collectExpectedParamsByArg"));
        }
        if (expressionArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionArguments", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "collectExpectedParamsByArg"));
        }
        if (closureArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closureArguments", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "collectExpectedParamsByArg"));
        }
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "collectExpectedParamsByArg"));
        }
        ArrayList expectedParams = ContainerUtil.newArrayList();
        for (GroovyResolveResult variant : variants) {
            Map<GrExpression, Pair<PsiParameter, PsiType>> map = GrClosureSignatureUtil.mapArgumentsToParameters(variant, place, true, true, namedArguments, expressionArguments, closureArguments);
            if (map == null) continue;
            Pair<PsiParameter, PsiType> pair = map.get(arg);
            ContainerUtil.addIfNotNull((Collection)expectedParams, pair);
        }
        ArrayList arrayList = expectedParams;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "collectExpectedParamsByArg"));
        }
        return arrayList;
    }

    public static boolean shouldProcessClasses(ElementClassHint classHint) {
        return classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS);
    }

    public static boolean shouldProcessMethods(ElementClassHint classHint) {
        return classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD);
    }

    public static boolean shouldProcessProperties(ElementClassHint classHint) {
        return classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE) || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD) || classHint.shouldProcess(ElementClassHint.DeclarationKind.ENUM_CONST);
    }

    public static boolean shouldProcessPackages(ElementClassHint classHint) {
        return classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE);
    }

    public static boolean processStaticImports(@NotNull PsiScopeProcessor resolver, @NotNull PsiFile file, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processStaticImports"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processStaticImports"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processStaticImports"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processStaticImports"));
        }
        if (!ResolveUtil.shouldProcessMethods((ElementClassHint)resolver.getHint(ElementClassHint.KEY))) {
            return true;
        }
        return file.processDeclarations((PsiScopeProcessor)new GrDelegatingScopeProcessorWithHints(resolver, null, (EnumSet)ClassHint.RESOLVE_KINDS_METHOD){

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState _state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil$4", "execute"));
                }
                if (_state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil$4", "execute"));
                }
                if (_state.get(ClassHint.RESOLVE_CONTEXT) instanceof GrImportStatement) {
                    super.execute(element, _state);
                }
                return true;
            }
        }, state, null, place);
    }

    public static boolean resolvesToClass(@Nullable PsiElement expression) {
        if (!(expression instanceof GrQualifiedReference)) {
            return false;
        }
        return ResolveUtil.isClassReference(expression) || ((GrQualifiedReference)expression).resolve() instanceof PsiClass;
    }

    public static boolean isClassReference(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "isClassReference"));
        }
        if (!(expression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression ref = (GrReferenceExpression)expression;
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        return "class".equals(ref.getReferenceName()) && qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass && !PsiUtil.isThisReference(qualifier);
    }

    @Nullable
    public static PsiType unwrapClassType(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null || !"java.lang.Class".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiType[] params = ((PsiClassType)type).getParameters();
        if (params.length != 1) {
            return null;
        }
        return params[0];
    }

    public static boolean isAccessible(@NotNull PsiElement place, @NotNull PsiNamedElement namedElement) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "isAccessible"));
        }
        if (namedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedElement", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "isAccessible"));
        }
        if (namedElement instanceof GrField) {
            GrField field = (GrField)namedElement;
            if (PsiUtil.isAccessible(place, field)) {
                return true;
            }
            for (GrAccessorMethod method : field.getGetters()) {
                if (!PsiUtil.isAccessible(place, (PsiMember)method)) continue;
                return true;
            }
            GrAccessorMethod setter = field.getSetter();
            return setter != null && PsiUtil.isAccessible(place, (PsiMember)setter);
        }
        return !(namedElement instanceof PsiMember) || PsiUtil.isAccessible(place, (PsiMember)namedElement);
    }

    public static boolean isStaticsOK(@NotNull PsiElement place, @NotNull PsiNamedElement element, @Nullable PsiElement resolveContext, boolean filterStaticAfterInstanceQualifier) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "isStaticsOK"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "isStaticsOK"));
        }
        if (resolveContext instanceof GrImportStatement) {
            return true;
        }
        if (element instanceof PsiModifierListOwner) {
            return GrStaticChecker.isStaticsOK((PsiModifierListOwner)element, place, resolveContext, filterStaticAfterInstanceQualifier);
        }
        return true;
    }

    public static boolean isMethodCallRef(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "isMethodCallRef"));
        }
        PsiElement element = PsiTreeUtil.skipParentsOfType((PsiElement)ref, (Class[])new Class[]{GrReferenceExpression.class});
        return element instanceof GrMethodCall;
    }

    public static boolean isPartOfFQN(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "isPartOfFQN"));
        }
        if (ref.hasAt()) {
            return false;
        }
        String name = ref.getReferenceName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        return Character.isUpperCase(name.charAt(0)) && !ResolveUtil.isMethodCallRef(ref) || ref.getParent() instanceof GrReferenceExpression && ResolveUtil.isPartOfFQN((GrReferenceExpression)ref.getParent());
    }

    public static boolean canResolveToMethod(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "canResolveToMethod"));
        }
        return ref.hasMemberPointer() || ref.getParent() instanceof GrMethodCall;
    }

    public static boolean processClassDeclarations(@NotNull PsiClass scope, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processClassDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processClassDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processClassDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil", "processClassDeclarations"));
        }
        for (PsiScopeProcessor each : GroovyResolverProcessor.allProcessors(processor)) {
            if (scope.processDeclarations(each, state, lastParent, place)) continue;
            return false;
        }
        return true;
    }

    private static class DuplicateVariablesProcessor
    extends PropertyResolverProcessor {
        private boolean myBorderPassed = false;
        private final boolean myHasVisibilityModifier;

        public DuplicateVariablesProcessor(GrVariable variable) {
            super(variable.getName(), variable);
            this.myHasVisibilityModifier = DuplicateVariablesProcessor.hasExplicitVisibilityModifiers(variable);
        }

        private static boolean hasExplicitVisibilityModifiers(GrVariable variable) {
            GrModifierList modifierList = variable.getModifierList();
            return modifierList != null && modifierList.hasExplicitVisibilityModifiers();
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil$DuplicateVariablesProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil$DuplicateVariablesProcessor", "execute"));
            }
            if (this.myBorderPassed) {
                return false;
            }
            if (element instanceof GrVariable && DuplicateVariablesProcessor.hasExplicitVisibilityModifiers((GrVariable)element) != this.myHasVisibilityModifier) {
                return true;
            }
            if (element instanceof GrBindingVariable) {
                return true;
            }
            return super.execute(element, state);
        }

        @Override
        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil$DuplicateVariablesProcessor", "handleEvent"));
            }
            if (event == DECLARATION_SCOPE_PASSED) {
                this.myBorderPassed = true;
            }
            super.handleEvent(event, associated);
        }
    }
}

