/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;
import org.jetbrains.plugins.groovy.transformations.TransformationResult;

public class TransformationContextImpl
implements TransformationContext {
    @NotNull
    private final GrTypeDefinition myCodeClass;
    private final Set<MethodSignature> mySignatures;
    private final Collection<PsiMethod> myMethods;
    private final Collection<GrField> myFields;
    private final Collection<PsiClass> myInnerClasses;
    private final List<PsiClassType> myImplementsTypes;
    private final List<PsiClassType> myExtendsTypes;

    public TransformationContextImpl(@NotNull GrTypeDefinition codeClass) {
        if (codeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeClass", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "<init>"));
        }
        this.mySignatures = new THashSet(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        this.myMethods = ContainerUtil.newArrayList();
        this.myFields = ContainerUtil.newArrayList();
        this.myInnerClasses = ContainerUtil.newArrayList();
        this.myImplementsTypes = ContainerUtil.newArrayList();
        this.myExtendsTypes = ContainerUtil.newArrayList();
        this.myCodeClass = codeClass;
        ContainerUtil.addAll(this.myFields, (Object[])codeClass.getCodeFields());
        for (GrMethod grMethod : codeClass.getCodeMethods()) {
            for (PsiMethod method : GrClassImplUtil.expandReflectedMethods(grMethod)) {
                this.mySignatures.add(method.getSignature(PsiSubstitutor.EMPTY));
                this.myMethods.add(method);
            }
        }
        ContainerUtil.addAll(this.myInnerClasses, (Object[])codeClass.getCodeInnerClasses());
        ContainerUtil.addAll(this.myImplementsTypes, (Object[])GrClassImplUtil.getReferenceListTypes(codeClass.getImplementsClause()));
        ContainerUtil.addAll(this.myExtendsTypes, (Object[])GrClassImplUtil.getReferenceListTypes(codeClass.getExtendsClause()));
    }

    @Override
    @NotNull
    public GrTypeDefinition getCodeClass() {
        GrTypeDefinition grTypeDefinition = this.myCodeClass;
        if (grTypeDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getCodeClass"));
        }
        return grTypeDefinition;
    }

    @Override
    @NotNull
    public Collection<GrField> getFields() {
        Collection<GrField> collection = this.myFields;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getFields"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiMethod> getMethods() {
        Collection<PsiMethod> collection = this.myMethods;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getMethods"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getInnerClasses() {
        Collection<PsiClass> collection = this.myInnerClasses;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getInnerClasses"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<PsiClassType> getImplementsTypes() {
        List<PsiClassType> list = this.myImplementsTypes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getImplementsTypes"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiClassType> getExtendsTypes() {
        List<PsiClassType> list = this.myExtendsTypes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getExtendsTypes"));
        }
        return list;
    }

    @Override
    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.getCodeClass().getManager();
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getManager"));
        }
        return psiManager;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = (String)ObjectUtils.notNull((Object)this.myCodeClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getClassName"));
        }
        return string;
    }

    @Override
    @Nullable
    public PsiClass getSuperClass() {
        return GrClassImplUtil.getSuperClass(this.getCodeClass(), this.getExtendsListTypesArray());
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation(@NotNull String fqn) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getAnnotation"));
        }
        return PsiImplUtil.getAnnotation((PsiModifierListOwner)this.getCodeClass(), fqn);
    }

    @Override
    @NotNull
    public Collection<PsiMethod> findMethodsByName(@NotNull String name, boolean checkBases) {
        PsiClass aClass;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "findMethodsByName"));
        }
        List methods = ContainerUtil.filter(this.myMethods, m -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "lambda$findMethodsByName$0"));
            }
            return name.equals(m.getName());
        });
        if (checkBases && (aClass = this.getSuperClass()) != null) {
            ContainerUtil.addAll((Collection)ContainerUtil.newArrayList((Iterable)methods), (Object[])aClass.findMethodsByName(name, true));
        }
        List list = methods;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "findMethodsByName"));
        }
        return list;
    }

    private void doAddMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "doAddMethod"));
        }
        if (method instanceof GrLightMethodBuilder) {
            ((GrLightMethodBuilder)method).setContainingClass(this.myCodeClass);
        } else if (method instanceof LightMethodBuilder) {
            ((LightMethodBuilder)method).setContainingClass((PsiClass)this.myCodeClass);
        }
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        if (this.mySignatures.add(signature)) {
            this.myMethods.add(method);
        }
    }

    @Override
    public void addMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "addMethod"));
        }
        for (PsiMethod expanded : GrClassImplUtil.expandReflectedMethods(method)) {
            this.doAddMethod(expanded);
        }
    }

    @Override
    public void addMethods(@NotNull PsiMethod[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "addMethods"));
        }
        for (PsiMethod method : methods) {
            this.addMethod(method);
        }
    }

    @Override
    public void addMethods(@NotNull Collection<? extends PsiMethod> methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "addMethods"));
        }
        for (PsiMethod psiMethod : methods) {
            this.addMethod(psiMethod);
        }
    }

    @Override
    public void removeMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "removeMethod"));
        }
        for (PsiMethod expanded : GrClassImplUtil.expandReflectedMethods(method)) {
            MethodSignature signature = expanded.getSignature(PsiSubstitutor.EMPTY);
            this.mySignatures.remove(signature);
            this.myMethods.removeIf(m -> MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)signature, (Object)m.getSignature(PsiSubstitutor.EMPTY)));
        }
    }

    @Override
    public void addField(@NotNull GrField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "addField"));
        }
        if (field instanceof GrLightField) {
            ((GrLightField)field).setContainingClass(this.getCodeClass());
        }
        this.myFields.add(field);
    }

    @Override
    public void addInnerClass(@NotNull PsiClass innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "addInnerClass"));
        }
        if (innerClass instanceof LightPsiClassBuilder) {
            ((LightPsiClassBuilder)innerClass).setContainingClass((PsiClass)this.getCodeClass());
        }
        this.myInnerClasses.add(innerClass);
    }

    @Override
    public void addInterface(@NotNull PsiClassType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "addInterface"));
        }
        if (this.getCodeClass().isInterface()) {
            this.myExtendsTypes.add(type);
        } else {
            this.myImplementsTypes.add(type);
        }
    }

    @NotNull
    private GrField[] getFieldsArray() {
        GrField[] grFieldArray = this.getFields().toArray(GrField.EMPTY_ARRAY);
        if (grFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getFieldsArray"));
        }
        return grFieldArray;
    }

    @NotNull
    private PsiMethod[] getMethodsArray() {
        PsiMethod[] psiMethodArray = this.getMethods().toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getMethodsArray"));
        }
        return psiMethodArray;
    }

    @NotNull
    private PsiClass[] getInnerClassesArray() {
        PsiClass[] psiClassArray = this.getInnerClasses().toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getInnerClassesArray"));
        }
        return psiClassArray;
    }

    @NotNull
    private PsiClassType[] getImplementsListTypesArray() {
        PsiClassType[] psiClassTypeArray = this.getImplementsTypes().toArray(PsiClassType.EMPTY_ARRAY);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getImplementsListTypesArray"));
        }
        return psiClassTypeArray;
    }

    @NotNull
    private PsiClassType[] getExtendsListTypesArray() {
        PsiClassType[] psiClassTypeArray = this.getExtendsTypes().toArray(PsiClassType.EMPTY_ARRAY);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getExtendsListTypesArray"));
        }
        return psiClassTypeArray;
    }

    @NotNull
    TransformationResult getTransformationResult() {
        TransformationResult transformationResult = new TransformationResult(this.getMethodsArray(), this.getFieldsArray(), this.getInnerClassesArray(), this.getImplementsListTypesArray(), this.getExtendsListTypesArray());
        if (transformationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl", "getTransformationResult"));
        }
        return transformationResult;
    }
}

