/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.types.DescriptorSubstitutor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.SmartSet;

public abstract class FunctionDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements FunctionDescriptor {
    private List<TypeParameterDescriptor> typeParameters;
    private List<ValueParameterDescriptor> unsubstitutedValueParameters;
    private KotlinType unsubstitutedReturnType;
    private ReceiverParameterDescriptor extensionReceiverParameter;
    private ReceiverParameterDescriptor dispatchReceiverParameter;
    private Modality modality;
    private Visibility visibility;
    private boolean isOperator;
    private boolean isInfix;
    private boolean isExternal;
    private boolean isInline;
    private boolean isTailrec;
    private boolean isHidden;
    private boolean hasStableParameterNames;
    private boolean hasSynthesizedParameterNames;
    private Collection<? extends FunctionDescriptor> overriddenFunctions;
    private volatile Function0<Set<FunctionDescriptor>> lazyOverriddenFunctionsTask;
    private final FunctionDescriptor original;
    private final CallableMemberDescriptor.Kind kind;
    @Nullable
    private FunctionDescriptor initialSignatureDescriptor;

    protected FunctionDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @Nullable FunctionDescriptor original, @NotNull Annotations annotations2, @NotNull Name name, @NotNull CallableMemberDescriptor.Kind kind, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations2, name, source);
        this.visibility = Visibilities.UNKNOWN;
        this.isOperator = false;
        this.isInfix = false;
        this.isExternal = false;
        this.isInline = false;
        this.isTailrec = false;
        this.isHidden = false;
        this.hasStableParameterNames = true;
        this.hasSynthesizedParameterNames = false;
        this.overriddenFunctions = null;
        this.lazyOverriddenFunctionsTask = null;
        this.initialSignatureDescriptor = null;
        this.original = original == null ? this : original;
        this.kind = kind;
    }

    @NotNull
    public FunctionDescriptorImpl initialize(@Nullable KotlinType receiverParameterType, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @Nullable KotlinType unsubstitutedReturnType, @Nullable Modality modality, @NotNull Visibility visibility) {
        int i;
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        if (unsubstitutedValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedValueParameters", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        this.typeParameters = CollectionsKt.toReadOnlyList(typeParameters);
        this.unsubstitutedValueParameters = unsubstitutedValueParameters;
        this.unsubstitutedReturnType = unsubstitutedReturnType;
        this.modality = modality;
        this.visibility = visibility;
        this.extensionReceiverParameter = DescriptorFactory.createExtensionReceiverParameterForCallable(this, receiverParameterType);
        this.dispatchReceiverParameter = dispatchReceiverParameter;
        for (i = 0; i < typeParameters.size(); ++i) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
            if (typeParameterDescriptor.getIndex() == i) continue;
            throw new IllegalStateException(typeParameterDescriptor + " index is " + typeParameterDescriptor.getIndex() + " but position is " + i);
        }
        for (i = 0; i < unsubstitutedValueParameters.size(); ++i) {
            int firstValueParameterOffset = 0;
            ValueParameterDescriptor valueParameterDescriptor = unsubstitutedValueParameters.get(i);
            if (valueParameterDescriptor.getIndex() == i + firstValueParameterOffset) continue;
            throw new IllegalStateException(valueParameterDescriptor + "index is " + valueParameterDescriptor.getIndex() + " but position is " + i);
        }
        FunctionDescriptorImpl functionDescriptorImpl = this;
        if (functionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        return functionDescriptorImpl;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "setVisibility"));
        }
        this.visibility = visibility;
    }

    public void setOperator(boolean isOperator) {
        this.isOperator = isOperator;
    }

    public void setInfix(boolean isInfix) {
        this.isInfix = isInfix;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setInline(boolean isInline) {
        this.isInline = isInline;
    }

    public void setTailrec(boolean isTailrec) {
        this.isTailrec = isTailrec;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public void setReturnType(@NotNull KotlinType unsubstitutedReturnType) {
        if (unsubstitutedReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedReturnType", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "setReturnType"));
        }
        if (this.unsubstitutedReturnType != null) {
            // empty if block
        }
        this.unsubstitutedReturnType = unsubstitutedReturnType;
    }

    public void setHasStableParameterNames(boolean hasStableParameterNames) {
        this.hasStableParameterNames = hasStableParameterNames;
    }

    public void setHasSynthesizedParameterNames(boolean hasSynthesizedParameterNames) {
        this.hasSynthesizedParameterNames = hasSynthesizedParameterNames;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getExtensionReceiverParameter() {
        return this.extensionReceiverParameter;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getDispatchReceiverParameter() {
        return this.dispatchReceiverParameter;
    }

    @Override
    @NotNull
    public Collection<? extends FunctionDescriptor> getOverriddenDescriptors() {
        this.performOverriddenLazyCalculationIfNeeded();
        Collection<Object> collection = this.overriddenFunctions != null ? this.overriddenFunctions : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getOverriddenDescriptors"));
        }
        return collection;
    }

    private void performOverriddenLazyCalculationIfNeeded() {
        Function0<Set<FunctionDescriptor>> overriddenTask = this.lazyOverriddenFunctionsTask;
        if (overriddenTask != null) {
            this.overriddenFunctions = overriddenTask.invoke();
            this.lazyOverriddenFunctionsTask = null;
        }
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isOperator() {
        if (this.isOperator) {
            return true;
        }
        for (FunctionDescriptor functionDescriptor : this.getOriginal().getOverriddenDescriptors()) {
            if (!functionDescriptor.isOperator()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInfix() {
        if (this.isInfix) {
            return true;
        }
        for (FunctionDescriptor functionDescriptor : this.getOriginal().getOverriddenDescriptors()) {
            if (!functionDescriptor.isInfix()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public boolean isInline() {
        return this.isInline;
    }

    @Override
    public boolean isTailrec() {
        return this.isTailrec;
    }

    @Override
    public boolean isHiddenToOvercomeSignatureClash() {
        return this.isHidden;
    }

    @Override
    public void setOverriddenDescriptors(@NotNull Collection<? extends CallableMemberDescriptor> overriddenDescriptors) {
        if (overriddenDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenDescriptors", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "setOverriddenDescriptors"));
        }
        this.overriddenFunctions = overriddenDescriptors;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        List<TypeParameterDescriptor> list2 = this.typeParameters;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getTypeParameters"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        List<ValueParameterDescriptor> list2 = this.unsubstitutedValueParameters;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getValueParameters"));
        }
        return list2;
    }

    @Override
    public boolean hasStableParameterNames() {
        return this.hasStableParameterNames;
    }

    @Override
    public boolean hasSynthesizedParameterNames() {
        return this.hasSynthesizedParameterNames;
    }

    @Override
    public KotlinType getReturnType() {
        return this.unsubstitutedReturnType;
    }

    @Override
    @NotNull
    public FunctionDescriptor getOriginal() {
        FunctionDescriptor functionDescriptor = this.original == this ? this : this.original.getOriginal();
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getOriginal"));
        }
        return functionDescriptor;
    }

    @Override
    @NotNull
    public CallableMemberDescriptor.Kind getKind() {
        CallableMemberDescriptor.Kind kind = this.kind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getKind"));
        }
        return kind;
    }

    @Override
    public FunctionDescriptor substitute(@NotNull TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "substitute"));
        }
        if (originalSubstitutor.isEmpty()) {
            return this;
        }
        return this.doSubstitute(this.newCopyBuilder(originalSubstitutor).setOriginal(this.getOriginal()));
    }

    @Nullable
    protected KotlinType getExtensionReceiverParameterType() {
        if (this.extensionReceiverParameter == null) {
            return null;
        }
        return this.extensionReceiverParameter.getType();
    }

    @NotNull
    public CopyConfiguration newCopyBuilder() {
        CopyConfiguration copyConfiguration = this.newCopyBuilder(TypeSubstitutor.EMPTY);
        if (copyConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "newCopyBuilder"));
        }
        return copyConfiguration;
    }

    @NotNull
    private CopyConfiguration newCopyBuilder(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "newCopyBuilder"));
        }
        CopyConfiguration copyConfiguration = new CopyConfiguration(substitutor2, this.getContainingDeclaration(), this.getModality(), this.getVisibility(), this.getKind(), this.getValueParameters(), this.getExtensionReceiverParameterType(), this.getReturnType(), null);
        if (copyConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "newCopyBuilder"));
        }
        return copyConfiguration;
    }

    @Nullable
    protected FunctionDescriptor doSubstitute(@NotNull CopyConfiguration configuration) {
        TypeSubstitutor substitutor2;
        ArrayList<TypeParameterDescriptor> substitutedTypeParameters;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        FunctionDescriptorImpl substitutedDescriptor = this.createSubstitutedCopy(configuration.newOwner, configuration.original, configuration.kind, configuration.name, configuration.preserveSourceElement);
        if (configuration.newTypeParameters == null) {
            List<TypeParameterDescriptor> originalTypeParameters = this.getTypeParameters();
            substitutedTypeParameters = new ArrayList<TypeParameterDescriptor>(originalTypeParameters.size());
            substitutor2 = DescriptorSubstitutor.substituteTypeParameters(originalTypeParameters, configuration.originalSubstitutor.getSubstitution(), substitutedDescriptor, substitutedTypeParameters);
        } else {
            substitutedTypeParameters = configuration.newTypeParameters;
            substitutor2 = configuration.originalSubstitutor;
        }
        KotlinType substitutedReceiverParameterType = null;
        if (configuration.newExtensionReceiverParameterType != null && (substitutedReceiverParameterType = substitutor2.substitute(configuration.newExtensionReceiverParameterType, Variance.IN_VARIANCE)) == null) {
            return null;
        }
        ReceiverParameterDescriptor substitutedExpectedThis = null;
        if (this.dispatchReceiverParameter != null && (substitutedExpectedThis = this.dispatchReceiverParameter.substitute(substitutor2)) == null) {
            return null;
        }
        List<ValueParameterDescriptor> substitutedValueParameters = FunctionDescriptorImpl.getSubstitutedValueParameters(substitutedDescriptor, configuration.newValueParameterDescriptors, substitutor2, configuration.dropOriginalInContainingParts);
        if (substitutedValueParameters == null) {
            return null;
        }
        KotlinType substitutedReturnType = substitutor2.substitute(configuration.newReturnType, Variance.OUT_VARIANCE);
        if (substitutedReturnType == null) {
            return null;
        }
        substitutedDescriptor.initialize(substitutedReceiverParameterType, substitutedExpectedThis, substitutedTypeParameters, substitutedValueParameters, substitutedReturnType, configuration.newModality, configuration.newVisibility);
        substitutedDescriptor.setOperator(this.isOperator);
        substitutedDescriptor.setInfix(this.isInfix);
        substitutedDescriptor.setExternal(this.isExternal);
        substitutedDescriptor.setInline(this.isInline);
        substitutedDescriptor.setTailrec(this.isTailrec);
        substitutedDescriptor.setHasStableParameterNames(this.hasStableParameterNames);
        substitutedDescriptor.setHasSynthesizedParameterNames(this.hasSynthesizedParameterNames);
        substitutedDescriptor.setHidden(configuration.isHiddenToOvercomeSignatureClash);
        if (configuration.signatureChange || this.getInitialSignatureDescriptor() != null) {
            FunctionDescriptor initialSignature = this.getInitialSignatureDescriptor() != null ? this.getInitialSignatureDescriptor() : this;
            FunctionDescriptor initialSignatureSubstituted = initialSignature.substitute(substitutor2);
            substitutedDescriptor.setInitialSignatureDescriptor(initialSignatureSubstituted);
        }
        if (configuration.copyOverrides && !this.getOriginal().getOverriddenDescriptors().isEmpty()) {
            if (configuration.originalSubstitutor.isEmpty()) {
                Function0<Set<FunctionDescriptor>> overriddenFunctionsTask = this.lazyOverriddenFunctionsTask;
                if (overriddenFunctionsTask != null) {
                    substitutedDescriptor.lazyOverriddenFunctionsTask = overriddenFunctionsTask;
                } else {
                    substitutedDescriptor.setOverriddenDescriptors(this.getOverriddenDescriptors());
                }
            } else {
                substitutedDescriptor.lazyOverriddenFunctionsTask = new Function0<Set<FunctionDescriptor>>(){

                    @Override
                    public Set<FunctionDescriptor> invoke() {
                        SmartSet<FunctionDescriptor> result2 = SmartSet.create();
                        for (FunctionDescriptor functionDescriptor : FunctionDescriptorImpl.this.getOverriddenDescriptors()) {
                            result2.add(functionDescriptor.substitute(substitutor2));
                        }
                        return result2;
                    }
                };
            }
        }
        return substitutedDescriptor;
    }

    @NotNull
    protected abstract FunctionDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor var1, @Nullable FunctionDescriptor var2, @NotNull CallableMemberDescriptor.Kind var3, @Nullable Name var4, boolean var5);

    @NotNull
    protected SourceElement getSourceToUseForCopy(boolean preserveSource, @Nullable FunctionDescriptor original) {
        SourceElement sourceElement = preserveSource ? (original != null ? original.getSource() : this.getOriginal().getSource()) : SourceElement.NO_SOURCE;
        if (sourceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getSourceToUseForCopy"));
        }
        return sourceElement;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        return visitor2.visitFunctionDescriptor(this, data);
    }

    @Nullable
    public static List<ValueParameterDescriptor> getSubstitutedValueParameters(FunctionDescriptor substitutedDescriptor, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @NotNull TypeSubstitutor substitutor2, boolean dropOriginal) {
        if (unsubstitutedValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedValueParameters", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getSubstitutedValueParameters"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getSubstitutedValueParameters"));
        }
        ArrayList<ValueParameterDescriptor> result2 = new ArrayList<ValueParameterDescriptor>(unsubstitutedValueParameters.size());
        for (ValueParameterDescriptor unsubstitutedValueParameter : unsubstitutedValueParameters) {
            KotlinType substituteVarargElementType;
            KotlinType substitutedType = substitutor2.substitute(unsubstitutedValueParameter.getType(), Variance.IN_VARIANCE);
            KotlinType varargElementType = unsubstitutedValueParameter.getVarargElementType();
            KotlinType kotlinType = substituteVarargElementType = varargElementType == null ? null : substitutor2.substitute(varargElementType, Variance.IN_VARIANCE);
            if (substitutedType == null) {
                return null;
            }
            result2.add(new ValueParameterDescriptorImpl(substitutedDescriptor, dropOriginal ? null : unsubstitutedValueParameter, unsubstitutedValueParameter.getIndex(), unsubstitutedValueParameter.getAnnotations(), unsubstitutedValueParameter.getName(), substitutedType, unsubstitutedValueParameter.declaresDefaultValue(), unsubstitutedValueParameter.isCrossinline(), unsubstitutedValueParameter.isNoinline(), substituteVarargElementType, SourceElement.NO_SOURCE));
        }
        return result2;
    }

    @Override
    @Nullable
    public FunctionDescriptor getInitialSignatureDescriptor() {
        return this.initialSignatureDescriptor;
    }

    public void setInitialSignatureDescriptor(@Nullable FunctionDescriptor initialSignatureDescriptor) {
        this.initialSignatureDescriptor = initialSignatureDescriptor;
    }

    public class CopyConfiguration {
        @NotNull
        protected TypeSubstitutor originalSubstitutor;
        @NotNull
        protected DeclarationDescriptor newOwner;
        @NotNull
        protected Modality newModality;
        @NotNull
        protected Visibility newVisibility;
        @Nullable
        protected FunctionDescriptor original;
        @NotNull
        protected CallableMemberDescriptor.Kind kind;
        @NotNull
        protected List<ValueParameterDescriptor> newValueParameterDescriptors;
        @Nullable
        protected KotlinType newExtensionReceiverParameterType;
        @NotNull
        protected KotlinType newReturnType;
        @Nullable
        protected Name name;
        protected boolean copyOverrides;
        protected boolean signatureChange;
        protected boolean preserveSourceElement;
        protected boolean dropOriginalInContainingParts;
        private boolean isHiddenToOvercomeSignatureClash;
        private List<TypeParameterDescriptor> newTypeParameters;

        public CopyConfiguration(@NotNull TypeSubstitutor originalSubstitutor, @NotNull DeclarationDescriptor newOwner, @NotNull Modality newModality, @NotNull Visibility newVisibility, @NotNull CallableMemberDescriptor.Kind kind, @NotNull List<ValueParameterDescriptor> newValueParameterDescriptors, @Nullable KotlinType newExtensionReceiverParameterType, @NotNull KotlinType newReturnType, @Nullable Name name) {
            if (originalSubstitutor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "<init>"));
            }
            if (newOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "<init>"));
            }
            if (newModality == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModality", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "<init>"));
            }
            if (newVisibility == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibility", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "<init>"));
            }
            if (newValueParameterDescriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValueParameterDescriptors", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "<init>"));
            }
            if (newReturnType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newReturnType", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "<init>"));
            }
            this.original = null;
            this.copyOverrides = true;
            this.signatureChange = false;
            this.preserveSourceElement = false;
            this.dropOriginalInContainingParts = false;
            this.newTypeParameters = null;
            this.originalSubstitutor = originalSubstitutor;
            this.newOwner = newOwner;
            this.newModality = newModality;
            this.newVisibility = newVisibility;
            this.kind = kind;
            this.newValueParameterDescriptors = newValueParameterDescriptors;
            this.newExtensionReceiverParameterType = newExtensionReceiverParameterType;
            this.newReturnType = newReturnType;
            this.name = name;
            this.isHiddenToOvercomeSignatureClash = FunctionDescriptorImpl.this.isHiddenToOvercomeSignatureClash();
        }

        @NotNull
        protected CopyConfiguration setOwner(@NotNull DeclarationDescriptor owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setOwner"));
            }
            this.newOwner = owner;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setOwner"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setModality(@NotNull Modality modality) {
            if (modality == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setModality"));
            }
            this.newModality = modality;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setModality"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setVisibility(@NotNull Visibility visibility) {
            if (visibility == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setVisibility"));
            }
            this.newVisibility = visibility;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setVisibility"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setKind(@NotNull CallableMemberDescriptor.Kind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setKind"));
            }
            this.kind = kind;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setKind"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setCopyOverrides(boolean copyOverrides) {
            this.copyOverrides = copyOverrides;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setCopyOverrides"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setName(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setName"));
            }
            this.name = name;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setName"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setValueParameters(@NotNull List<ValueParameterDescriptor> parameters2) {
            if (parameters2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setValueParameters"));
            }
            this.newValueParameterDescriptors = parameters2;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setValueParameters"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setTypeParameters(@NotNull List<TypeParameterDescriptor> parameters2) {
            if (parameters2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setTypeParameters"));
            }
            this.newTypeParameters = parameters2;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setTypeParameters"));
            }
            return copyConfiguration;
        }

        public CopyConfiguration setReturnType(@NotNull KotlinType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setReturnType"));
            }
            this.newReturnType = type2;
            return this;
        }

        public CopyConfiguration setExtensionReceiverType(@Nullable KotlinType type2) {
            this.newExtensionReceiverParameterType = type2;
            return this;
        }

        @NotNull
        public CopyConfiguration setOriginal(@NotNull FunctionDescriptor original) {
            if (original == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setOriginal"));
            }
            this.original = original;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setOriginal"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setSignatureChange() {
            this.signatureChange = true;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setSignatureChange"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setPreserveSourceElement() {
            this.preserveSourceElement = true;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setPreserveSourceElement"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setDropOriginalInContainingParts() {
            this.dropOriginalInContainingParts = true;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setDropOriginalInContainingParts"));
            }
            return copyConfiguration;
        }

        @NotNull
        public CopyConfiguration setHidden() {
            this.isHiddenToOvercomeSignatureClash = true;
            CopyConfiguration copyConfiguration = this;
            if (copyConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "setHidden"));
            }
            return copyConfiguration;
        }

        @Nullable
        public FunctionDescriptor build() {
            return FunctionDescriptorImpl.this.doSubstitute(this);
        }

        @Nullable
        public FunctionDescriptor getOriginal() {
            return this.original;
        }

        @NotNull
        public TypeSubstitutor getOriginalSubstitutor() {
            TypeSubstitutor typeSubstitutor2 = this.originalSubstitutor;
            if (typeSubstitutor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl$CopyConfiguration", "getOriginalSubstitutor"));
            }
            return typeSubstitutor2;
        }
    }
}

